C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ----- ----- trstat ----- ----- ----- ----- ----- -

c routine to garner statistical information from mass quantities of
c input traces.  Contributions by Don Wagner and Paul Garossino
c
c Code written by Paul G. A. Garossino

c Changes

c Aug 96: Fixed minimum offset parameter check to be .le. so that
c         routine will function on a dataset with no indexing.
c Garossino

#include <save_defs.h> 
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard usp variables

      integer itr ( SZLNHD )
      integer ns, ne, irs, ire, ist, iend, nsi, JJ, KK
      integer nsamp, nsampo, nrec, nreco, ntrc, ntrco
      integer luin, luout, lbytes, nbytes, obytes, lbyout, argis

      real tri(SZLNHD)

      character name*6, ntap*255, otap*255

      logical verbos

c declare program specific variables

      integer  StaCor, l_StaCor, ln_StaCor, ifmt_StaCor
      integer  DstSgn, l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer  TVPT01, l_TVPT01, ln_TVPT01, ifmt_TVPT01
      integer  TVPT02, l_TVPT02, ln_TVPT02, ifmt_TVPT02
      integer  TVPT03, l_TVPT03, ln_TVPT03, ifmt_TVPT03
      integer  TVPT04, l_TVPT04, ln_TVPT04, ifmt_TVPT04
      integer  TVPT05, l_TVPT05, ln_TVPT05, ifmt_TVPT05
      integer  TVPT06, l_TVPT06, ln_TVPT06, ifmt_TVPT06
      integer  TVPT07, l_TVPT07, ln_TVPT07, ifmt_TVPT07
      integer  NumLiveSamples, index, time_units
      integer  counter, ii, j, length, KilledCounter
      integer  luamp, lufreq, luchar, ludecay, luoffset
      integer  StartSample, lumutefreq, luampratio, luspectralsum
      integer  MinOffset

      real WorkSpace(SZLNHD)
      real DenomTest, Unit, AvgAbsMean, AvgAbsDeviation 
      real MinValue, MaxValue, HistoGram(100), delta, dt
      real MinAmp, MaxAmp, MinFreq, MaxFreq, MinChar, MaxChar, MinDecay
      real MaxDecay, MinFreqAboveMute, MaxFreqAboveMute
      real MinAmpRatio, MaxAmpRatio, MinSpectralSum
      real MaxSpectralSum, NyquistFrequency
      real Tzero, Velocity, MinCutOff, MaxCutOff, HistMax, DotProduct
      real SpectralSumMean, SpecSumDeviation, SpecMinFreq, SpecMaxFreq

      character AmpCurveName*10, FreqCurveName*10 
      character CharacterCurveName*10, DecayCurveName*10
      character OffsetCurveName*10, FreqAboveCurveName*21
      character AmpRatioCurveName*21, SpectralSumCurveName*21
      character LowLimitName*11, HighLimitName*11, NumKilledTraceName*14 

      logical QC

c variables used in dynamic memory allocation

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8
      integer MemoryInBytes, MemoryInSamples, abort

      real AvgAbsAmp, AvgFrequency, MedianCharacter
      real AvgFrequencyAboveMute, AvgAbsAmpRatio
      real decay, KilledOffsets, SpectralSum

      pointer (wkamp, AvgAbsAmp(200000) )
      pointer (wkfreq, AvgFrequency(200000) )
      pointer (wkmed, MedianCharacter(200000) )
      pointer (wkdecay, decay(20000) )
      pointer (wkoffsets, KilledOffsets(20000) )
      pointer (wkmutefreq, AvgFrequencyAboveMute(200000) )
      pointer (wkampratio, AvgAbsAmpRatio(200000) )
      pointer (wkSpectralSum, SpectralSum(200000) )

c initialize variables

      data name /'TRSTAT'/
      data abort/0/

      data AmpCurveName /'"Amplitude'/
      data AmpRatioCurveName /'"Amplitude Ratio'/
      data FreqCurveName /'"Frequency'/
      data FreqAboveCurveName /'"Frequency Above Mute'/
      data CharacterCurveName /'"Character'/
      data DecayCurveName /'"Decay    '/
      data OffsetCurveName /'"Offset'/
      data LowLimitName /'"min cutoff'/
      data HighLimitName /'"max cutoff'/
      data NumKilledTraceName /'"Traces Killed'/
      data SpectralSumCurveName /'"Spectral Sum'/
      data luamp /90/
      data lufreq /91/
      data luchar /92/
      data ludecay /93/
      data luoffset /94/
      data lumutefreq /95/
      data luampratio /96/
      data luspectralsum /97/
      data KilledCounter/0/

c display command line help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help()
          stop
      endif

c open printout file

#include <f77/open.h>

c pick up command line entries

      call cmdln ( ntap, otap, ist, iend, irs, ire, ns, ne, QC, 
     :     MinAmp, MaxAmp, MinFreq, MaxFreq, MinChar, MaxChar, MinDecay,
     :     MaxDecay, MinFreqAboveMute, MaxFreqAboveMute, MinAmpRatio, 
     :     MaxAmpRatio, MinSpectralSum, MaxSpectralSum, SpecMinFreq,
     :     SpecMaxFreq, Tzero, Velocity, MinOffset, verbos)

c open input and output data streams as a function of which mode the
c program is operating in [QC or Execute]

      if (QC) then

c open input dataset

         call getln( luin, ntap, 'r', 0)

c open Xgraph output files 

         if ( ntap .ne. ' ') then

            length = lenth(ntap)
            open ( luamp, file=ntap(1:length)//'.amplitude', 
     :           status='unknown', err=990 )
            open ( lufreq, file=ntap(1:length)//'.frequency', 
     :           status='unknown', err=990 )
            open ( luchar, file=ntap(1:length)//'.character', 
     :           status='unknown', err=990 )
            open ( ludecay, file=ntap(1:length)//'.decay', 
     :           status='unknown', err=990 )
            open ( lumutefreq, file=ntap(1:length)//'.frequencyAbove', 
     :           status='unknown', err=990 )
            open ( luampratio, file=ntap(1:length)//'.amplitudeRatio', 
     :           status='unknown', err=990 )
            open ( luspectralsum, 
     :           file=ntap(1:length)//'.spectralSum', 
     :           status='unknown', err=990 )
         else
            open ( luamp, file='trstat.amplitude', 
     :           status='unknown', err=990 )
            open ( lufreq, file='trstat.frequency', 
     :           status='unknown', err=990 )
            open ( luchar, file='trstat.character', 
     :           status='unknown', err=990 )
            open ( ludecay, file='trstat.decay', 
     :           status='unknown', err=990 )
            open ( lumutefreq, file='trstat.frequencyAbove', 
     :           status='unknown', err=990 )
            open ( luampratio, file='trstat.amplitudeRatio', 
     :           status='unknown', err=990 )
            open ( luspectralsum, file='trstat.spectralSum', 
     :           status='unknown', err=990 )
         endif
      else

c open input and output datasets

         call getln( luin, ntap, 'r', 0)
         call getln( luout, otap, 'w', 1)

c open offset statistics xgraph file

         if ( otap .ne. ' ') then
            length = lenth(otap)
            open ( luoffset, file=otap(1:length)//'.offset', 
     :           status='unknown', err=990 )
         else
            open ( luoffset, file='trstat.offset', 
     :           status='unknown', err=990 )
         endif
      endif

c read input line header

      lbytes = 0
      call rtape( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'TRSTAT: no header written from unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         write(LER,*)' '
         write(LER,*)'TRSTAT: no header written from unit ',ntap
         write(LER,*)'FATAL'
         write(LER,*)'Check existence of file & rerun'
         stop
      endif

c print historical line header to printout file 

      call hlhprt ( itr , lbytes, name, 6, LERR )

c set up pointers for header entries

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('TVPT01',ifmt_TVPT01,l_TVPT01,ln_TVPT01,TRACEHEADER)
      call savelu('TVPT02',ifmt_TVPT02,l_TVPT02,ln_TVPT02,TRACEHEADER)
      call savelu('TVPT03',ifmt_TVPT03,l_TVPT03,ln_TVPT03,TRACEHEADER)
      call savelu('TVPT04',ifmt_TVPT04,l_TVPT04,ln_TVPT04,TRACEHEADER)
      call savelu('TVPT05',ifmt_TVPT05,l_TVPT05,ln_TVPT05,TRACEHEADER)
      call savelu('TVPT06',ifmt_TVPT06,l_TVPT06,ln_TVPT06,TRACEHEADER)
      call savelu('TVPT07',ifmt_TVPT07,l_TVPT07,ln_TVPT07,TRACEHEADER)

c glean USP standard variables from input line header 

#include <f77/saveh.h>

      call saver(itr, 'T_Unit', time_units, LINHED)
      
c determine delta time units

      if ( time_units .eq. 0 ) then
         dt = float(nsi) / 1000.
      elseif ( time_units .eq. 1 ) then
         dt = float(nsi) / 100000.
      endif

      NyquistFrequency = 0.5 / dt

c convert window start and end times to samples

      if ( iend .eq. 0 ) iend = nsamp * nsi
      ist = nint ( float (ist) / float(nsi) ) + 1 
      iend = nint ( float (iend) / float(nsi) ) + 1
      
      if ( iend .gt. nsamp ) iend = nsamp
      if ( ist .gt. nsamp ) ist = nsamp 
      nsampo = iend -  ist +  1

c handle record and trace defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      nreco = ire -irs + 1
      if ( irs .gt. ire) then
         write(LERR,*)' '
         write(LERR,*)'-rs must be less than or equal to -re'
         write(LER,*)' '
         write(LER,*)'TRSTAT: -rs must be less than or equal to -re'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc
      ntrco = ne - ns + 1
      if ( ns .gt. ne) then
         write(LERR,*)' '
         write(LERR,*)'-ns must be less than or equal to -ne'
         write(LER,*)' '
         write(LER,*)'TRSTAT: -ns must be less than or equal to -ne'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif

c dynamic memory allocation

      MemoryInSamples = ( nreco * ntrco + 2 )
      MemoryInBytes = MemoryInSamples * SZSMPD 

      call galloc (wkamp, MemoryInBytes, errcd1, abort)
      call galloc (wkfreq, MemoryInBytes, errcd2, abort)
      call galloc (wkmed, MemoryInBytes, errcd3, abort)
      call galloc (wkdecay, MemoryInBytes, errcd4, abort)
      call galloc (wkoffsets, MemoryInBytes, errcd5, abort)
      call galloc (wkmutefreq, MemoryInBytes, errcd6, abort)
      call galloc (wkampratio, MemoryInBytes, errcd7, abort)
      call galloc (wkSpectralSum, MemoryInBytes, errcd8, abort)

      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or. 
     :     errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or. 
     :     errcd5 .ne. 0 .or. 
     :     errcd6 .ne. 0 .or. 
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate scale storage space:'
         write(LERR,*) 8 * MemoryInBytes,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate scale storage space:'
         write(LER,*) 8 * MemoryInBytes,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating scale storage space:'
         write(LERR,*) 8 * MemoryInBytes,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( AvgAbsAmp, 1, MemoryInSamples )
      call vclr ( AvgFrequency, 1, MemoryInSamples )
      call vclr ( MedianCharacter, 1, MemoryInSamples )
      call vclr ( decay, 1, MemoryInSamples )
      call vclr ( KilledOffsets, 1, MemoryInSamples )
      call vclr ( AvgFrequencyAboveMute, 1, MemoryInSamples )
      call vclr ( AvgAbsAmpRatio, 1, MemoryInSamples )
      call vclr ( SpectralSum, 1, MemoryInSamples )
      call vclr( WorkSpace, 1, SZLNHD)

      if ( .not. QC ) then

c update output dataset line header 

         call savew( itr, 'NumRec', nreco , LINHED)
         call savew( itr, 'NumTrc', ntrco , LINHED)
         call savew( itr, 'NumSmp', nsampo , LINHED)

c udpate historical line header for this application

         call savhlh( itr, lbytes, lbyout )

c write output line header

         call wrtape ( luout, itr, lbyout )

c calculate number of output bytes

         obytes = SZTRHD + SZSMPD * nsampo

      endif

c echo command line and dataset parameters to printout file

      call verbal ( ntap, otap, irs, ire, ns, ne, ist, iend, nrec, 
     :     nreco, ntrc, ntrco, nsamp, nsampo, nsi, QC, MinAmp, MaxAmp, 
     :     MinFreq, MaxFreq, MinChar, MaxChar, MinDecay, MaxDecay, 
     :     MinFreqAboveMute, MaxFreqAboveMute, MinAmpRatio,
     :     MaxAmpRatio, MinSpectralSum, MaxSpectralSum, SpecMinFreq,
     :     SpecMaxFreq, Tzero, Velocity, MinOffset, verbos )

c position pointer at first record to read 

      call recskp ( 1, irs-1, luin, ntrc, itr )

c START PROCESSING

	counter = 0

        DO JJ = irs, ire

c position pointer at first trace of record to read 

           call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

           DO KK = ns, ne

c read trace
              nbytes = 0
              call rtape  ( luin, itr, nbytes )
              if(nbytes .eq. 0) then
                 write(LERR,*)'End of file on input:'
                 write(LERR,*)'Sequential rec= ',JJ,' trace= ',KK
                 go to 999
              endif

c pick up windowed time series 

              call vmov(itr(ITHWP1+ist-1), 1, tri(1), 1, nsampo)

c read required trace header entries

              call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :             StaCor, TRACEHEADER )

c read offset 

              call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :             DstSgn, TRACEHEADER )

c check if trace really is live...otherwise sort routine will puke
c as happened with data from ProMax with no 30000 on dead trace.

                 call dotpr  (tri, 1, tri, 1, DotProduct, nsampo)
                 if (DotProduct .lt. 1.e-30) then
                    StaCor = 30000
                 endif

c process live traces only
              
              IF ( StaCor .ne. 30000 .and. iabs(DstSgn) .ge. MinOffset) 
     :                then

c advance live trace counter

                 counter = counter + 1

c determine number of live samples on this trace

                 NumLiveSamples = 0

c consider analysis start time for this trace

                 if ( ist .eq. 1 ) then
                    StartSample = nint( ( Tzero + float(iabs(DstSgn)) * 
     :                   1000. / Velocity )/ float(nsi)) - ist + 1

c take care of DstSgn being undefined i.e = 0,  when this happens must
c make sure StartSample is not left as zero

                    if ( StartSample .eq. 0 ) StartSample = 1
                 else
                    StartSample = ist
                 endif

                 if (StartSample .gt. nsampo) then
                    write(LERR,*)' '
                    write(LERR,*)'TRSTAT: your analysis velocity is '
                    write(LERR,*)'        too slow,  you have walked'
                    write(LERR,*)'        off the bottom of your data '
                    write(LERR,*)'        at sequential record ',JJ
                    write(LERR,*)'        sequential trace ',KK
                    write(LERR,*)'        Either supply a faster '
                    write(LERR,*)'        velocity or an earlier -t0'
                    write(LERR,*)'FATAL'
                    write(LER,*)' '
                    write(LER,*)'TRSTAT: your analysis velocity is '
                    write(LER,*)'        too slow,  you have walked'
                    write(LER,*)'        off the bottom of your data '
                    write(LER,*)'        at sequential record ',JJ
                    write(LER,*)'        sequential trace ',KK
                    write(LER,*)'        Either supply a faster '
                    write(LER,*)'        velocity or an earlier -t0'
                    write(LER,*)'FATAL'
                    goto 999
                 endif

                 do  ii = StartSample, nsampo
                    if ( tri(ii) .ne. 0.0) then
                       NumLiveSamples = NumLiveSamples + 1
                    endif
                 enddo
                 DenomTest = float ( NumLiveSamples ) 
                 DenomTest = amax1 ( DenomTest, 1.0e-20 )

                 N = nsampo - StartSample + 1

c SPECTRAL SUM

                 call GetSpectralSum(tri(StartSample), N, SpectralSum, 
     :                MemoryInSamples, SpecMinFreq, SpecMaxFreq, 
     :                NyquistFrequency, counter )

c AVERAGE ABSOLUTE AMPLITUDE non-zero windowed samples only


                 call GetAmplitude ( tri(StartSample), N, DenomTest, 
     :                AvgAbsAmp, MemoryInSamples, counter)

c CHARACTER - since median calculation is involved must have more than
c             three samples for this to happen.

                 if ( N .ge. 3 ) then

                    call GetCharacter ( tri(StartSample), N, WorkSpace, 
     :                   MedianCharacter, MemoryInSamples, counter )
                 endif


c COUNT ZERO CROSSINGS AND COMPUTE AVERAGE FREQUENCY both above and below
c mute line if possible

                 call GetFrequency ( tri(StartSample), N, AvgFrequency, 
     :                MemoryInSamples, nsi, counter)

                 if ( StartSample .gt. 3 ) then
                    call GetFrequency ( tri, StartSample, 
     :                   AvgFrequencyAboveMute, MemoryInSamples, nsi, 
     :                   counter)
                 endif

c COMPUTE DECAY RATE

                 call GetDecay ( tri(StartSample), N, decay, 
     :                MemoryInSamples, DenomTest, counter )


C COMPUTE AMPLITUDE RATIO if enough samples above mute line defined by
c t0 and v from the command line

                 if ( StartSample .gt. 3 ) then

                    do  ii = 1, StartSample
                       if ( tri(ii) .ne. 0.0) then
                          NumLiveSamples = NumLiveSamples + 1
                       endif
                    enddo
                    DenomTest = float ( NumLiveSamples ) 
                    DenomTest = amax1 ( DenomTest, 1.0e-20 )

                    call GetAmplitude ( tri, StartSample, DenomTest, 
     :                   AvgAbsAmpRatio, MemoryInSamples, counter)
                    if ( AvgAbsAmp(counter) .gt. 1.e-30 ) then
                       AvgAbsAmpRatio(counter) = AvgAbsAmpRatio(counter) 
     :                       / AvgAbsAmp(counter)
                    else
                       AvgAbsAmpRatio(counter) = 0.0
                    endif
                 endif

                 if ( .not. QC ) then

C KILL TRACE IF SPECTRAL SUM KILL CRITERIA ARE USED AND MET

                    if ( MaxSpectralSum .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000 ) then
                       if ( ( SpectralSum(counter) .lt. 
     :                      MinSpectralSum) 
     :                      .or. 
     :                      ( SpectralSum(counter) .gt. 
     :                      MaxSpectralSum )) then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c fill out data for killed trace histogram

                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF AMPLITUDE KILL CRITERIA ARE USED AND MET

                    if ( abs (MaxAmp) .gt. 1.e-30 ) then
                       if ( AvgAbsAmp(counter) .lt. MinAmp .or. 
     :                      AvgAbsAmp(counter) .gt. MaxAmp ) then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c fill out data for killed trace histogram

                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF AMPLITUDE RATIO KILL CRITERIA ARE USED AND MET

                    if ( abs (MaxAmpRatio) .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000 ) then
                       if ( AvgAbsAmpRatio(counter) .lt. MinAmpRatio 
     :                      .or. 
     :                      AvgAbsAmpRatio(counter) .gt. MaxAmpRatio ) 
     :                      then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c fill out data for killed trace histogram

                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF CHARACTER KILL CRITERIA ARE USED AND MET

                    if ( abs ( MinChar ) .gt. 1.e-30 .and. 
     :                   abs (MaxChar) .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000 .and. N .gt. 3 ) then
                       if ( MedianCharacter(counter) .lt. MinChar .or. 
     :                      MedianCharacter(counter) .gt. MaxChar ) then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c read offset for KilledOffsets file

                          call saver2( itr, ifmt_DstSgn, l_DstSgn,  
     :                         ln_DstSgn, DstSgn, TRACEHEADER )
                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF FREQUENCY KILL CRITERIA ARE USED AND MET, Here a MinFreq
c of zero hz is probable so don't exclude it from usage with a zero test

                    if ( abs (MaxFreq) .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000) then
                       if ( AvgFrequency(counter) .lt. MinFreq .or. 
     :                      AvgFrequency(counter) .gt. MaxFreq ) then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c read offset for KilledOffsets file

                          call saver2( itr, ifmt_DstSgn, l_DstSgn,  
     :                         ln_DstSgn, DstSgn, TRACEHEADER )
                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF FREQUENCY ABOVE MUTE KILL CRITERIA ARE USED AND MET, 
c Here a MinFreqAboveMute of zero hz is probable so don't exclude it 
c from usage with a zero test

                    if ( abs (MaxFreqAboveMute) .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000 ) then
                       if ( AvgFrequencyAboveMute(counter) .lt. 
     :                      MinFreqAboveMute 
     :                      .or. 
     :                      AvgFrequencyAboveMute(counter) .gt. 
     :                      MaxFreqAboveMute)
     :                      then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c read offset for KilledOffsets file

                          call saver2( itr, ifmt_DstSgn, l_DstSgn,  
     :                         ln_DstSgn, DstSgn, TRACEHEADER )
                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

C KILL TRACE IF DECAY KILL CRITERIA ARE USED AND MET. Here a MaxDecay of
c zero is quite probable so don't exclude it from usage

                    if ( abs ( MinDecay ) .gt. 1.e-30 .and. 
     :                   StaCor .ne. 30000 ) then
                       if ( decay(counter) .lt. MinDecay .or. 
     :                      decay(counter) .gt. MaxDecay ) then
                          call vclr(tri, 1, nsampo)
                          StaCor = 30000

c read offset for KilledOffsets file

                          call saver2( itr, ifmt_DstSgn, l_DstSgn,  
     :                         ln_DstSgn, DstSgn, TRACEHEADER )
                          KilledCounter = KilledCounter + 1
                          KilledOffsets(KilledCounter) = float(DstSgn)
                       endif
                    endif

c store results in trace header

                    TVPT01 = nint( amin1 ( AvgAbsAmp(counter), 
     :                   32768.0 ) )
                    TVPT02 = nint( amin1 (AvgFrequency(counter), 
     :                   32768.0 ) )
                    TVPT03 = nint( amin1( MedianCharacter(counter), 
     :                   32768.0 ) )
                    TVPT04 = nint( amin1( decay(counter), 
     :                   32768.0 ) )
                    TVPT05 = nint( amin1( AvgFrequencyAboveMute(counter)
     :                   , 32768.0 ) )
                    TVPT06 = nint( amin1( AvgAbsAmpRatio(counter), 
     :                   32768.0 ) )
                    TVPT07 = nint( amin1( SpectralSum(counter), 
     :                   32768.0 ) )
                 
                    call savew2( itr, ifmt_TVPT01, l_TVPT01, ln_TVPT01, 
     :                   TVPT01, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT02, l_TVPT02, ln_TVPT02, 
     :                   TVPT02, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT03, l_TVPT03, ln_TVPT03, 
     :                   TVPT03, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT04, l_TVPT04, ln_TVPT04, 
     :                   TVPT04, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT05, l_TVPT05, ln_TVPT05, 
     :                   TVPT05, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT06, l_TVPT06, ln_TVPT06, 
     :                   TVPT06, TRACEHEADER )
                    call savew2( itr, ifmt_TVPT07, l_TVPT07, ln_TVPT07, 
     :                   TVPT07, TRACEHEADER )
                    call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :                   StaCor, TRACEHEADER )
                 endif
              ELSE
                 if (StaCor .eq. 30000) then
                    call savew2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :                   StaCor, TRACEHEADER )
                    call vclr ( tri, 1, nsampo )
                 endif
              ENDIF

              if ( .not. QC ) then

c write output trace

                 call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
                 call wrtape (luout, itr, obytes ) 
              endif
           ENDDO

c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

        ENDDO

        if ( QC ) then

c debug
c           write(LER,*)' '
c           write(LER,*)' finished processing, starting reporting'
c           write(LER,*)' '
c debug

c processing finished : report global statistics

C REPORT SPECTRAL SUM STATS
c ----------------------

c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting spectral sum'
c           write(LER,*)' '
c debug
           call meanv ( SpectralSum, 1, SpectralSumMean, counter )
           SpecSumDeviation = 0.0
           do j = 1, counter

              if ( SpectralSum(j) .ge. 1.e-30 ) then
                 SpecSumDeviation = abs ( SpectralSum(j) - 
     :                SpectralSumMean ) + SpecSumDeviation
              endif
           enddo

           SpecSumDeviation = SpecSumDeviation / float ( counter )

c           call maxv(SpectralSum, 1, MaxValue, index, counter )
           call minv(SpectralSum, 1, MinValue, index, counter )

c           MinValue = SpectralSumMean - SpecSumDeviation
           MaxValue = SpectralSumMean + 8.0 * SpecSumDeviation
           
           call vclr ( HistoGram, 1, 100 )
           call hist (SpectralSum, 1, HistoGram, counter, 100, 
     :          MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write spectral sum xgraph file

           call maxv(SpectralSum, 1, MaxValue, index, counter )
           write( luspectralsum, 15 ) SpectralSumCurveName, 
     :          MinValue, MaxValue
c 15        format(a21,' min ',e10.3,' max ',e10.3)

           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(luspectralsum,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude ratio cutoffs

           MinCutOff = -1.e30
           MaxCutOff = 1.e30

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(luspectralsum,'(/)')
           write(luspectralsum,20)LowLimitName,MinCutOff
           write(luspectralsum,*) MinCutOff, 0.0
           write(luspectralsum,*) MinCutOff, HistMax

c write highcut curve

           write(luspectralsum,'(/)')
           write(luspectralsum,20)HighLimitName,MaxCutOff
           write(luspectralsum,*) MaxCutOff, 0.0
           write(luspectralsum,*) MaxCutOff, HistMax

           close(luspectralsum)

C REPORT AMPLITUDE STATS
c ----------------------
                 
c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting amp stats'
c           write(LER,*)' '
c debug

           call meanv ( AvgAbsAmp, 1, AvgAbsMean, counter )
           AvgAbsDeviation = 0.0
           do j = 1, counter
              if ( AvgAbsAmp(j) .ge. 1.e-30 ) then
                 AvgAbsDeviation = abs( AvgAbsAmp(j) - AvgAbsMean ) + 
     :                AvgAbsDeviation
              endif
           enddo
           AvgAbsDeviation = AvgAbsDeviation / float(counter)
           MinValue = AvgAbsMean - AvgAbsDeviation
           MaxValue = AvgAbsMean + 3.0 * AvgAbsDeviation
           call vclr ( HistoGram, 1, 100 )
           call hist (AvgAbsAmp, 1, HistoGram, counter, 100, MaxValue, 
     :          MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write amplitude xgraph file

           write( luamp, 10 ) AmpCurveName, MinValue, MaxValue
 10        format(a10,' min ',e10.3,' max ',e10.3)
           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(luamp,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude cutoffs

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(luamp,'(/)')
           write(luamp,20)LowLimitName,MinCutOff
 20        format(a11,1x,e10.3)
           write(luamp,*) MinCutOff, 0.0
           write(luamp,*) MinCutOff, HistMax

c write highcut curve, low side 

           write(luamp,'(/)')
           write(luamp,20)HighLimitName,MaxCutOff
           write(luamp,*) MaxCutOff, 0.0
           write(luamp,*) MaxCutOff, HistMax

           close(luamp)

C REPORT AMPLITUDE RATIO STATS
c ----------------------------
                 
c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting amp ratio stats'
c           write(LER,*)' '
c debug
           call maxv(AvgAbsAmpRatio, 1, MaxValue, index, counter )
           call minv(AvgAbsAmpRatio, 1, MinValue, index, counter )

           call vclr ( HistoGram, 1, 100 )
           call hist (AvgAbsAmpRatio, 1, HistoGram, counter, 100, 
     :          MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write amplitude ratio xgraph file

           write( luampratio, 15 ) AmpRatioCurveName, MinValue, MaxValue
 15        format(a21,' min ',e10.3,' max ',e10.3)

           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(luampratio,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude ratio cutoffs

           MinCutOff = -1.e30
           MaxCutOff = 1.e30

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(luampratio,'(/)')
           write(luampratio,20)LowLimitName,MinCutOff
           write(luampratio,*) MinCutOff, 0.0
           write(luampratio,*) MinCutOff, HistMax

c write highcut curve

           write(luampratio,'(/)')
           write(luampratio,20)HighLimitName,MaxCutOff
           write(luampratio,*) MaxCutOff, 0.0
           write(luampratio,*) MaxCutOff, HistMax

           close(luampratio)

C REPORT AVERAGE FREQUENCY STATS
c ------------------------------
                 
c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting avg freq stats'
c           write(LER,*)' '
c debug
           call maxv(AvgFrequency, 1, MaxValue, index, counter )
           call minv(AvgFrequency, 1, MinValue, index, counter )

           call vclr ( HistoGram, 1, 100 )
           call hist ( AvgFrequency, 1, HistoGram, counter, 100, 
     :          MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write frequency xgraph file

           write( lufreq, 10 ) FreqCurveName, MinValue, MaxValue
           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(lufreq,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude cutoffs

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(lufreq,'(/)')
           write(lufreq,20)LowLimitName,MinCutOff
           write(lufreq,*) MinCutOff, 0.0
           write(lufreq,*) MinCutOff, HistMax

c write highcut curve

           write(lufreq,'(/)')
           write(lufreq,20)HighLimitName,MaxCutOff
           write(lufreq,*) MaxCutOff, 0.0
           write(lufreq,*) MaxCutOff, HistMax

           close(lufreq)
           
C REPORT AVERAGE FREQUENCY ABOVE THE MUTE LINE STATS
c --------------------------------------------------
                 
c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting avg freq above mute stats'
c           write(LER,*)' '
c debug
           call maxv(AvgFrequencyAboveMute, 1, MaxValue, index, counter)
           call minv(AvgFrequencyAboveMute, 1, MinValue, index, counter)

           call vclr ( HistoGram, 1, 100 )
           call hist ( AvgFrequencyAboveMute, 1, HistoGram, counter, 100
     :          , MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write frequency above mute line xgraph file

           write( lumutefreq, 15 ) FreqAboveCurveName, MinValue, 
     :          MaxValue

           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(lumutefreq,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude cutoffs

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(lumutefreq,'(/)')
           write(lumutefreq,20)LowLimitName,MinCutOff
           write(lumutefreq,*) MinCutOff, 0.0
           write(lumutefreq,*) MinCutOff, HistMax

c write highcut curve

           write(lumutefreq,'(/)')
           write(lumutefreq,20)HighLimitName,MaxCutOff
           write(lumutefreq,*) MaxCutOff, 0.0
           write(lumutefreq,*) MaxCutOff, HistMax

           close(lumutefreq)
           
C REPORT CHARACTER STATS
c ----------------------
                 
c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting character stats'
c           write(LER,*)' '
c debug

           call maxv(MedianCharacter, 1, MaxValue, index, counter )
           call minv(MedianCharacter, 1, MinValue, index, counter )

           call vclr ( HistoGram, 1, 100 )
           call hist ( MedianCharacter, 1, HistoGram, counter, 100, 
     :          MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write character xgraph file

           write(luchar,10) CharacterCurveName, MinValue, MaxValue
           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(luchar,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude cutoffs

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(luchar,'(/)')
           write(luchar,20)LowLimitName,MinCutOff
           write(luchar,*) MinCutOff, 0.0
           write(luchar,*) MinCutOff, HistMax

c write highcut curve

           write(luchar,'(/)')
           write(luchar,20)HighLimitName,MaxCutOff
           write(luchar,*) MaxCutOff, 0.0
           write(luchar,*) MaxCutOff, HistMax

           close(luchar)

C REPORT DECAY STATS
c ------------------

c debug
c           write(LER,*)' '
c           write(LER,*)'  reporting decay stats'
c           write(LER,*)' '
c debug

                 
           call maxv(decay, 1, MaxValue, index, counter )
           call minv(decay, 1, MinValue, index, counter )
           

c POLICEMAN - bad traces that end in zeroes for instance blow the limits of the histogram out
c             of the water.  This fixes that situation somewhat.  A better fix may need to be found
c             in the future.

           if ( MinValue .lt. -120.0 ) MinValue = -120.0

           call vclr ( HistoGram, 1, 100 )
           call hist ( decay, 1, HistoGram, counter, 100, MaxValue, 
     :          MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write decay xgraph file

           write(ludecay,10) DecayCurveName, MinValue, MaxValue
           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(ludecay,*) Unit, HistoGram(j)
           enddo

c find 2% of max histogram amplitude cutoffs

           call Cutoffs ( Histogram, 100, 2.0, MinValue, delta, 
     :          MinCutOff, MaxCutOff, HistMax )

c write lowcut curve

           write(ludecay,'(/)')
           write(ludecay,20)LowLimitName,MinCutOff
           write(ludecay,*) MinCutOff, 0.0
           write(ludecay,*) MinCutOff, HistMax

c write highcut curve

           write(ludecay,'(/)')
           write(ludecay,20)HighLimitName,MaxCutOff
           write(ludecay,*) MaxCutOff, 0.0
           write(ludecay,*) MaxCutOff, HistMax

           close(ludecay)
        else

C REPORT KILLED OFFSETS
c ---------------------

           call maxv(KilledOffsets, 1, MaxValue, index, KilledCounter )
           call minv(KilledOffsets, 1, MinValue, index, KilledCounter )

           call vclr ( HistoGram, 1, 100 )
           call hist ( KilledOffsets, 1, HistoGram, KilledCounter, 100, 
     :          MaxValue, MinValue )
           delta = ( MaxValue - MinValue ) / 100.0

c write killed offsets xgraph file

           write(luoffset,10) OffsetCurveName, MinValue, MaxValue
           do j = 1,100 
              Unit = MinValue + delta * float(j-1)
              write(luoffset,*) Unit, HistoGram(j)
           enddo

c write total number of traces killed

           write(luoffset,'(/)')
           write(luoffset,21)NumKilledTraceName, float(KilledCounter)
 21        format(a14,1x,e10.3)
           write(luoffset,*)' 0.0 0.0'
           close(luoffset)

        endif

C NORMAL COMPLETION

        write(LERR,*)' '
        write(LERR,*)' Normal Completion'
        write(LERR,*)' processed ',nreco,' records'
        write(LER,*)'trstat: Normal Completion'

c close associated files

        if ( QC ) then
           call lbclos(luin)
        else
           call lbclos (luin)
           call lbclos (luout)
        endif
        stop

C ABNORMAL COMPLETION

 990    continue
        write(LERR,*) ' ' 
        write(LERR,*) ' TRSTAT: error opening xgraph file: '
        write(LERR,*) '         check read/write permissions'
        write(LERR,*) '         and rerun'
        write(LERR,*) ' FATAL'        
        write(LER,*) ' ' 
        write(LER,*) ' TRSTAT: error opening xgraph file: '
        write(LER,*) '         check read/write permissions'
        write(LER,*) '         and rerun'
        write(LER,*) ' FATAL' 
        stop

 999    continue
        write(LERR,*)'trstat: Abnormal Completion'
        write(LER,*)'trstat: Abnormal Completion'

        if ( QC ) then
           close(luamp)
           close(lufreq)
           close(luchar)
           close(ludecay)
           close(lumutefreq)
           close(luampratio)
           close(luspectralsum)
           call lbclos(luin)
        else
           call lbclos (luin)
           call lbclos (luout)
        endif
        stop
	end

