C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (ntap, otap, irs, ire, ns, ne, ist, iend, nrec, 
     :     nreco, ntrc, ntrco, nsamp, nsampo, nsi, QC, MinAmp, MaxAmp, 
     :     MinFreq, MaxFreq, MinChar, MaxChar, MinDecay, MaxDecay, 
     :     MinFreqAboveMute, MaxFreqAboveMute, MinAmpRatio,
     :     MaxAmpRatio, MinSpectralSum, MaxSpectralSum, SpecMinFreq,
     :     SpecMaxFreq, Tzero, Velocity, MinOffset, verbos  )


#include <f77/iounit.h>

      integer     ist, iend, irs, ire, ns ,ne, nrec, nreco, ntrc, ntrco
      integer     nsamp, nsampo, nsi, MinOffset

      real MinAmp, MaxAmp, MinFreq, MaxFreq, MinChar, MaxChar, MinDecay
      real MinFreqAboveMute, MaxFreqAboveMute, MinAmpRatio, MaxAmpRatio
      real MaxDecay, MinSpectralSum, MaxSpectralSum, SpecMinFreq
      real SpecMaxFreq, Velocity, Tzero

      character   ntap*255, otap*255

      logical     verbos, QC

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      if ( .not. QC ) write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', ire 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      if ( ist .ne. 1 ) then
         write(LERR,*) ' processing sample start = ', ist
         write(LERR,*) ' processing sample end   = ', iend
      else
         write(LERR,*) ' analysis start time = ', Tzero
         write(LERR,*) ' analysis velocity   = ', Velocity
      endif
      write(LERR,*) ' Mininum Offset to Operate on = ', MinOffset
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '

      if ( QC ) then
         write(LERR,*)' In Quality Control Mode'
      else
         write(LERR,*)' In Application Mode'
         write(LERR,*)' '
         write(LERR,*)' minimum amplitude = ',MinAmp
         write(LERR,*)' maximum amplitude = ',MaxAmp
         write(LERR,*)' minimum amplitude ratio = ',MinAmpRatio
         write(LERR,*)' maximum amplitude ratio = ',MaxAmpRatio
         write(LERR,*)' minimum character = ',MinChar
         write(LERR,*)' maximum character = ',MaxChar
         write(LERR,*)' minimum frequency = ',MinFreq
         write(LERR,*)' maximum frequency = ',MaxFreq
         write(LERR,*)' minimum frequency above mute = ',
     :        MinFreqAboveMute
         write(LERR,*)' maximum frequency above mute = ',
     :        MaxFreqAboveMute
         write(LERR,*)' minimum decay = ',MinDecay
         write(LERR,*)' maximum decay = ',MaxDecay
         write(LERR,*)' minimum spectral sum = ',MinSpectralSum
         write(LERR,*)' maximum spectral sum = ',MaxSpectralSum
         write(LERR,*)' minimum spectral frequency = ',SpecMinFreq
         write(LERR,*)' maximum spectral frequency = ',SpecMaxFreq
      endif

      return
      end
