C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
***********************************************************************
      program TSTRETCH
c_______________________________________________________________________
c     resample an irregularly sampled depth section to obtain a regularly	c     sampled time section using an auxilliary depth/traveltime map.
c                                 Kurt J. Marfurt
c                                   1/15/92
c     heavily modified to allow for floating datum plane. (KJM, 8/22/96)
c_______________________________________________________________________
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <save_defs.h>
      parameter (maxs  = 0 000 002)
      dimension s(maxs)
      pointer  (pntrs , s )
C
      parameter (undefined=-1.234567e+20)
      integer   argis
      integer   stderr
C
      integer   sheader(SZLNHD)
      integer   twtheader(SZLNHD)
      integer   firstcrp,lastcrp
c
      character*(80) file_reg,file_irreg
      character*(80) file_twt
C
      logical      query
      logical      verbose
      character*8  name 
c_____________________________________________________________________
c     make interpolation divisions a multiple of 64 to optimize  
c     cray memory addressing.
c     6 point interpolator will loop from -2 to +3.
c_____________________________________________________________________
      parameter (ndiv=128,iws=-2,iwe=+3)
c
      data name     /'TSTRETCH'/
c
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
c_____________________________________________________________________
c     get online help if necessary
c_____________________________________________________________________
      stderr=ler
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help(ler)
         call exit(0)
      endif
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>
c_____________________________________________________________________
c     read command line arguements
c_____________________________________________________________________
      verbose=(argis('-V') .gt. 0)
      call argstr('-N' ,file_irreg, ' ', ' ')
      call argstr('-O' ,file_reg, ' ', ' ')
      call argstr('-T',file_twt,' ',' ')
c_____________________________________________________________________
c     open input and output seismic worktapes.
c_____________________________________________________________________
      call getln(luirreg,file_irreg,'r',0)
      call getln(lureg,file_reg,'w',1)
      write(lerr,'(A20,A10,t40,a50)') 'FILE UNIT', 'VALUE','FILE NAME'
      write(lerr,'(A20,I10,t40,a50)')
     2     'luirreg',luirreg,file_irreg,
     2     'lureg',lureg,file_reg
c_____________________________________________________________________
c     read in irregular seismic worktape header.
c_____________________________________________________________________
      lensh=0
      call rtape(luirreg,sheader,lensh)
      call hlhprt(sheader,lensh,name,len(name),lerr)
c______________________________________________________________________
c     extract relevant information from the seismic line header.
c______________________________________________________________________
      call saver(sheader,'NumTrc',ntr_seismic,LINEHEADER)
      call saver(sheader,'NumSmp',nz_seismic,LINEHEADER)
      call saver(sheader,'NumRec',nrec_seismic,LINEHEADER)
      call saver(sheader,'Dx1000',idcrp_1000,LINEHEADER)
      call saver(sheader,'MnDpIn',firsctcrp,LINEHEADER)
      call saver(sheader,'MxDpIn',lastcrp,LINEHEADER)
      dcrp=.001*idcrp_1000
c______________________________________________________________________
c     two line header words were stolen to store information necessary for
c     stretching to time sections using routine tstretch:
c
c     OrNTRC.......original trace length in time samples.
c     OrNREC.......original time sample increment.
c______________________________________________________________________
      call saver(sheader,'OrNTRC',nt,LINEHEADER)
      call saver(sheader,'OrNREC',nsi,LINEHEADER)
      dtmsec_tape=nsi
      tmax_tape=nsi*nt
      call argr4('-tmin',tmin,0.0,0.0)
      call argr4('-tmax',tmax,0.0,0.0)
      call argr4('-dt',dtmsec,0.0,0.0)
      write(stderr,*) 'dtmsec,dtmsec_tape ',dtmsec,dtmsec_tape
      if (dtmsec .eq. 0.0) dtmsec = dtmsec_tape
      if (tmax .eq. 0.0) tmax = tmax_tape
      dteql=dtmsec
      minsamp=nint(tmin/dteql)
      maxsamp=nint(tmax/dteql)
      nteql=maxsamp-minsamp+1
      ierror=0
      if(dtmsec .eq. 0.) then
         write(lerr,*) 'error in routine TSTRETCH'
         write(lerr,*) 'output depth increment dt is undefined'
         write(lerr,*) 'enter value after -dt option.'
         ierror=ierror+1
      endif
      if(tmax .le. tmin) then
         write(lerr,*) 'error in routine TSTRETCH'
         write(lerr,*) 'tmin = ',tmin,' exceeds tmax = ',tmax    
         write(lerr,*) 'check values after -tmin and -tmax options.'
         ierror=ierror+1
      endif
      if(ierror .gt. 0) then
         write(lerr,*) 'routine TSTRETCH aborted due to command'
     1                 //' line errors'
         close(lerr)
         call exit(667)
      endif
c
      nz=nz_seismic-1
C_______________________________________________________________________
c     read in the irregular sampling control information.
c     once the (possibly piped) seismic line header for luirreg can be
c     read, the twt worktape has been closed by routine SAMMIG.
C_______________________________________________________________________
      if(file_twt .ne. ' ') then
         call lbopen(lutwt,file_twt,'r')
         write(lerr,*) 'file_twt = ',file_twt,'   lutwt = ',lutwt
      else
         write(lerr,*) 'error in routine TSTRETCH'
         write(lerr,*) 'must enter name of twt worktape after -T option'
         close(lerr)
         call exit(668)
       endif
      lentwth  = 0
      call rtape(lutwt,twtheader,lentwth)
c***********************************************************************
C     pull input data parameters off the line header.
C***********************************************************************
      call saver(twtheader,'NumTrc',nxgrid,LINEHEADER)
      call saver(twtheader,'NumSmp',nz_twt,LINEHEADER)
      call saver(twtheader,'NumRec',nrec_vel,LINEHEADER)
      call saver(twtheader,'MnTrOf',jval,LINEHEADER)
      xvo=jval

      ioerror=0
      if(nz_twt .ne. nz_seismic) then
         write(lerr,*) 'nz_twt different from nz_seismic!'   
         write(lerr,*) 'should be consistent!'                     
         ioerror=ioerror+1
      endif
c
      write(lerr,'(a30,i10)') 'nrec_seismic',nrec_seismic
      write(lerr,'(a30,i10)') 'ntr_seismic',ntr_seismic                 
      write(lerr,'(a30,i10)') 'nxgrid',nxgrid               
      write(lerr,'(a30,i10)') 'minsamp',minsamp,'maxsamp',maxsamp,
     1                        'nteql',nteql
      write(lerr,'(a30,i10)') 'nz_seismic',nz_seismic
      write(lerr,'(a30,i10)') 'nz_twt',nz_twt
      write(lerr,'(a30,i10)') 'firstcrp',firstcrp,'lastcrp',lastcrp
      write(lerr,'(a30,f15.4)') 'tmin',tmin,'tmax',tmax,
     1               'dtmsec',dtmsec,'dteql',dteql,'dcrp',dcrp    
     
      call icompare(nz_twt,nz_seismic,'input two way traveltime file', 
     1             'input seismic data file','nsamp',ierror,lerr)
      if(ioerror .ne. 0) then
         write(lerr,*) 'routine tstretch terminated due to ',ioerror,
     1                 ' data incompatabilities'
         close(lerr)
         call exit(666)
      endif
c________________________________________________________________________
c     nz.......input depth length in irregularly spaced samples
c     nzbuf....augmented input arrays allowing for operator edges.
c     nteql....output depth length in equally spaced samples
c________________________________________________________________________
      nzbuf=nz+3
      if(nteql .lt. 10) then
         write(lerr,*) 'error in routine tstretch. nteql = ',nteql
         write(lerr,*) 'dtmsec = ',dtmsec,' msec'
         write(lerr,*) 'tmax  = ',tmax ,' msec'
         write(lerr,*) 'enter paramters in consistent units!'
      endif
       
      if(verbose) then
         write(lerr,'(a20,a20)') 'variable','value'
         write(lerr,'(a20,i20)') 'nteql',nteql,'nz',nz,'nzbuf',nzbuf
      endif
C
      l_free=1
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'variable name','begin','end','length'
c
      call mapmem('twt_grid',l_twt_grid,l_free,(ITRWRD+nz+1)*nxgrid,
     1             lerr)
      call mapmem('twt_interp',l_twt_interp,l_free,(nz+1),lerr)
      call mapmem('lefttwt',l_lefttwt,l_free,
     1               (lastcrp-firstcrp+1)*nteql,lerr)
      call mapmem('idiv',l_idiv,l_free,
     1               (lastcrp-firstcrp+1)*nteql,lerr)
      call mapmem('xgrid',l_xgrid,l_free,nxgrid,lerr)
      call mapmem('icrp_seismic',l_icrp_seismic,l_free,
     1                       ntr_seismic,lerr)
      call mapmem('tapbuf',l_tapbuf,l_free,ITRWRD+nteql,lerr)
      call mapmem('ueql',l_ueql,l_free,
     1                       ntr_seismic*nteql,lerr)
      call mapmem('uirreg',l_uirreg,l_free,
     1                       ntr_seismic*(ITRWRD+nzbuf+1),lerr)
      call mapmem('w',l_w,l_free,6*(ndiv+1),lerr)
C_______________________________________________________________________
C     allocate dynamic memory.                      
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for TSTRETCH: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(stderr,'(//,a)') 'allocate dynamic memory for TSTRETCH: '
      write(stderr,*) 1.e-6*lens,' Mwords'
      write(stderr,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'   
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program TSTRETCH aborted'
         close(lerr)
         call exit(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens       
C_______________________________________________________________________
C     calculate 6 point lagrange interpolation weights for ndiv
c     possible interpolation divisions.
C_______________________________________________________________________
      call getw6(s(l_w),ndiv)
C_______________________________________________________________________
c     read in two-way traveltime worktape.
c     calculate interpolation weights for all possible crp positions.
C_______________________________________________________________________
      call rdtwt(s(l_twt_grid),s(l_twt_interp),s(l_lefttwt),s(l_idiv),
     1           s(l_xgrid),ITRWRD,nz,nxgrid,dteql,ndiv,
     2           firstcrp,lastcrp,minsamp,maxsamp,
     3           ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER,
     4           dcrp,lerr,lutwt)
C_______________________________________________________________________
C     write lineheaders for output files.     
C_______________________________________________________________________
      nsi=nint(dtmsec)
      call savew(sheader,'SmpInt',nsi,LINEHEADER)
      call savew(sheader,'NumSmp',nteql,LINEHEADER)
      call savew(sheader,'TmMsFS',tmin,LINEHEADER)
      call savhlh(sheader,lensh,lbyout)
      call wrtape(lureg,sheader,lbyout)
c
      nbytes_out=(ITRWRD+nteql)*szsmpd
C_______________________________________________________________________
c     read in the seismic data. interpolate to time. write out results.
C_______________________________________________________________________
      call tstrsub(s(l_ueql),s(l_uirreg),s(l_icrp_seismic),
     1             s(l_w),s(l_lefttwt),s(l_idiv),ndiv,
     2             s(l_tapbuf),firstcrp,lastcrp,
     3             ntr_seismic,nrec_seismic,
     3             nz,minsamp,maxsamp,nteql,nzbuf,dteql,ITRWRD,
     4             nbytes_out,iws,iwe,
     5             lutwt,lureg,luirreg,stderr,lerr,
     6             ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
c
      write(lerr,*)'Normal completion of TSTRETCH'
      write(ler,*)'Normal completion of TSTRETCH'
C
      close(lerr)
      call exit(0)
      end
      subroutine  help(ler)
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for tstretch:'
      write(ler,*)'stretch irregularly sampled data to equally '  
      write(ler,*)'   sampled data in the depth domain'           
      write(ler,*)' '
      write(ler,*)'Input....................................... (def)'
      write(ler,*)' '
      write(ler,*)'-N [file_irreg] (stdin)     :'
      write(ler,*)'                input irregular sampled data'  
      write(ler,*)'-O [file_reg  ] (stdout)   :'
      write(ler,*)'                Output regular sampled data'     
      write(ler,*)'-T [file_twt]  (no default)    :'
      write(ler,*)'                Input irregular depth grid'      
c
      write(ler,*)'-dt[dteql] -- output time sample increment'
      write(ler,*)'-tmax[tmax]-- output trace length in msec '
      write(ler,*)'              (Default - common offset gathers)'
      write(ler,*)'-V         -- verbos printout'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'        tstretch -N[] -O[] -T[] -dt[] -tmax[]'
      write(ler,*)'                 -V'
      write(ler,*)' '

      return
      end
