C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine fitvel(tt, c, nc,nsamp, dt, coefs,
     * sig,ch,vtrms,vsrms,vism, vi,iord,jerr)
c ******************************************************************** c
c *   Subroutine to fit 5th order polynomial to input time-velocity  * c
c *   function and return smooth versions of rms and interval        * c
c *   velocities.                                                    * c
c *                                                                  * c
c *   INPUT:                                                         * c
c *                                                                  * c
c *      tt    - R*4() -  vector of times for vf , in secs           * c
c *       c    - R*4() -  vector of velocitis                        * c
c *      nc    - I*4   -  number of points in the vf                 * c
c *   nsamp    - I*4   -  Trace length for vf expansion/interpolation* c
c *     dt     - R*4   -  Sample interval in sec.                    * c
c *    sig     - R*4() -  Individual standard deviations             * c
c *     ch     - R*4   -  chisqr constant for polyfit routine        * c
c *                                                                  * c
c *   OUTPUT :                                                       * c
c *                                                                  * c
c *   vtrms    - R*4() -  Trace-length rms velocity  vector          * c
c *   coefs    - R*4() -  RMS Velocity coefficients                  * c
c *   vsrms    - R*4() -  smoothed rms velocity vector               * c
c *   vism     - R*4() -  smoothed interval velocity vector          * c
c *   vi       - R*4() -  "raw" interval velocities                  * c
c *                                                                  * c
c ******************************************************************** c
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      parameter (npol = 6)
      real tt(*), c(*),coefs(*),sig(*),vtrms(*)
      real vsrms(*),vism(*),vi(*)
#ifdef hpux
      real work1(:),work2(:),work3(:),time(:)
      real wt(:),wv(:),w1(:),w2(:),w3(:)
      real work4(:),work5(:)
      allocatable work1, work2, work3, time, wt, wv
      allocatable w1, w2, w3, work4,work5
#else
      real work1(1), work2(1),work3(1),time(1)
      real wt(1000), wv(1000),w1(1), w2(1),w3(1)
      real work4(1), work5(1)
      POINTER (pwork1,work1),(pwork2,work2),(pwork3,work3)
      POINTER (pwork4,work4),(pwork5,work5),(ptime,time)
      POINTER (pwt,wt),(pwv,wv)
      POINTER (pw1,w1),(pw2,w2),(pw3,w3)
#endif
      real ch
 
#ifdef hpux
      iget=nsamp+500
      jerr=0
      allocate(work1(iget),work2(iget),work3(iget),stat=jerr)
      allocate(time(iget),work4(iget),work5(iget),stat=jerr)
      allocate(wv(iget),wt(iget),stat=jerr)
      iget=npol*nsamp
      allocate(w1(iget),w2(iget),w3(iget),stat=jerr)
#else
      jerr = 0
      jabort = 0
      iget = (nsamp+500)*ISZBYT
      call galloc(pwork1,iget,jerr,jabort)
      call galloc(pwork2,iget,jerr,jabort)
      call galloc(pwork3,iget,jerr,jabort)
      call galloc(pwork4,iget,jerr,jabort)
      call galloc(pwork5,iget,jerr,jabort)
      call galloc(pwt   ,iget,jerr,jabort)
      call galloc(pwv   ,iget,jerr,jabort)
      call galloc(ptime ,iget,jerr,jabort)
      iget= npol*nsamp*ISZBYT
      call galloc(pw1,iget,jerr,jabort)
      call galloc(pw2,iget,jerr,jabort)
      call galloc(pw3,iget,jerr,jabort)
#endif

c     write(0,*)'nsamp,nc,dt= ',nsamp,nc,dt

      if(jerr.ne.0)return

      tmax = (nsamp-1)*dt
      do i=1,npol*nsamp
       w1(i)=0.
       w2(i)=0.
       w3(i)=0.
      end do
      do i=1,npol
       coefs(i)=0.
      end do
      do i = 1,nsamp
       time(i) = float(i-1)*dt
      end do

      do i=1,nsamp
        vtrms(i)=c(i)
      end do
      do ii=1,nc
        wt(ii)=tt(ii)
        wv(ii)=c(ii)
      end do
      j=nc

c     write(0,*)'rms'
c     write(0,*)(vtrms(ii),ii=1,nsamp,10)

      if(iord.gt.0)then
       call fitsmooth(vtrms,nsamp,iord,ier)
      endif

c     write(0,*)'rms smooth'
c     write(0,*)(vtrms(ii),ii=1,nsamp,10)

      jl = j
c     write(0,*)(wt(ii),ii=1,nsamp,10)
c     write(0,*)(wv(ii),ii=1,nsamp,10)

c     write(0,*)'infill: jl, jj= ',jl,jj
c     call infill(wt,wv,work4,work5,jl,jj)

c     write(0,*)'work4 ',jl,jj
c     write(0,*)(work4(ii),ii=1,nsamp,10)
c     write(0,*)'work5'
c     write(0,*)(work5(ii),ii=1,nsamp,10)

c     write(0,*)'svdfit: j, npol ',j,npol
c     call svdfit(work4,work5,sig,j,coefs,npol,w1,w2,w3,j,npol,
c    :ch)
      call svdfit(wt,wv,sig,j,coefs,npol,w1,w2,w3,j,npol,
     :ch)

c     write(0,*)'coefs '
c     write(0,*)(coefs(ii),ii=1,npol)

      call polev(time,nsamp,coefs,npol,vsrms)

c     write(0,*)'vsrms'
c     write(0,*)(vsrms(ii),ii=1,nsamp,10)

      call rmsint(vsrms,time,nsamp,tmax,vism)

c     write(0,*)'vism'
c     write(0,*)(vism(ii),ii=1,nsamp,10)

      call rmsint(vtrms,time,nsamp,tmax,vi)

c     write(0,*)'vtrms'
c     write(0,*)(vtrms(ii),ii=1,nsamp,10)
#ifdef hpux
      deallocate(w1,w2,w3,stat=jerr)
      deallocate(work1,work2,work3,work4,work5,time,stat=jerr)
      deallocate(wt,wv,stat=jerr)
#else
      call gfree(pw1)
      call gfree(pw2)
      call gfree(pw3)
      call gfree(pwork1)
      call gfree(pwork2)
      call gfree(pwork3)
      call gfree(pwork4)
      call gfree(pwork5)
      call gfree(ptime)
      call gfree(pwt)
      call gfree(pwv)
#endif
      return
      END
