C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FitSmooth(Y,NumX,Order,ier)

#include <f77/iounit.h>
c -----
c
c     Routine to provide a smooth fit to an array X() dataset
c     assuming uniform sampling between samples.  The smoothness
c     off fit may be varied according to the [Order] parameter.
c     The higher the Order the smoother the fit.
c
c     From Numerical Recipes, pp 495-497
c
c -----

      integer NumX,Order,m,mmax,mo2,j,k
      real Y(*),X1,XN,rn1,fac,const
      real x(1)
      pointer (px,x)
      parameter(mmax=16384)
 
      ier = 0
      m = 2
      nmin = NumX + 2.*Order
      do while(m.lt.nmin)
       m=m+m
      end do

      if(m.gt.mmax)then
       ier=1
       return
      endif

      call sizefloat(iszbyt)
      call galloc(px,m*iszbyt,jer,0)
      if(jer.ne.0)then
       ier = 2
       return
      endif
      do i=1,NumX
       x(i)=y(i)
      end do
      const = (float(Order)/float(m))**2
      X1 = X(1)
      XN = X(NumX)
      rn1 = 1./(NumX - 1.)

      do j=1,NumX
         X(j)=X(J)-rn1*(X1*(NumX-j)+XN*(j-1))
      enddo

      do j=NumX+1,m
         X(j)=0.0
      enddo

      mo2 = m/2
      call realft(X,mo2,1)
      X(1) = X(1)/mo2
      fac = 1.

      do j=1,mo2-1
         k=2*j+1
         
         if(fac.ne.0)then
            fac = amax1(0.,(1-const*j**2)/mo2)
            X(k) = fac * X(k)
            X(k+1) = fac * X(k+1)
         else
            X(k)=0.
            X(k+1)=0.
         endif

      enddo

      fac = amax1(0.,(1.-0.25*Order**2)/mo2)
      X(2) = fac * X(2)
      call realft(X,mo2,-1)

      do j=1,NumX
         X(j)=rn1*(X1*(NumX-j)+XN*(j-1))+X(j)
      enddo
      do j=1,NumX
       Y(j)=X(j)
      end do

      call gfree(px)
      return
      end
