C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine compare(cspec,amp,dwgt,uwgt,
     1                   f_peak,amp_peak,
     2                   f_trough,amp_trough,
     3                   f_mean,amp_mean,
     4                   amodel,rho,ithl,ithh,dth,
     4                   istart,iend,iskip,df,   
     5                   calc_peak,calc_mean,calc_trough,
     6                   normalize,ifl,ifh,lerr,green)
c__________________________________________________________________________
c     arrays defining input data.             
c___________________________________________________________________
      complex   cspec(ifl:ifh,istart:iend)
      real      amp(ifl:ifh,istart:iend)
      complex   amodel(ifl:ifh,ithl:ithh)
      real      rho(ithl:ithh)
      complex   csum
c___________________________________________________________________
c     arrays defining output data.
c___________________________________________________________________
      real      amp_peak(istart:iend)
      real      f_peak(istart:iend)
      real      f_trough(istart:iend)
      real      amp_trough(istart:iend)
      real      amp_mean(istart:iend)
      real      f_mean(istart:iend)
      parameter (pi=3.1415926,degprad=180./pi)
c___________________________________________________________________
c     amplitude spectrum taper.
c___________________________________________________________________
      real      dwgt(ifl:ifh),uwgt(ifl:ifh)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      logical   calc_peak,calc_trough,calc_mean
      logical   normalize,green

      if(green) then
         do jt=istart,iend,iskip
          rhomax=0.
          kth=ithl
          do jth=ithl,ithh
           csum=(0.,0.)
           rho(jth)=0.          
           do jf=ifl,ifh
            csum=csum+cspec(jf,jt)*amodel(jf,jth)
           end do
           rho(jth)=abs(csum)
           if(rho(jth) .ge. rhomax) then
              rhomax=rho(jth)
              kth=jth
           endif
          end do
c________________________________________________________________
c         interpolate to find the peak correlation at time jt.
c___________________________________________________________________
          f_peak(jt)=kth*dth
          amp_peak(jt)=rhomax
          call getpeak(rho,kth,ithl,ithh,dth,f_peak(jt),amp_peak(jt))
         end do
      else
      if(calc_mean) then
c___________________________________________________________________
c        calculate the mean amplitude.
c___________________________________________________________________
         oonf=1./(ifh-ifl+1)
         do jt=istart,iend,iskip
          adenom=0.
          anum=0.
          do jf=ifl,ifh
           adenom=adenom+amp(jf,jt)
           anum=anum+jf*amp(jf,jt)
          end do
          amp_mean(jt)=adenom*oonf
          f_mean(jt)=anum*df/adenom
         end do
      endif
      if(calc_trough) then
c___________________________________________________________________
c        calculate the amplitude at the first trough.
c        upweight the later amplitudes with uwgt.
c___________________________________________________________________
         do jt=istart,iend,iskip
          jftrough=ifl
          atrough=amp(jftrough,jt)*uwgt(jftrough)
          do jf=ifl+1,ifh
           if(amp(jf,jt)*uwgt(jf) .le. atrough) then
              jftrough=jf
              atrough=amp(jftrough,jt)*uwgt(jf)
           endif
          end do
c________________________________________________________________
c         interpolate to find the trough frequency at time jt.
c___________________________________________________________________
          call findpeak(cspec(ifl,jt),amp(ifl,jt),
     1            jftrough,ifl,ifh,df,f_trough(jt),amp_trough(jt))

         end do
      endif
      if(calc_peak) then
c___________________________________________________________________
c        calculate the amplitude at the first peak.
c        downweight the later amplitudes with dwgt.
c___________________________________________________________________
         do jt=istart,iend,iskip
          jfpeak=ifl
          apeak=amp(jfpeak,jt)*dwgt(jfpeak)
c         write(88,'(i5,3f12.3)') jf,amp(ifl,jt),
c    1          dwgt(ifl),amp(ifl,jt)*dwgt(ifl)    
          do jf=ifl+1,ifh
c         write(88,'(i5,3f12.3)') jf,amp(jf,jt),
c    1          dwgt(jf),amp(jf,jt)*dwgt(jf)
           if(amp(jf,jt)*dwgt(jf) .ge. apeak) then
              jfpeak=jf       
              apeak=amp(jfpeak,jt)*dwgt(jfpeak)
           endif
          end do 
c         write(88,'(i5,2f12.3)') jfpeak,apeak 
          kf=jfpeak
c___________________________________________________
c         search to the right
c___________________________________________________
          kfpeak=jfpeak
          do jf=jfpeak+1,ifh
           if(amp(jf,jt) .gt. amp(jf-1,jt)) then
c___________________________________________________
c             we are rising in amplitude.
c___________________________________________________
              kfpeak=jf
           else
              go to 15000
           endif
          end do
15000     continue
          do jf=jfpeak-1,ifl,-1
           if(amp(jf,jt) .gt. amp(jf+1,jt)) then
c___________________________________________________
c             we are rising in amplitude.
c___________________________________________________
              kfpeak=jf
           else
              go to 16000
           endif
          end do
16000     continue
c         write(88,'(i5,2f12.3)') kfpeak,amp(kfpeak,jt) 
c___________________________________________________________________
c         interpolate to find the peak frequency at time jt.
c___________________________________________________________________
          call findpeak(cspec(ifl,jt),amp(ifl,jt),
     1                   kfpeak,ifl,ifh,df,f_peak(jt),amp_peak(jt))
         end do
      endif
      if(normalize) then
         do jt=istart,iend,iskip
          amp_peak(jt)=amp_peak(jt)/amp_mean(jt)
          amp_trough(jt)=amp_trough(jt)/amp_mean(jt)
         end do
      endif
      endif
c
      return
      end
