C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getomega(omega,ifh,ifl,dp,df,
     1                    frequencies,verbose,lerr)
      parameter (pi=3.1415926,twopi=2.*pi)
      real      omega(ifl:ifh)
      logical   verbose,frequencies
c 
      if(verbose) then
         write(lerr,'(//,a)') 'Frequency Discretization'
         write(lerr,'(a10,3a15)') 'jf','frequency','period',
     1                             'omega'
         write(lerr,'(a10,3a15)') 'no.','Hz','ms','radians/s'  
      endif
      do 10000 jf=ifl,ifh
       if(frequencies) then
c_____________________________________________________________
c         design operator at constant frequeny increments
c_____________________________________________________________
          frequency=jf*df
          period=1./frequency
       else
c_____________________________________________________________
c         design operator at constant two-way traveltime/period
c         increments
c_____________________________________________________________
          period=jf*dp
          frequency=1./(.001*period)
       endif
       omega(jf)=twopi*frequency
       if(verbose) then
          write(lerr,'(i10,3f15.5)') jf,frequency,
     1                               period,omega(jf)
       endif
10000 continue
c
      return
      end
