C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getpeak(rho,k,ithl,ithh,dth,th,rho_peak)
c
      real      rho(ithl:ithh)
      real      th,rho_peak
c_________________________________________________________________
c     interpolate the position of the 'peak' value of function a, 
c     by running a parabola throught 3 points centered at point 'k'.
c
c     eqn of the parabola has the form:
c
c     rho(t)=a*(t-f0)**2+b
c
c     where f and f0 are measured relative to k 
c     such that:
c
c     rho(+dth)=a*(dth**2-2*dth*f0+f0**2)+b
c     rho(  0)=a*(                 f0**2)+b
c     rho(-dth)=a*(dth**2+2*dth*f0+f0**2)+b
c
c     drho=rho(+dth)-rho(-dth)=-4*a*dth*f0
c
c     d2rho=rho(+dth)-2.*rho(0)+rho(-dth)=2*a*dth**2
c
c     giving:
c
c     th=-.5*dth*drho/d2rho
c
c     a=-(rho(+dth)-rho(-dth))/(4*dth*f0)
c     b=rho(0)-a*f0**2 
c     
c_________________________________________________________________
      if(k .eq. ithl .or. k .eq. ithh) then
         th=k*dth
         rho_peak=rho(k)
      else
c_________________________________________________________________
c        calculate rho_peak, the value of the peak rholitude,
c        and th, the frequency at which it occurs.
c_________________________________________________________________
         drho=rho(k+1)-rho(k-1)
         d2rho=rho(k+1)-2.*rho(k)+rho(k-1)
         if(d2rho .eq. 0.) then
            f0=0.
         else
            f0=-.5*drho/d2rho
         endif
c
         a=-drho/(4*f0)
         b=rho(k)-a*(-f0)**2 
c
         th=(k+f0)*dth
         rho_peak=b   
      endif
C
      return
      end


