C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(uin,amp,uwgt,dwgt,
     1                   f_peak,amp_peak,f_mean,
     2                   f_trough,amp_trough,amp_mean,
     3                   uexp,cspec,scale,df,   
     4                   tabledexp,twgt,live,
     4                   amodel,rho,ithl,ithh,dth,
     5                   ifl,ifh,nx,istart,iend,iskip,
     6                   lenw_inner,lenw_outer,
     7                   calc_peak,calc_trough,calc_mean,
     9                   normalize,lerr,cputim,waltim,green) 
c___________________________________________________________________
c     calculate the amplitude and phase for each sample and trace
c     of a single seismic line for a fixed frequency, jf.
c___________________________________________________________________
c     input data.
c___________________________________________________________________
      real     uin(istart-lenw_outer:iend+lenw_outer,0:nx)   
      logical  live(0:nx)
c___________________________________________________________________
c     arrays defining output data.
c___________________________________________________________________
      real      amp(ifl:ifh,istart:iend) 
      real      f_peak(istart:iend,0:nx)
      real      f_trough(istart:iend,0:nx)
      real      f_mean(istart:iend,0:nx)
      real      amp_peak(istart:iend,0:nx)
      real      amp_trough(istart:iend,0:nx)
      real      amp_mean(istart:iend,0:nx)
c___________________________________________________________________
c     intermediate arrays.
c___________________________________________________________________
      complex  cspec(ifl:ifh,istart:iend)    
      complex  uexp(istart-lenw_outer:iend+lenw_outer)
      real     rho(ithl:ithh)
c___________________________________________________________________
c     tabled arrays and tapers.
c___________________________________________________________________
      complex  tabledexp(istart-lenw_outer:iend+lenw_outer,ifl:ifh)
      real     amodel(ifl:ifh,ithl:ithh)
      real     twgt(-lenw_outer:lenw_outer)
      real     scale(istart:iend,ifl:ifh)
      real     uwgt(ifl:ifh),dwgt(ifl:ifh)
c___________________________________________________________________
c     timing variables.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      logical  calc_peak,calc_mean,calc_trough
      logical  normalize,green
c
      parameter (pi=3.14159)
c___________________________________________________________________
c     loop over all traces in x.
c___________________________________________________________________
      do 90000 jx=0,nx    
       if(.not. live(jx)) go to 90000
       do jf=ifl,ifh
c___________________________________________________________________
c      precompute product of the seismic trace with the tabled 
c      exp function for frequency jf.
c___________________________________________________________________
       call timstr(v1,w1)
       do kt=istart-lenw_inner,iend+lenw_inner
        uexp(kt)=uin(kt,jx)*tabledexp(kt,jf)   
       end do  
       call timend(cputim(4),v1,v2,waltim(4),w1,w2)
c___________________________________________________________________
c      initialize the output.
c___________________________________________________________________
       call timstr(v1,w1)
       do kt=istart,iend
        cspec(jf,kt)=(0.,0.)
       end do   
c___________________________________________________________________
c      calculate sum over initial window.
c___________________________________________________________________
       kt=istart
       do jt=-lenw_inner,+lenw_inner
        cspec(jf,kt)=cspec(jf,kt)+uexp(kt+jt)
       end do  
       call timend(cputim(5),v1,v2,waltim(5),w1,w2)
c___________________________________________________________________
c      calculate running sums over equally weighted part of window
c      by dropping and adding terms.
c      if necessary, prescale data such that roundoff doesn't bite you!
c___________________________________________________________________
       call timstr(v1,w1)
       do kt=istart+1,iend
        cspec(jf,kt)=cspec(jf,kt-1)
     1                +(uexp(kt+lenw_inner)-uexp(kt-lenw_inner-1))
       end do  
       call timend(cputim(6),v1,v2,waltim(6),w1,w2)
c___________________________________________________________________
c      add tapers to the outside of the inner window.
c___________________________________________________________________
       call timstr(v1,w1)
       do kt=istart,iend,iskip
        do jt=lenw_inner+1,lenw_outer
         cspec(jf,kt)=cspec(jf,kt)
     1                +twgt(jt)*(uexp(kt+jt)+uexp(kt-jt))
        end do  
c___________________________________________________________________
c      add exponential shift necessary to center sin and cos at the
c      center of the analysis window, tcenter=kt*dt.
c      note exp(-j*omega*tcenter)=conjg(exp(+j*omega*tcenter))
c___________________________________________________________________
        cspec(jf,kt)=conjg(tabledexp(kt,jf))*cspec(jf,kt)
       end do
       call timend(cputim(7),v1,v2,waltim(7),w1,w2)
c___________________________________________________________________
c      calculate amplitude.
c___________________________________________________________________
       call timstr(v1,w1)
       do kt=istart,iend,iskip
        amp(jf,kt)=abs(cspec(jf,kt))*scale(kt,jf)
       end do
       call timend(cputim(8),v1,v2,waltim(8),w1,w2)
      end do   
      call timstr(v1,w1)
c___________________________________________________________________
c     compare frequency values at each time sample and
c     extract the peak, trough and other attributes.
c___________________________________________________________________
      call compare(cspec,amp,uwgt,dwgt,
     1             f_peak(istart,jx),amp_peak(istart,jx),
     2             f_trough(istart,jx),amp_trough(istart,jx),
     3             f_mean(istart,jx),amp_mean(istart,jx),
     4             amodel,rho,ithl,ithh,dth,
     4             istart,iend,iskip,df,
     5             calc_peak,calc_mean,calc_trough,
     6             normalize,ifl,ifh,lerr,green)
      call timend(cputim(9),v1,v2,waltim(9),w1,w2)
90000 continue
c
      return
      end


