C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(uin,trheader,
     1                    tracebuf,ibuffer,nx,nlive,
     2                    istart,iend,lenw_outer,nsamp_in,
     3                    live,luin,eof,ITRWRD,TRACEHEADER,
     4                    ifmt_StaCor,l_StaCor,ln_StaCor)
c
      integer    trheader(ITRWRD,0:nx)
      real       uin(istart-lenw_outer:iend+lenw_outer,0:nx)
      real       tracebuf(-ITRWRD:nsamp_in-1)
      integer    ibuffer(1:*)    
      logical    eof,live(0:nx)
      integer    TRACEHEADER
c
      nlive=0
      do 90000 jx=0,nx
       nbytes=0
       call rtape(luin,tracebuf(-ITRWRD),nbytes)
       if(nbytes .eq. 0) then
          eof=.true.
          return
       endif
c_____________________________________________________________
c      copy in the trace header.
c_____________________________________________________________
       do 11000 jh=1,ITRWRD
        trheader(jh,jx)=ibuffer(jh)
11000  continue
       call saver2(tracebuf,ifmt_StaCor,l_StaCor,ln_StaCor,
     1             istatic, TRACEHEADER)
       if(istatic .eq. 30000) then
          live(jx)=.false.
       else
c_____________________________________________________________
c         copy the data from the tracebuffer into the input array.
c_____________________________________________________________
          live(jx)=.true.
          nlive=nlive+1
          js=max(istart-lenw_outer,0)
          je=min(iend+lenw_outer,nsamp_in-1)
          amp2=0.
          do 10000 kt=js,je
           uin(kt,jx)=tracebuf(kt)
           amp2=amp2+tracebuf(kt)**2
10000     continue
          do 20000 kt=istart-lenw_outer,js-1
           uin(kt,jx)=0.
20000     continue
          do 30000 kt=nsamp_in,iend+lenw_outer 
           uin(kt,jx)=0.
30000     continue
          if(amp2 .eq. 0.) then
c_____________________________________________________________
c            data within the analysis window are all zero.
c            set the trace to be 'dead'.
c_____________________________________________________________
             live(jx)=.false.
          endif
       endif
90000 continue
c
      return
      end
