C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine filt_tv(x,ns,y,lslide,nwin,zerop,norder,
     :                   ovlp,tcoefs,tnorm,wrk1,wrk2)

#include <f77/lhdrsz.h>

      real    x (*), y (*)
      real    tnorm(200), tcoefs(200,2,32), wrk1(3), wrk2(96)
      real    coefs(2,32)
      real    hold1(SZLNHD),sumb(SZLNHD),work(SZLNHD),tmp(SZLNHD)
      integer lwind, ovlp
      integer i,ns
      integer jj
      logical zerop
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lopp   - Operator length (samples)                    |
C |   pred   - Prediction length (samples or zero crossings)|
C |   pw     - Prewhitening (fraction)                      |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+
c     write(0,*)'ns,lslide,nwin,ovlp= ',
c    1ns,lslide,nwin,ovlp,norder,zerop

C +----------------------------------------------------+
C | COMPUTE AND REMOVE THE AVERAGE                     |
C +----------------------------------------------------+
      imid1 = 0
      DO  KK = 1, nwin

          if (kk .eq. 1) then
             nmove  = lslide + ovlp
             ilast  = lslide + ovlp
             ifirst = 1
             if(lslide .eq. ns) nmove = ns
             jmove  = nmove
          else
             nmove  = lslide + ovlp
             jmove  = nmove
             ifirst = ifirst + ovlp
             imid1  = ifirst
             ilast  = ifirst + nmove - 1
             if (ilast .gt. ns)then
                 jmove = ns - ifirst + 1
             endif
          endif

          xd = 0.
          do  i = 1, jmove
              xt = x (i + ifirst - 1)
              work (i) = xt
              xd = xd + xt * xt
          enddo
          do  i = jmove+1, ns
              work (i) = 0.
          enddo

          lwind  = jmove
C +----------------------------------------------------+
C | DO THE AUTOCORRELATION IN THE TIME DOMAIN          |
C +----------------------------------------------------+

          init = 1

          if (xd .gt. 1.e-30) then

             do  jj = 1, 2
                 do ii = 1, norder
                    coefs (jj,ii) = tcoefs (kk,jj,ii)
                 enddo
             enddo

             call bwfilt ( work, tmp , wrk1, wrk2, coefs,
     1                     tnorm(kk), norder, lwind, init, 0)

             if (zerop) then

                init = 0
                call vrvrs (tmp ,  1, lwind)
                call bwfilt ( tmp , work, wrk1, wrk2, coefs,
     1                        tnorm(kk), norder, lwind, init, 0)
                call vrvrs (work,  1, lwind)

             else

                call vmov (tmp, 1, work, 1, lwind)

             endif

          else

             call vclr (work, 1, lwind)
          endif

          do  i = 1, lwind
              hold1 (i) = work (i)
          enddo


      IF (kk.eq.1) THEN

        do  i = 1, lwind
            sumb (i) = hold1 (i)
        enddo

      ELSE

        jj = imid1 - 1
        xj = ovlp

        do  i = 1, ovlp
            jj = jj + 1
            x1 = (i-1) / xj
            x2 = 1.0 - x1
            sumb(jj) = sumb(jj) * x2 + hold1(i) * x1
        enddo

        do  i = ovlp+1, jmove
            jj = jj + 1
            sumb (jj) = hold1 (i)
        enddo

      ENDIF

      ENDDO

      do  i = 1, ns
          y(i) = sumb (i)
      enddo

      CONTINUE
      RETURN
      END
