C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine orms_tv(x,ns,y,lslide,nwin,ovlp,dt,
     1                   first, f1, f2, f3, f4,
     2                   fwt, workc, amp, phz)

#include <f77/lhdrsz.h>

      real    x (*), y (*)
      real    fwt (*), f1 (*), f2 (*), f3 (*), f4 (*)
      real    amp (SZLNHD), phz (SZLNHD)
      complex workc (SZLNHD)
      real    hold1(SZLNHD),sumb(SZLNHD),work(SZLNHD)
      integer nwin, lwind, ovlp
      integer i,ns
      integer jj
      logical first
C +---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lopp   - Operator length (samples)                    |
C |   pred   - Prediction length (samples or zero crossings)|
C |   pw     - Prewhitening (fraction)                      |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+
c     write(0,*)'ns,lslide,nwin,ovlp= ',
c    1ns,lslide,nwin,ovlp,norder,zerop

C +----------------------------------------------------+
C | COMPUTE AND REMOVE THE AVERAGE                     |
C +----------------------------------------------------+
      imid1 = 0
      DO  KK = 1, nwin

          if (kk .eq. 1) then
             nmove  = lslide + ovlp
             ilast  = lslide + ovlp
             ifirst = 1
             if(lslide .eq. ns) nmove = ns
             jmove  = nmove
          else
             nmove  = lslide + ovlp
             jmove  = nmove
             ifirst = ifirst + ovlp
             imid1  = ifirst
             ilast  = ifirst + nmove - 1
             if (ilast .gt. ns)then
                 jmove = ns - ifirst + 1
             endif
          endif

          xd = 0.
          do  i = 1, jmove
              xt = x (i + ifirst - 1)
              work (i) = xt
              xd = xd + xt * xt
          enddo
          xd = sqrt ( xd ) / float(jmove)
          do  i = jmove+1, ns
              work (i) = 0.
          enddo

          lwind  = jmove
C +----------------------------------------------------+
C | DO THE time varying trapezoidal filtering          |
C +----------------------------------------------------+

          flolo = f1 (KK)
          flohi = f2 (KK)
          fhilo = f3 (KK)
          fhihi = f4 (KK)

          if (xd .gt. 1.e-30) then

             call fweight (lwind, nt, nf, dt, df, flolo, flohi, fhilo,
     1                     fhihi, fwt)
             call trapf   (lwind, nt, nf, dt, df, work, fwt, workc,
     2                     amp, phz)
          else

             call vclr (work, 1, lwind)
          endif

          do  i = 1, lwind
              hold1 (i) = work (i)
          enddo


      IF (kk.eq.1) THEN

        do  i = 1, lwind
            sumb (i) = hold1 (i)
        enddo

      ELSE

        jj = imid1 - 1
        xj = ovlp

        do  i = 1, ovlp
            jj = jj + 1
            x1 = (i-1) / xj
            x2 = 1.0 - x1
            sumb(jj) = sumb(jj) * x2 + hold1(i) * x1
        enddo

        do  i = ovlp+1, jmove
            jj = jj + 1
            sumb (jj) = hold1 (i)
        enddo

      ENDIF

      ENDDO

      do  i = 1, ns
          y(i) = sumb (i)
      enddo

      CONTINUE
      RETURN
      END
