C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine srec (Record, Headers, Space, nsamp, ntrc, ist, iend,
     :  ivmin, ivmax )

#include <f77/iounit.h>
#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend 
      integer Headers(ITRWRD*ntrc)
      integer ivmax, ivmin

      real Record(nsamp, ntrc), Space(nsamp,ntrc) 
	real intcpt, vmin, vmax

c local variables


c initialize variables
	vmax = float(ivmax)
	vmin = float(ivmin)

      do i = 1, nsamp
         do j = 1, ntrc
            Space(i,j) = 0.0
         enddo
      enddo

c process data

      hdr_index = 0
c================================================================      
	smax = Record(1,1)
	smin = Record(1,1)
	numsmp = iend - ist + 1
      DO j = 1, ntrc

c define pointers to header words required by your routine

         call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :        TRACEHEADER )

c get header value

         hdr_index = (j-1) * ITRWRD + 1 

c         call saver2 ( Headers(hdr_index), ifmt_StaCor, l_StaCor, 
c     :        ln_StaCor, StaCor, TRACEHEADER)

c process live traces only

c         if ( StaCor .ne. 30000 ) then
cmam	smax=Record(1,1)
cmam	smin=Record(1,1)
cmam        DO i = ist, iend
cmam	smax=max(smax,Record(i,j))
cmam	smin=min(smin,Record(i,j))
cmam        ENDDO
	call minv(Record(ist,j),1,xmin,ndxmin,numsmp)
	call maxv(Record(ist,j),1,xmax,ndxmax,numsmp)
	if(xmin.lt.smin) then
		smin = xmin
		ltlndx = ndxmin
		ltltrc = j - ist + 1
	endif
	if(xmax.gt.smax) then
		smax = xmax
		lrgndx = ndxmax
		lrgtrc = j - ist + 1
	endif

          ENDDO
c================================================================      

               slope = (vmax-vmin)/(smax - smin)
               intcpt = vmax - ((slope)*smax)
		
	do j = 1, ntrc
               do i = ist, iend
                  Space(i,j)= (Record(i,j)*slope) + intcpt
               enddo
       enddo

c================================================================      

      do j = 1, ntrc
         do i = ist, iend
            Record(i,j) = Space(i,j)
         enddo
      enddo

      return
      end
