/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	home for more built-in functions
*/
#include "ufh.h"
#include <sys/types.h>
#include <sys/time.h>
#ifndef __convex__
#include <malloc.h>
#endif
#include <string.h>
#include <ctype.h>
#include <stdio.h>

static int bVector(fs)
FILE *fs;
{
    return fprintf(fs, "(");
}

static int eVector(fs)
FILE *fs;
{
    return fprintf(fs, ")");
}

int printItem(fs, tp)
FILE* fs;
TPackage tp;
{
    int c;
    int i;
    switch(tp.type) {
      case TPackageP:
      case OTPackageP:
	c = bVector(fs);
	for(i = 0; i < tp.size; i++) {
	    c += printItem(fs, tp.u.tpa[i]);
	    if(i < (tp.size - 1))
		c += fprintf(fs, ", ");
	}
	c += eVector(fs);
	break;
      case Double:
	c += fprintf(fs, "%g", tp.u.val);
	break;
      case SFloatP:
	c += fprintf(fs, "%g", *tp.u.series);
	break;
      case CharP:
	c += fprintf(fs, "%s", tp.u.str);
	break;
      case FloatP:
      case OFloatP:
	c = bVector(fs);
	for(i = 0; i < tp.size; i++) {
	    c += fprintf(fs, "%g", tp.u.series[i]);
	    if(i < (tp.size - 1))
		c += fprintf(fs, ", ");
	}
	c += eVector(fs);
	break;
      default:
	c = fprintf(fs, "<%s>", stringForm(tp));
	break;
    }
    return c;
}

TPackage TPPrint()
{
    int i;
    double c = 0.0;
    for(i = 1; i <= nArgs(); i++)
	c += printItem(stderr, nthArg(i));
    return dTPackage(c);
}

TPackage TPPopen()
{
    char*	ps = asString(nthArg(1));
    char*	mode = asString(nthArg(2));
    TPackage	p;

    p.type = FileStar;
    if((p.u.fstar = popen(ps, mode)) == NULL)
	p = newTP();;

    return p;
}

TPackage TPPclose()
{
    FILE* stream = asFileStar(nthArg(1));

    return dTPackage((double) pclose(stream));
}

TPackage TPFopen()
{
    char*	ps = asString(nthArg(1));
    char*	mode = asString(nthArg(2));
    TPackage	p;

    p.type = FileStar;
    if((p.u.fstar = fopen(ps, mode)) == NULL)
	p = newTP();;
    return p;
}

TPackage TPFclose()
{
    FILE* stream = asFileStar(nthArg(1));

    return dTPackage((double) fclose(stream));
}

TPackage TPFflush()
{
    FILE* stream = asFileStar(nthArg(1));

    return dTPackage((double) fflush(stream));
}

TPackage TPFprint()
{
    FILE* stream = asFileStar(nthArg(1));
    int i;
    double c;

    for(i = 2; i <= nArgs(); i++)
	c += fprintf(stream, "%s", stringForm(nthArg(i)));
    return dTPackage(c);
}

static TPackage addCharTP(tp, ch)
TPackage tp;
int ch;
{
    char* p;

    if(tp.type == Nothing) {
	tp.size = 1;
	tp.type = CharP;
	tp.u.str = (char*) malloc(1);
	tp.u.str[0] = '\0';
    }
    if(ch != '\0') {
	tp.size++;
	tp.u.str = realloc(tp.u.str, tp.size);
	p = tp.u.str + strlen(tp.u.str);
	*p++ = ch;
	*p = '\0';
    }
    return tp;
}

static TPackage nextToken(stream, separators)
FILE* stream;
char* separators;
{
    TPackage tk;
    int next;
    int inquote;

    for(;;) {
	next = getc(stream);
	if((next == '\n') || (next == EOF) || !isspace(next)) {
	    ungetc(next, stream);
	    break;
	}
    }
    tk = newTP();
    inquote = 0;
    for(;;) {
	next = getc(stream);
	if((next == EOF) || (next == '\n')) {
	    if(tk.type != Nothing)
		ungetc(next, stream);
	    break;
	}
	if(inquote) {
	    if(next == '"')
		break;
	    tk = addCharTP(tk, next);
	    continue;
	}
	if(next == '"') {
	    inquote = 1;
	    tk = addCharTP(tk, '\0');
	    continue;
	}
	if(strchr(separators, next) != 0)
	    break;
	tk = addCharTP(tk,next);
    }
    return tk;
}

TPackage TPGetTokenLine()
{
    TPackage t, r;
    FILE* stream = asFileStar(nthArg(1));
    char* separators;

    separators = " \\t,;";
/*
**	use stringForm() so we don't have to free() it
*/
    if(nArgs() == 2)
	separators = stringForm(nthArg(2));
    t = newTP();
    for(;;) {
	r = nextToken(stream, separators);
	if(r.type == Nothing)
	    break;
	if(t.type == Nothing) {
	    t.size = 1;
	    t.type = TPackageP;
	    t.u.tpa = (TPackage*) malloc(sizeof(TPackage));
	    t.u.tpa[0] = r;
	} else {
	    t.size++;
	    t.u.tpa = (TPackage*) realloc(t.u.tpa,
					  t.size * sizeof(TPackage));
	    t.u.tpa[t.size - 1] = r;
	}
    }
    return t;
}

TPackage TPScanf()
{
    FILE* stream = asFileStar(nthArg(1));
    
    return newTP();
}

TPackage TPOutputSISChunk()
{
    TPackage t;

    t = nthArg(1);
    if(t.type != SISChunkP)
	execerror("TPOutputSISChunk: not an SIS data type: %s",
		  typeName(t));
    TPPutSISChunk(t, 1);
    return dTPackage(0.0);
}
