/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>
#ifndef __convex__
#include <malloc.h>
#include <memory.h>
#endif

#include <localsys.h>

#include <save.h>
#include <io_defs.h>

#include "ufh.h"


#define READHEADER 0
#define WRITEHEADER 1


#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

static int FORTRAN = 0;
static long recordsIn = 0L;
static long recordsOut = 0L;
static long outs = 0L;


static SISFieldType OldSISType2NewSISType(oldtype)
int oldtype;
{
    switch(oldtype) {
      case SAVE_CHAR_DEF:
	return SISChar;
      case SAVE_SHORT_DEF:
	return SISShort;
      case SAVE_LONG_DEF:
	return SISLong;
      case SAVE_FLOAT_DEF:
	return SISFloat;
      case SAVE_FKFLT_DEF:
	return SISFakeFloat;
/* no longer used - joe m. wade 3/25/96
      case 5:
	return SISTrace;
      case 6:
	return SISHLHdr;
*/
      default:
	break;
    }
    return -1;
}

static char* TraceName = "Series";
static char* HLHName   = "HLH";

SISFieldInfo* findSISField(fname)
char* fname;
{
    struct hdr *hd;
    SISFieldInfo* r;
    SISHeaderType h;

    r = (SISFieldInfo*) malloc(sizeof(SISFieldInfo));

/*
   Series and HLH are ufh-only types, so why not just declare them here?
					- joe m. wade 3/25/96
*/
/*
**	special handling for x.Series.
*/
    if(strcasecmp(fname, TraceName) == 0) {
	r->fieldname	  = TraceName;
	r->fieldtype      = 5;
	r->fieldposition  = 0;
	r->fieldlength    = 0;
	r->headertype     = TraceHeader;
/*
	r->ftype	  = OldSISType2NewSISType(5);
*/
	r->ftype	  = SISTrace;
	return r;
    }

/*
**	special handling for x.HLH.
*/
    if(strcasecmp(fname, HLHName) == 0) {
	r->fieldname	  = HLHName;
	r->fieldtype      = 6;
	r->fieldposition  = 0;
	r->fieldlength    = 0;
	r->headertype     = TraceHeader;
/*
	r->ftype	  = OldSISType2NewSISType(6);
*/
	r->ftype	  = SISHLHdr;
	return r;
    }

/*
**	everyday handling
*/
    for(h = LineHeader; h <= VSPNHeader; h++) {
	switch(h) {
	  case LineHeader:
	    hd = lhdr;
	    break;
	  case TraceHeader:
	    hd = thdr;
	    break;
	  case VANLHeader:
	    hd = vnlhdr;
	    break;
	  case VSPNHeader:
	    hd = vspn_hdr;
	    break;
	  default:
	    fprintf(stderr, "Error save: invalid header type %d\n", h);
	    return NULL;
	}
	for(; hd->str != (char *)0; hd++)
		if(strcasecmp(fname, hd->str) == 0) {
		    r->fieldname      = hd->str;
		    r->fieldtype      = hd->ind;
		    r->fieldposition  = hd->pos;
		    r->fieldlength    = hd->length;
		    r->headertype     = h;
		    r->ftype	      = OldSISType2NewSISType(hd->ind);
		    return r;
		}
    }
    free(r);
    fprintf(stderr, "findSISField: \"%s\" not a known SIS field name\n",
	    fname);
    return NULL;
}

static double sisGet_l(itr, pos)	/* read long int from position pos return as val */
int	itr[];
int	pos;
{
	return itr[pos];
}

static double sisGet_r(itr, pos)
float	itr[];
int	pos;
{
	return itr[pos] ;
}

static double sisGet_r2(itr, info)
char  	itr[];
SISFieldInfo* info;
{
	float val;
	getreal2(itr, info->fieldtype, info->fieldposition,
		info->fieldlength, &val);
	return val;
}

static sisGet_s(itr, pos)
short	itr[];
int	pos;
{
	return (int)itr[pos];
}

/*
**	N.B.: returns a pointer to a static data area
*/
char* sisGetAsciiZ(buffer, info)
char*	buffer;
SISFieldInfo*	info;
{
    static char*	s = 0;
    static int		slen = 0;

    char* emalloc();
    int i;

    if(info->ftype != SISChar) {
	fprintf(stderr, "sisGetAsciiZ: bad info type: %d.\n",
		info->ftype);
	exitprocandexit(1);
    }
    if((info->fieldlength + 1) > slen) {
	if(s != 0)
	    free(s);
	slen = info->fieldlength + 1;
	s = emalloc(slen);
    }
    memcpy(s, buffer + info->fieldposition, info->fieldlength);
    i = info->fieldlength;
    s[i] = '\0';
    while((i >= 0) && ((s[i] == ' ') || (s[i] == '\0')))
	    s[i--] = '\0';
    return s;
}

double sisGetNumericValue(buffer, info)
SISChunk*	buffer;
SISFieldInfo*	info;
{
	switch(info->fieldtype){
	  case SAVE_SHORT_DEF:
	    return sisGet_s(buffer, info->fieldposition);
	  case SAVE_LONG_DEF:
	    return sisGet_l(buffer, info->fieldposition);
	  case SAVE_FLOAT_DEF:
	    return sisGet_r(buffer, info->fieldposition);
	  case SAVE_FKFLT_DEF:
	    return sisGet_r2(buffer, info);
	  default:
	    fprintf(stderr, "sisGetNumericValue: bad info type: %d.\n",
		    info->fieldtype);
	    exitprocandexit(1);
	}
}

static int lengthHLHInt()
{
    return HLHINT;
}

static int alignHLH()
{
    switch(lengthHLHInt()) {
      case 2:
	return 1;
      case 8:
	return 8;
      default:
	fprintf(stderr, "roundHLHInt: impossible case (%d).\n",
		lengthHLHInt());
	exit(1);
    }
}

/*
#ifdef sun
*/
#ifndef CRAY

static int decodeHLHInt(s)
char* s;
{
    union {
	char c[4];
	int i;
    } u;

    u.i = 0;
    u.c[2] = s[0];
    u.c[3] = s[1];
    if((u.i > 0x7fff) != 0)
	u.i |= (~0x7fff);
    return u.i;
}

static char* stuffHLHInt(ptr, val)
char* ptr;
int val;
{
    union {
	char c[4];
	int i;
    } u;

    u.i = val;
    ptr[0] = u.c[2];
    ptr[1] = u.c[3];
    ptr += lengthHLHInt();
    return ptr;
}

/*
#endif
#ifdef CRAY
*/
#else

static char* stuffHLHInt(ptr, val)
char* ptr;
int val;
{
    int* iptr;

    iptr = (int*) ptr;
    *iptr = val;
    ptr += lengthHLHInt();
    return ptr;
}

static int decodeHLHInt(s)
char* s;
{
    int* q = (int*) s;
    return (*q);
}

#endif

static TPackage getHLH(buffer)
char*	buffer;
{
    char*	hlhb;
    int		n, length;
    TPackage	t;
    int		i;
    int 	lng, alng;
    TPackage	line;

    hlhb = ((char*) buffer) + HLHOFF;

    n = decodeHLHInt(hlhb);
    hlhb += lengthHLHInt();
    length = decodeHLHInt(hlhb);
    hlhb += lengthHLHInt();

    if(n < 1)
	return newTP();

    t.type = TPackageP;
    t.size = n;
    t.u.tpa  = (TPackage*) emalloc(t.size * sizeof(TPackage));
    for(i = 0; i < t.size; i++) {
	lng = decodeHLHInt(hlhb);
	hlhb += lengthHLHInt();
	line.type = CharP;
	line.size = lng + 1;
	line.u.str = (char*) emalloc(line.size);
	memcpy(line.u.str, hlhb, lng);
	line.u.str[lng] = '\0';
	while((lng%alignHLH()) != 0)
	    ++lng;
	hlhb += lng;
	t.u.tpa[i] = line;
    }
    return t;
}

static void sisPut_l(itr, val, pos)
int	itr[];
double	val; 
int	pos;
{
	itr[pos] = (int) val;
}

static void sisPut_r(itr, val, pos)
float	itr[];
double	val;
int	pos;
{
	itr[pos] = (float) val;
}

static void  sisPut_r2(itr, val, info)
char  	itr[];
double  val;
SISFieldInfo* info;
{
	putreal2(itr, info->fieldtype, info->fieldposition,
		info->fieldlength, val);
}

static void sisPut_s(itr, val, pos)
short	itr[];
double	val; 
int	pos;
{
	itr[pos] = (short) val;
}

/*
**	putAsciiZ begins at the right end and proceeds left.
**	(Length is not changed.)
*/
char* sisPutAsciiZ(buffer, info, val, length)
char*		buffer;
SISFieldInfo*	info;
char*		val;
int*		length;
{
    int i;
    int j;
    char* to;

    if(info->ftype != SISChar) {
	fprintf(stderr, "sisPutAsciiZ: bad info type: %d.\n",
		info->ftype);
	exitprocandexit(1);
    }

    to = buffer + info->fieldposition;
    j = info->fieldlength - 1;
    i = strlen(val) - 1;

    for(;;) {
	if((i < 0) || (j < 0))
	    break;
	to[j--] = val[i--];
    }
    while(j >= 0)
	to[j--] = ' ';

    return buffer;
}
/*
**	Length is not changed.
*/
char* sisPutNumericValue(buffer, info, val, length)
char*	buffer;
SISFieldInfo*	info;
double		val;
int*		length;
{
	switch(info->fieldtype){
	  case SAVE_SHORT_DEF:
	     sisPut_s(buffer, val, info->fieldposition);
	    break;
	  case SAVE_LONG_DEF:
	     sisPut_l(buffer, val, info->fieldposition);
	    break;
	  case SAVE_FLOAT_DEF:
	     sisPut_r(buffer, val, info->fieldposition);
	    break;
	  case SAVE_FKFLT_DEF:
	     sisPut_r2(buffer, val, info);
	    break;
	  default:
	    fprintf(stderr, "sisPutNumericValue: bad info type: %d.\n",
		    info->fieldtype);
	    exitprocandexit(1);
	}
	return buffer;
}

#define MAXLHLENGTH	(32762*32)
#define MAXSAMPLES	(16384)

static char* getSISChunk(fd, lengthp)
int fd;
int* lengthp;
{
    static char* buff = 0;
    static int blen = 0;
    int newblen;
    int rlen;

    newblen = (recordsIn <= 0L) ? MAXLHLENGTH : 2048 + 8 * MAXSAMPLES;
    if(newblen > blen) {
	if(buff != 0)
	    free(buff);
	blen = newblen;
	buff = (char*) emalloc(blen);
    }
    C_RTAPE(fd, buff, &rlen);
    *lengthp = rlen;
    if(rlen <= 0)
	return NULL;
    if(rlen > blen) {
	    fprintf(stderr, "getSISChunk: record %d   %d > %d\n",
		    recordsIn, rlen, blen);
	    exitprocandexit(1);
	}
    ++recordsIn;
    return buff;
}

void endSISOutput()
{
    if(outs > 0L)
	C_LBCLOS(1);
    outs = 0L;
}

TPackage TPGetSISChunk(fd)
int fd;
{
    TPackage	t;
    SISChunk*	s;
    char*	in;
    int		lin;
    int		hln;
    float*	tr;
    TPackage	x;
    int		numberOfSamples;

    s = (SISChunk*) emalloc(sizeof(SISChunk));
    t.type = SISChunkP;
    t.u.chunk = (char*) s;

    in = getSISChunk(fd, &lin);
    if(in == 0) {
	t.type = Nothing;
	t.size = 0;
	free((char*)s);
	return t;
    }

    if(recordsIn > 1) {
	s->isTrace = 1;
	hln = 128 * sizeof(short);
	s->hdr = emalloc(hln);
	memcpy(s->hdr, in, hln);
	s->hlen = hln;
	numberOfSamples = (lin - hln)/sizeof(float);
	tr = (float*) emalloc(numberOfSamples * sizeof(float));
	memcpy(tr, in + hln, numberOfSamples * sizeof(float));
	x.type = FloatP;
	x.size = numberOfSamples;
	x.u.series = tr;
	s->trace = x;
	s->hlh = newTP();
    } else {
	s->isTrace = 0;
	hln = HLHOFF;
	s->hdr = emalloc(hln);
	memcpy(s->hdr, in, hln);
	s->hlen = hln;
	s->hlh = getHLH(in);
	s->trace = newTP();
    }
    return t;
}

void TPPutSISChunk(t, fd)
TPackage t;
int fd;
{
    static char* buff = 0;
    long blen = -1;

    SISChunk*	c;
    long	rlen;
    char*	hptr;
    int		i;
    int		pslen;

    if(t.type != SISChunkP)
	execerror("TPPutSISChunk: argument not an SIS type: %s",
		  typeName(t));
    c = (SISChunk*) t.u.chunk;
    if(c->isTrace == 0) {
	rlen = HLHOFF + 2 * lengthHLHInt();
	for(i = 0; i < c->hlh.size; i++)
	    rlen += lengthHLHInt() +
		((strlen(c->hlh.u.tpa[i].u.str) + alignHLH() - 1)
		 /alignHLH()) * alignHLH();
	if(blen != rlen) {
	    if(buff != 0)
		free(buff);
	    blen = rlen;
	    buff = emalloc(blen);
	}
	memcpy(buff, c->hdr, HLHOFF);
	hptr = buff + HLHOFF;
	hptr = stuffHLHInt(hptr, c->hlh.size);
	hptr = stuffHLHInt(hptr, blen - HLHOFF);
	for(i = 0; i < c->hlh.size; i++) {
	    pslen = strlen(c->hlh.u.tpa[i].u.str);
	    hptr = stuffHLHInt(hptr, pslen);
	    memcpy(hptr, c->hlh.u.tpa[i].u.str, pslen);
	    hptr += ((pslen + alignHLH() - 1)/alignHLH()) * alignHLH();
	}
    } else {
	rlen = c->hlen + sizeof(float) * c->trace.size;
	if(blen != rlen) {
	    if(buff != 0)
		free(buff);
	    blen = rlen;
	    buff = emalloc(blen);
	}
	memcpy(buff, c->hdr, c->hlen);
	memcpy(buff + c->hlen, (char*) c->trace.u.series,
	       c->trace.size * sizeof(float));
    }
    C_WRTAPE(fd, buff, blen);
    ++outs;
    ++recordsOut;
    return;
}

