/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef UFH_H
#define UFH_H

#include <stdio.h>
#include <usystype.h>
#include "sismember.h"
#include "support.h"

/*
**	TPackage - typed data package
*/

typedef struct TPackage (*BltIn)();
typedef void   (*Inst)();

typedef enum {
    Nothing,
    SFloatP,  	/* ptr to single float value 		*/
    FloatP,	/* ptr to array of floats		*/
    OFloatP,	/* ptr to other's float array		*/
    Double,	/* value				*/
    SymbolP, 	/* points to symbol table entry 	*/
    SISField, 	/* info about an SIS field		*/
    StackP, 	/* points to a stack location		*/
    InstP, 	/* points to Inst	      		*/
    CharP, 	/* points to char			*/
    SISChunkP, 	/* an sis header'd chunk		*/
    FileStar, 	/* stdio channel pointer 		*/
    TPSingleP, 	/* pointer to one TPackage 		*/
    TPackageP, 	/* pointer to an array of TP's		*/
    OTPackageP,	/* pointer to other's array of TP's	*/
    LastType	/* always the last entry		*/
} PackageType;

typedef union PValue {
	double			val;
	struct Symbol*		sym;
	BltIn			ptr;
	struct TPackage*	stackp;
	Inst*			defn;
	char*       		str;
	char*			chunk;
	SISFieldInfo*	        info;
	struct TPackage*	tpa;
	float*			series;
	FILE*			fstar;
} PValue;

/*
**	TPackage.size holds:
**		- allocated length for a string (strlen() + 1).
**		- allocated length for an SISChunk.
**		- number of entries in a TPackage array
**		- number of values in a FloatP array.
*/
typedef struct TPackage {
    PackageType type;
    int 	size;
    PValue	u;
} TPackage;

/*
**	SIS data package
*/
typedef struct {
    int		isTrace;
    char*	hdr;
    int		hlen;
    TPackage	trace;
    TPackage	hlh;
} SISChunk;

/*
**	symbol table entry
*/

typedef struct Symbol { /* symbol table entry */
	char    	*name;
	int		ttype;
	int		loc;
	int		flags;
	TPackage	spk;
	struct Symbol*  next;
	struct Symbol*	local;
} Symbol;

/*
**	look up an SIS field name.  This function searchs all four
**	header specifications (line, trace, vanl, and vspn) for the
**	named item.  Returns a pointer to an alloc'd copy of the
**	field's info, or NULL.
*/

SISFieldInfo* findSISField();

/*
**	convenience functions for anyone with a pointer to an SISChunk
*/
double		sisGetNumericValue();
char*		sisPutNumericValue();

char*		sisGetAsciiZ();
char*      	sisPutAsciiZ();

void		endSISOutput();

/*
**	virtual machine state
*/

typedef struct {
    TPackage*		argptr;		/* first argument slot	*/
    int			nargs;
    TPackage*		autoptr;	/* first auto slot 	*/
    int			nauto;
    Symbol*		funcptr;	/* current function	*/
    struct VMRegisters*	callerVM;	/* 0 at end of chain	*/
} VMRegisters;

/*
**	TPackage support
*/

TPackage	newTP();
void		deleteTP();
TPackage	deepCopyTP();
TPackage	addString();
TPackage*	accessArrayTP();

TPackage dTPackage();	/* wrap a double	*/
TPackage cTPackage();	/* wrap a char*		*/
TPackage sTPackage();	/* wrap a Symbol*	*/
TPackage mTPackage();	/* wrap an SIS member	*/

TPackage	SISTPackageGet();
void		SISTPackageSet();
void		TPPutSISChunk();

int	isDouble();
int	isSym();
int	isString();
int	isArray();
int	isMember();
int	isSISChunk();

char*	stringForm();
char*	typeName();

double		asDouble();
char*		asString();
Symbol*		asSymbol();
SISFieldInfo*	asMember();
FILE*		asFileStar();

/*
**	symbol table support
*/
void	beginlocal();
void	openlocal();
void 	closelocal();
Symbol*	endlocal();
Symbol*	lookup();
Symbol*	install();
Symbol*	installlc();
Symbol*	installcons();
void	dumpSymbols();

/*
**	data stack support
*/

void		initstack();
TPackage*      	push();
TPackage	pop();
void		freePop();
TPackage*	nextdata();
void		deleteTP();

double	popD();
void	pushD();
void	pushI();

char* popC();

/*
**	virtual machine support
*/

#define STOP     (Inst) 0

extern VMRegisters	VM;
extern VMRegisters*	prevVM;
extern Inst*		progp;
extern Inst*		pc;
extern int		returning;

TPackage*	ptr2auto();
TPackage*	ptr2arg();

void		skip_to_eol();
extern char*	SourceText;

Inst	*code();

TPackage	TPOpPow();

int		nArgs();
TPackage	nthArg();

void init();
void initcode();
Symbol* currentFunction();
void tpvarpush();
void tpindexpush();
void tpsubrangepush();
void tpmemberpush();

void tpeval();

void tpassign();

void noop();
void popStack();
void datapush();
void dupTOSeval();
void swapTOS();
void incr();
void decr();
void mod();
void add();
void sub();
void mul();
void divop();
void negate();
void gt();
void lt();
void ge();
void eq();
void ne();
void and();
void or();
void not();
void power();
void zero();
void one();
void nothing();
void lastindex();
void le();
void whilecode();
void forcode();
void ifcode();

void define();
void call();
void funcret();
void bltin();
void prexpr();
void prstr();
void varread();

void execute();
void iexecute();
int run();
void callSymbol();
extern int verbose;

void exitproconly();
void exitprocandexit();

/*
**	produces a segmentation fault: #define ENABLE_DEBUGGING
*/

#ifdef CRAY

/*
**	more crap to deal with Unicos.
*/
int strcasesmp();

#endif

#endif
