C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine BuildOtherVelocity ( rt, rv, nsamp, nsi, nn, v, sout)

c subroutine to build a velocity trace v(nsamp) from an input 
c velocity function rv(nn) with input times at rt(nn).  The
c type of velocity is either RMS or AVERAGE.  INTERVAL velocity
c is handled by BuildIntervalVelocity().  The first velocity is
c used from time zero to rt(1), the last velocity is used from
c time rt(nn) to the end of trace.  Linear interpolation is done
c in between.

       integer nn, nsamp

       real*4 rt(*), rv(*), v(*), getvel, Time, dt, fac

       character sout*(*)

c handle microsecond output

       if( sout .eq. 'T' ) then
          if ( nsi .le. 32 ) then
              dt = real (nsi)/1000.
          else
              dt = real (nsi)/1000000.
          endif
       else
          dt = nsi
       endif

       DO i = 1,nsamp

c assign time from 1st sample at Time = zero to be compatible with
c ProMax, CogniSeis, Ilis, MBS, PPRED etc.

          Time  = dt * float(i-1)

          if ( Time .le. rt(1) ) then

c first velocity will be used from time zero down to and including 
c first function time

             getvel = rv(1)
          elseif ( Time .ge. rt(nn) ) then

c last velocity will be used from last function time to end of trace
c if not specified

             getvel = rv(nn)
          else

c do linear interpolation of velocity such that a given velocity will
c only appear at the time specified in the function.

             do j=2,nn

                if( Time .ge. rt(j-1)
     :               .and. Time .le. rt(j) ) then
                   fac = (Time - rt(j-1)) / (rt(j) - rt(j-1))
                   getvel = rv(j-1) + fac * (rv(j) - rv(j-1))
                   go to 1002 
                endif

             enddo

          endif

 1002     continue

          v(i) = getvel
       ENDDO

       return
       end
