C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SortVelFunctions ( InputVelocityIndex, VelFunctions, 
     :     NumTotalVelFcns, nsamp )

c routine to sort velocity functions stored in VelFunctions() into the
c same order as the input dataset [incrementing or decrementing]

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer NumTotalVelFcns, InputVelocityIndex(*)
      integer tempIndex(2*SZLNHD)
      integer nsamp, TotalNumSmp, tempSize, tempAbort,tempErrcd
      integer tempFunctionIndex, VelFunctionIndex

      real VelFunctions(*), tempFunctions
      pointer (tempAdr,tempFunctions(100000))

      tempAbort = 0

c allocate memory

      tempSize = NumTotalVelFcns * nsamp * SZSMPD
      call galloc ( tempAdr, tempSize, tempErrcd, tempAbort )

      if ( tempErrcd .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'VELIN: Unable to allocate workspace:'
         write(LERR,*)tempSize,'  bytes in sorting subroutine '
         write(LERR,*)'FATAL '
         stop
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)tempSize,'  bytes'
         write(LERR,*)' '
      endif
      
c intitialize memory

      TotalNumSmp = NumTotalVelFcns * nsamp

      call vclr ( tempFunctions,1,TotalNumSmp)
      do i = 1,SZLNHD
         tempIndex(i) = 0
      enddo

c save original order in tempIndex()
      
      do i = 1, NumTotalVelFcns
         tempIndex(i) = InputVelocityIndex(i)
      enddo

c save original velocities in tempFunctions()

      call vmov ( VelFunctions, 1, tempFunctions, 1, TotalNumSmp )

c sort the record number indices to increasing order
 
      call isort1 ( NumTotalVelFcns, InputVelocityIndex)

c put velocity functions in appropriate order

c normal incrementing function order

      DO i = 1, NumTotalVelFcns
         do j = 1, NumTotalVelFcns

c the old order is in tempIndex while the desired order is in InputVelocityIndex
c the old velocities are in tempFunctions while the desired functions will be
c in VelFunctions.  This way when this loop is done the input index and velocity
c arrays will contain the sorted data
 
            if ( InputVelocityIndex(i) .eq. tempIndex(j) ) then

               tempFunctionIndex = ( j - 1 ) * nsamp + 1
               VelFunctionIndex = ( i - 1 ) * nsamp + 1
               call vmov ( tempFunctions(tempFunctionIndex), 1, 
     :              VelFunctions(VelFunctionIndex), 1, nsamp )

            endif
         enddo
      ENDDO

      return
      end
      
               
