C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bdvel(rt, rv, nn, sin, vin, sout, vout, MaxTime,
     :      MaxDepth, nsi, tape, SlopeAdjustmentFactor, Force, verbos,
     :      rnmo)

c bdvel controls the conversion of any given input sample,vel
c dataset to any required output sample,vel dataset.  Data is expected
c in two way time in seconds, or depth in ft or meters and velocity  
c in either m/s or ft/s as required.  Output is also two way time or 
c ft or meters vs m/s or ft/s as required. 

c declare variables passed from calling routine

      implicit none

      integer   nn, nsi

      real      rt(*), rv(*), MaxTime, MaxDepth
      real      SlopeAdjustmentFactor

      character sin*(*), sout*(*), vin*(*), vout*(*)

      logical   tape, Force, verbos, rnmo

c declare variables unique to subroutine

      real      LastIntervalTop, LastIntervalVelocity
      real      LastIntervalThickness, vzero 

      logical   vflag 

c initialize variables

      vflag = .false.
      vzero = rv(1)

c start velocity conversion

      IF ( sin .eq. 'T' ) then

c TIME input

         if ( vin .eq. 'I' ) then

c INTERVAL velocity input 
c if tape, get  unique interval velocity entries

            if ( tape )
     :           call UniqueIntervalVelocity ( rt, rv, nn, verbos )
            
            if ( sout .eq. 'T' ) then

c TIME input -> TIME output [Interval Velocity In]

               if ( vout .eq. 'I' ) return

               if ( vout .eq. 'R' ) then

c convert to RMS velocity

                  call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity
 
                  call ti2ta ( rt, rv, nn, MaxTime )
                  return
               endif

            elseif ( sout .eq. 'D' ) then

c TIME input -> DEPTH output  [Interval Velocity In]

               if ( vout .eq. 'I' ) then
                  call t2d ( rt, rv, nn )
                  return 
               endif

               if ( vout .eq. 'R' ) then

c convert to RMS velocity

                  call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity

                  call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif

            endif

         elseif ( vin .eq. 'R' ) then

c RMS velocity input

            if ( sout .eq. 'T' ) then

c TIME input -> TIME output  [RMS Velocity In]

               if ( vout .eq. 'R' ) then

c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate RMS velocity at
c            max time.  WARNING: any RMS velocity inversions
c            in the input velocity function will cause this
c            routine to fail as there will be a negative in 
c            the square root in the DIX equation.

                 if (rnmo) then

                  if( rt(nn) .lt. MaxTime ) then
                     rt(nn) = MaxTime
                  endif

                 else

                  if( rt(nn) .lt. MaxTime ) then
                     call tr2ti ( rt, rv, nn, tape, 
     :                    SlopeAdjustmentFactor, vflag, Force )
                     call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  endif

                 endif
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity
 
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity
c WARNING: To get to average, have to first convert to interval which 
c          again will crash if there are rms inversions in the input
c          function [see last WARNING]

                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call ti2ta ( rt, rv, nn, MaxTime )
                  return 
               endif

            elseif ( sout .eq. 'D' ) then

c TIME input -> DEPTH output  [RMS Velocity In]
               
               if ( vout .eq. 'R' ) then
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  return 
               endif
             
               if(vout.eq.'I') then
 
c convert to INTERVAL velocity

                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call t2d ( rt, rv, nn )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity
c WARNING: To get to average, have to first convert to interval which 
c          again will crash if there are rms inversions in the input
c          function [see last WARNING]

                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif
            endif

         elseif ( vin .eq. 'A' ) then

c AVERAGE velocity input
            
            if ( sout .eq. 'T' ) then

c TIME input -> TIME output  [Average Velocity In]

               if ( vout .eq. 'A' ) then

c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate AVERAGE velocity at
c            max time. 

                  if ( rt(nn) .lt. MaxTime ) then
                     call ta2ti ( rt, rv, nn,tape,SlopeAdjustmentFactor, 
     :                    vflag)
                     call ti2ta(rt,rv,nn,MaxTime)
                  endif
                  return
               endif

               if(vout.eq.'I') then

c convert to INTERVAL velocity

                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  return
               endif

               if(vout.eq.'R')then

c convert to RMS velocity

                  call ta2ti( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  return 
               endif

            elseif ( sout .eq. 'D' ) then

c TIME input -> DEPTH output  [Average Velocity In]

               if ( vout .eq. 'A' ) then
                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity

                  call ta2ti( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call t2d ( rt, rv, nn )
                  return
               endif

               if(vout.eq.'R') then

c convert to RMS velocity

                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif
            endif
         endif

      ELSEIF ( sin .eq. 'D' ) THEN

c DEPTH input

         if (vin .eq. 'I' ) then

c INTERVAL velocity input 
c if tape, get  unique interval velocity entries

            if ( tape )
     :           call UniqueIntervalVelocity ( rt, rv, nn, verbos )

            if ( sout .eq. 'T' ) then

c DEPTH input -> TIME output  [Interval Velocity In]

               if ( vout .eq. 'I' ) then
 
c DEPTH to TIME

                  call d2t ( rt, rv, nn )
                  return
               endif

               if ( vout .eq. 'R' ) then

c convert to RMS velocity

                  call d2t ( rt, rv, nn )
                  call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity

                  call d2t ( rt, rv, nn )
                  call ti2ta ( rt, rv, nn, MaxTime )
                  return
               endif

            elseif ( sout .eq. 'D' ) then

c DEPTH input -> DEPTH output  [Interval Velocity In]

               if ( vout .eq. 'I' ) return
               
               if ( vout .eq. 'R' ) then
 
c convert to RMS velocity

                  LastIntervalTop = rt(nn)
                  LastIntervalThickness = MaxDepth - LastIntervalTop 
                  LastIntervalVelocity = rv(nn)
                  call d2t ( rt, rv, nn )
                  MaxTime = rt(nn) + 2. 
     :                 * LastIntervalThickness / LastIntervalVelocity 
                  call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity

                  LastIntervalTop = rt(nn)
                  LastIntervalThickness = MaxDepth - LastIntervalTop 
                  LastIntervalVelocity = rv(nn)

                  call d2t ( rt, rv, nn )
                  MaxTime = rt(nn) + 2.
     :                 * LastIntervalThickness / LastIntervalVelocity 
                  call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif
            endif

         elseif ( vin .eq. 'R' ) then

c RMS input velocity

            if ( sout .eq. 'T' ) then

c DEPTH input -> TIME output  [RMS Velocity In]
               
               if ( vout .eq. 'R' ) then
                  
c DEPTH to TIME

                  call drms2t ( rt, rv, nn )

c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate RMS velocity at
c            max time.  WARNING: any RMS velocity inversions
c            in the input velocity function will cause this
c            routine to fail as there will be a negative in 
c            the square root in the DIX equation.
                
                  if ( rt(nn) .lt. MaxTime ) then
                     call tr2ti ( rt, rv, nn, tape,
     :                    SlopeAdjustmentFactor, vflag, Force  )
                     call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  endif
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity

                  call drms2t ( rt, rv, nn )
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  return
               endif

               if ( vout .eq. 'A' ) then

c convert to AVERAGE velocity

                  call drms2t ( rt, rv, nn )
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call ti2ta ( rt, rv, nn, MaxTime )
                  return 
               endif
               
            elseif ( sout .eq. 'D' ) then

c DEPTH input -> DEPTH output  [RMS Velocity In]
               
               if ( vout .eq. 'R' ) then

c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate RMS velocity at
c            max time.  WARNING: any RMS velocity inversions
c            in the input velocity function will cause this
c            routine to fail as there will be a negative in 
c            the square root in the DIX equation.  To prevent
c            this calculation simply enter a velocity at MaxDepth
c            on input

                  if ( rt(nn) .lt. MaxDepth ) then
                     LastIntervalTop = rt(nn)
                     LastIntervalThickness = MaxDepth - LastIntervalTop 
                     call drms2t ( rt, rv, nn )
                     call tr2ti ( rt, rv, nn, tape, 
     :                    SlopeAdjustmentFactor, vflag, Force  )
                     LastIntervalVelocity = rv(nn)
                     MaxTime = rt(nn) + 2. 
     :                 * LastIntervalThickness / LastIntervalVelocity 
                     call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  endif 
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity

                  call drms2t ( rt, rv, nn )
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  call t2d ( rt, rv, nn )
                  return
               endif
               
               if(vout.eq.'A') then

c convert to AVERAGE velocity

                  LastIntervalTop = rt(nn)
                  LastIntervalThickness = MaxDepth - LastIntervalTop 
                  call drms2t ( rt, rv, nn )
                  call tr2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag, Force  )
                  LastIntervalVelocity = rv(nn)
                  MaxTime = rt(nn) + 2. 
     :                 * LastIntervalThickness / LastIntervalVelocity 
                  call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif
            endif

         elseif ( vin .eq. 'A' ) then

c AVERAGE velocity input

            if ( sout .eq. 'T' ) then
  
c DEPTH input -> TIME output  [Average Velocity In]

               if ( vout .eq. 'A' ) then

c DEPTH to TIME

                  call da2t ( rt, rv, nn )
 
c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate AVERAGE velocity at
c            max time. 

                  if ( rt(nn) .lt. MaxTime ) then
                     call ta2ti ( rt, rv, nn,tape,SlopeAdjustmentFactor, 
     :                    vflag )
                     call ti2ta ( rt, rv, nn, MaxTime )
                  endif
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity

                  call da2t ( rt, rv, nn )
                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  return
               endif

               if ( vout .eq. 'R' ) then

c convert to RMS velocity

                  call da2t ( rt, rv, nn )
                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call ti2tr ( rt, rv, nn, MaxTime, nsi, vzero )
                  return
               endif

            elseif ( sout .eq. 'D' ) then

c Depth input -> Depth output  [Average Velocity In]

               if ( vout .eq. 'A' ) then

c POLICEMAN: make sure that function exists out to max time.
c            To do this convert to interval velocity then 
c            extend the last interval velocity to max time.
c            Now calculate the appropriate RMS velocity at
c            max time.  WARNING: any RMS velocity inversions
c            in the input velocity function will cause this
c            routine to fail as there will be a negative in 
c            the square root in the DIX equation.

                  if( rt(nn) .lt. MaxDepth ) then
                     LastIntervalTop = rt(nn)
                     LastIntervalThickness = MaxDepth - LastIntervalTop 
                     call ta2ti ( rt, rv, nn, tape,  
     :                 SlopeAdjustmentFactor, vflag )
                     LastIntervalVelocity = rv(nn)
                     MaxTime = rt(nn) + 2. 
     :                    * LastIntervalThickness / LastIntervalVelocity 
                     call ti2da ( rt, rv, nn, MaxTime, MaxDepth )
                  endif
                  return
               endif

               if ( vout .eq. 'I' ) then

c convert to INTERVAL velocity
 
                  call da2t ( rt, rv, nn )
                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  call t2d ( rt, rv, nn )
                  return
               endif

               if ( vout .eq. 'R' ) then

c convert to RMS velocity

                  LastIntervalTop = rt(nn)
                  LastIntervalThickness = MaxDepth - LastIntervalTop 
                  call da2t ( rt, rv, nn )
                  call ta2ti ( rt, rv, nn, tape, SlopeAdjustmentFactor, 
     :                 vflag )
                  LastIntervalVelocity = rv(nn)
                  MaxTime = rt(nn) + 2. 
     :                 * LastIntervalThickness / LastIntervalVelocity 
                  call ti2dr ( rt, rv, nn, MaxTime, MaxDepth )
                  return
               endif

            endif

         endif

      ENDIF

      return
      end
