C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, vtap, ptap, single, regular, 
     :     iwd, src, rcvr, cdp, pri, 
     :     disco, hmig, tensor, xsd, flat, tdfn,  
     :     XSDInitVelOverride, XSDVelUnitsOverride, 
     :     XSDSampleUnitsOverride,
     :     nsiOverride, osi, 
     :     sin, vin, sout, vout, 
     :     MBSdx, MBSdy, MBSdz, 
     :     ilis,
     :     SlopeAdjustmentFactor, Force, verbos, rnmo)

c parse arguments entered on command line

#include <f77/iounit.h>

      integer   nsiOverride, osi, MBSdx, MBSdy, MBSdz 
      integer   argis, XSDSampleUnitsOverride

      real      XSDInitVelOverride, XSDVelUnitsOverride
      real      SlopeAdjustmentFactor

      character ntap*(*), otap*(*), vtap*(*), ptap*(*), iwd*(*)
      character sin*(*), sout*(*), vin*(*), vout*(*)

      logical   single, regular
      logical   src, rcvr, cdp, pri, ilis, Force
      logical   disco, hmig, tensor, xsd, flat, tdfn
      logical   verbos, rnmo

c initialize variables 

      verbos = .false.
      single = .false.
      src = .false.
      rcvr = .false.
      cdp = .false.
      pri = .false.
      disco = .false.
      hmig = .false.
      tensor = .false.
      xsd = .false.
      flat = .false.
      tdfn = .false.
      rnmo = .false.
      Force = .false.

c grab command line keys and their associated values

      cdp  = (argis('-cdp') .gt. 0)

      disco = ( argis('-disco') .gt. 0)
      call argr4  ('-dx',dx,0.,0.)
      call argr4  ('-dy',dy,0.,0.)
      call argr4  ('-dz',dz,0.,0.)

      flat = ( argis('-flat') .gt. 0)
      Force = ( argis('-force') .gt. 0)
 
      hmig = ( argis('-hmig') .gt. 0)
      call argstr ('-hw', iwd, ' ', ' ' )

      ilis = ( argis('-ilis') .gt. 0 )

      call argstr ('-N', ntap, ' ', ' ' )

      call argi4  ('-osi',osi,0,0)
      call argstr ('-O', otap, ' ', ' ' )

      pri  = (argis('-pri') .gt. 0)
      call argstr ('-P', ptap, ' ', ' ' )

      rcvr = (argis('-receiver') .gt. 0)
      regular = ( argis('-R') .gt. 0)

      src  = (argis('-shot') .gt. 0)
      call argstr ('-sout', sout, 'T', 'T' )
      call argr4  ('-saf',SlopeAdjustmentFactor,0.0,0.0)
      call argstr ('-sin', sin, 'T', 'T' )
      call argi4  ('-si',nsiOverride,0,0)
      single = ( argis('-S') .gt. 0 )

      tdfn = ( argis('-tdfn') .gt. 0)
      tensor = ( argis('-tensor') .gt. 0)

      call argstr ('-vin', vin, 'R', 'R' )
      call argstr ('-vout', vout, 'R', 'R' )
      call argstr ('-v', vtap, ' ', ' ' )
      verbos = ( argis('-V') .gt. 0 )
      rnmo   = ( argis('-rnmo') .gt. 0 )

      if (rnmo) then
         vin  = 'R'
         vout = 'R'
      endif

      xsd = ( argis('-xsd') .gt. 0)
      if(xsd .or. ptap .ne. ' ')then

c this will get looked at if xsd or if the use wants
c an xsd pickfile output.  This allows one to input
c velocity units for the output pickfile

         call argi4  ('-psi',XSDSampleUnitsOverride,0,0)
         call argr4  ('-sv',XSDInitVelOverride,0.,0.)
         call argr4  ('-dv',XSDVelUnitsOverride,1.,1.)
      endif
      if(.not.xsd)xsd = ( argis('-oper') .gt. 0)

c set SlopeAdjustmentFactor 
      
      if ( abs ( SlopeAdjustmentFactor ) .lt. 1.e-32 ) then
         if ( vout .eq. 'I' ) then 
            SlopeAdjustmentFactor = 0.01
         else
            SlopeAdjustmentFactor = 0.001
         endif
      else
         SlopeAdjustmentFactor = SlopeAdjustmentFactor / 100.
      endif

      MBSdx = 1000. * dx
      MBSdy = 1000. * dy
      MBSdz = 1000. * dz

      return
      end
     
