C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine t2d ( rt, rv, nn )

c t2d converts the TIME axis rt() to DEPTH assuming:
c      rv() = INTERVAL velocity in units/second
c      rt() = 2way time in seconds
c
c it is also assumed that the interval velocity is 
c posted at the base of the interval over which it
c applies [to be consistent with MBS, ILIS etc.
c

#include <f77/lhdrsz.h>

      integer nn, i

      real rt(*), rv(*)
      real tint, depth(SZLNHD)

c initialize memory

      call vclr ( depth, 1, SZLNHD )

c calculate initial depth sample

      depth(1) = rv(1) * rt(1) / 2.

      do i = 2 , nn
         tint = ( rt(i) - rt(i-1) ) / 2.
         depth(i) = depth(i-1) + tint * rv(i)
      enddo

      do i = 1 , nn

c load depth into output array 

         rt(i) = depth(i)
      enddo

      return
      end
