C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ti2ta ( rt, rv, nn, MaxTime )

c Subroutine ti2ta converts an input interval velocity function
c to avg  using Dix Equation. The algorithm used is:
c
c vavg = sum(1,nn)[vint(i)**2*TimeInterval(i)]/sum(1,nn)TimeInterval(i)
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = INTERVAL velocity in units/second
c  velocity is referenced to the bottom of the interval
c  first time sample is at time zero 
c
c on output rv() = AVERAGE velocity in units/second

#include <f77/lhdrsz.h>

      integer nn, i

      real rt(*), rv(*), vavg(SZLNHD), Depth
      real TimeInterval, CummulativeTime, MaxTime

c initialize memory

      call vclr( vavg, 1, SZLNHD )

c first AVERAGE velocity  equals first INTERVAL velocity

      vavg(1) = rv(1)

c initialize CummulativeTime

      Depth = rv(1) * rt(1) / 2.
      CummulativeTime = rt(1) / 2.

      if (MaxTime.gt.10.) MaxTime = MaxTime/1000.

      DO i=2,nn
         TimeInterval = ( rt(i) - rt(i-1) ) / 2.
         Depth = Depth + rv(i) * TimeInterval
         CummulativeTime = CummulativeTime + TimeInterval
         vavg(i) = Depth / CummulativeTime
      ENDDO

c form vavg for last sample

      IF ( rt(nn) .lt. MaxTime ) then

c last interval will extend last velocity to max time of dataset

         TimeInterval = ( MaxTime - rt(nn) ) / 2.
         Depth = Depth + rv(nn) * TimeInterval
         CummulativeTime = CummulativeTime + TimeInterval

c add one to the number of elements in velocity function

         nn = nn+1
         vavg(nn) = Depth / CummulativeTime 

c assign time for new velocity table entry 

         rt(nn) = MaxTime
      ENDIF

      call vmov ( vavg, 1, rv, 1, nn )

      return
      end
