C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                         velinp
c
c routine to provide one velocity function at a time from the 
c input velocity dataset.  The function will be converted and
c interpolated as required using the routines bdvel and 
c BuildIntervalVelocity

      subroutine velinp ( tri, nsamp, nsi, vtap, luvel, lvhed, nsampv, 
     :     osi, tensor, xsd, disco, hmig, flat, tdfn, tape,
     :     XSDInitVelOverride, XSDVelUnitsOverride, 
     :     XSDSampleUnits, XSDSampleOffset, 
     :     XSDVelocityUnits, XSDVelocityOffset,
     :     PicksPerSegment, ptap, lupick, 
     :     icount, irec, EndFunctionReadFlag, 
     :     sin, vin, sout, vout,
     :     ilis, XSDHeaderWritten, XSDsegmentNumber, 
     :     nrec, ntrc,
     :     SlopeAdjustmentFactor, Force, verbos, rnmo)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare arguments passed from calling routine

      integer   nsamp, nsi, osi, icount, irec, nrec, ntrc
      integer   luvel, lvhed(*), nsampv, lupick
      integer   XSDSampleUnits, XSDSampleOffset, PicksPerSegment(*)
      integer   XSDsegmentNumber

      real      tri(SZLNHD), SlopeAdjustmentFactor ,rec
      real      XSDInitVelOverride, XSDVelUnitsOverride
      real      XSDVelocityUnits, XSDVelocityOffset

      character vtap*(*), sin*(*), sout*(*), vin*(*), vout*(*), ptap(*) 

      logical   tensor, xsd, disco, hmig, flat, tdfn, tape
      logical   EndFunctionReadFlag, ilis, XSDHeaderWritten, Force
      logical   verbos, rnmo


c declare variables used in subroutine

      integer   nLivePicks

      real      rt(SZLNHD), rv(SZLNHD)
      real      Record(2*SZLNHD), Trace(2*SZLNHD), Sample(SZLNHD)
      real      tfact, MaxTime, MaxDepth

      character junk*1, test*3
      character Shot*80, ajunk*7
      character hmigShot(80)*1

c initialize memory

      call vclr(rt,1,SZLNHD)
      call vclr(rv,1,SZLNHD)
      call vclr(Record,1,2*SZLNHD)
      call vclr(Trace,1,2*SZLNHD)
      call vclr(Sample,1,SZLNHD)

c handle microsecond input if input velocity function is in time 
c or set tfact to unity if input velocity function is in depth

      if ( sin .eq. 'T' ) then
         if ( nsi .le. 32 .and. sin .eq. 'T' ) then
            tfact = 1000.
         else
            tfact = 1000000.
         endif
      elseif ( sin .eq. 'D' ) then
         tfact = 1.
      endif

c calculate MaxTime and MaxDepth as a function of the type of 
c conversion to be accomplished

      IF ( sin .eq. 'T' ) then
         if ( sout .eq. 'T' ) then
            if ( osi .eq. 0 ) then
               MaxTime = ( nsamp - 1 ) * nsi / tfact
            else
               MaxTime = ( nsamp - 1 ) * osi / tfact
            endif
         endif
         if ( sout. eq. 'D' ) then
            MaxTime = ( nsamp - 1 ) * nsi / tfact
            if ( osi .eq. 0 ) then
               MaxDepth = ( nsamp - 1 ) *  nsi
            else
               MaxDepth = ( nsamp - 1 ) *  osi 
            endif
         endif
      ELSEIF ( sin .eq. 'D' ) then
         if ( sout .eq. 'T' ) then
            MaxTime = ( nsamp - 1 ) * osi / tfact
            MaxDepth = ( nsamp - 1 ) *  nsi 
         endif
         if ( sout. eq. 'D' ) then
            if ( osi .eq. 0 ) then
               MaxDepth = ( nsamp - 1 ) * nsi 
            else
               MaxDepth = ( nsamp - 1 ) * osi
            endif 
         endif
      ENDIF

c perform format dependent read of the next velocity function
      
      IF (tensor) then
         nn = 0
 10      read(luvel,'(1x,a1)',end=1001) junk
         if(junk .ne. 'L') go to 10
         read(luvel,'(13x,i6)',end=1010) irec
         read(luvel,'(a1)',end=1010) junk
 11      continue
         nn = nn + 1
         read(luvel,'(a3,f7.0,f10.0)',end=1010) test,rt(nn),rv(nn)

c convert to seconds

         rt(nn) = rt(nn)/tfact
         if(test .ne. 'END') go to 11

c echo function just read in

         write(LERR,*)' '
         write(LERR,*)'Input velocity function'
 14      continue

      ELSEIF (xsd) then

         if ( .not. EndFunctionReadFlag ) then

            call XSDRead ( luvel, Record, Trace, Sample, 
     :           PicksPerSegment(icount), nLivePicks,  
     :           nsi, EndFunctionReadFlag ) 

         else
            go to 1001
         endif

         if (nLivePicks .ge. 2) then

c convert Trace() to rv() using appropriate units and offset

            if ( XSDInitVelOverride .gt. 1.e-32 
     :           .and. (XSDVelUnitsOverride - 1.0) .gt. 1.e-32 )then

               do i = 1, nLivePicks
                  rv(i) = XSDInitVelOverride + 
     :                 ( Trace(i) - 1. ) * XSDVelUnitsOverride
               enddo

            else

               do i = 1, nLivePicks
                  rv(i) = Trace(i)
               enddo

            endif

c convert Sample() to rt() in seconds using appropriate offset 
c units and timefactor [tfact: accounts for micro or milli seconds]
c if XSDSampleOffset is zero then need to subtract one from the sample
c value so that the time calculated at the first sample will be zero.
c If XSDSampleOffset is nonzero then I assume the user knows what he/she
c is doing and I use that value [see XSDInitialize and vfile to see where these
c values came from
            
            if ( XSDSampleOffset .ne. 0 ) then

               do i = 1, nLivePicks
                  rt(i) = ( ( Sample(i) + float( XSDSampleOffset ) ) /  
     :                 float(XSDSampleUnits ) ) * float(nsi) / tfact
               enddo

            else

               do i = 1, nLivePicks
                  rt(i) = 
     :                 ( ( Sample(i) /  float( XSDSampleUnits ) ) - 1. ) 
     :                 * float ( nsi ) / tfact
               enddo

            endif

         else
            go to 1001
         endif

         irec = ifix( Record(1) )
         nn = nLivePicks + 1

c echo function just read in

         write(LERR,*)' '
         write(LERR,*)'Input velocity function'

      ELSEIF (flat) then  

c initialize nn

         nn = 0

 1000    continue

         nn = nn + 1
         read(luvel,*,end=1001,err=1003)rt(nn),rv(nn),rec
         irec = nint(rec)
         rt(nn) = rt(nn)/tfact

         if(rt(nn) .lt. 0.0)then

c echo function just read in

            write(LERR,*)' '
            write(LERR,*)'Input velocity function'
            go to 1002
         endif

         go to 1000

      ELSEIF (hmig) then

         read(luvel,30,end=1001)hmigShot
 30      format(80A1,///)

          if(hmigShot(59).ne.' ')then
            
             if(hmigShot(60).ne.' ')then

                if(hmigShot(61).ne.' ') then

                  if(hmigShot(62).ne.' ') then
                
                     if(hmigShot(63).ne.' ') then

                       read(hmigShot(63),'(I1)')itemp
                       read(hmigShot(62),'(I1)')itemp1
                       read(hmigShot(61),'(I1)')itemp2
                       read(hmigShot(60),'(I1)')itemp3
                       read(hmigShot(59),'(I1)')irec

                       irec = irec*10000+itemp3*1000+itemp2*100
     :                        +itemp1*10+itemp

                     else

                       read(hmigShot(62),'(I1)')itemp
                       read(hmigShot(61),'(I1)')itemp1
                       read(hmigShot(60),'(I1)')itemp2
                       read(hmigShot(59),'(I1)')irec

                       irec = irec*1000+itemp2*100+itemp1*10+itemp
                     
                     endif

                  else

                     read(hmigShot(61),'(I1)')itemp
                     read(hmigShot(60),'(I1)')itemp1
                     read(hmigShot(59),'(I1)')irec

                     irec = irec * 100 + itemp1 * 10 + itemp
                  
                  endif 


                else

                   read(hmigShot(60),'(I1)')itemp
                   read(hmigShot(59),'(I1)')irec
                   irec = irec*10+itemp

                endif
             
             else

                read(hmigShot(59),'(I1)')irec

             endif

           else

             write(LERR,*)' No shot point number in velocity file'
             write(LERR,*)' FATAL ...........'
             stop
      
           endif
         
         nn = 1

c if input sample units are time read time, if depth read depth

 31      if(sin.eq.'T')then
            read(luvel,32,end=1011)test,rt(nn),rv(nn)
 32         format(1x,a3,24x,f6.3,10x,f10.0)
         elseif(sin.eq.'D')then
            read(luvel,33,end=1011)test,rt(nn),rv(nn)
 33         format(1x,a3,30x,2f10.0)
         endif

c if test is blank then skip a line and decrement nn

         if(test.eq.' ')then
            read(luvel,'(1x,a3)',end=1011)test
            if(test.eq.'---') EndFunctionReadFlag = .true.

            if(test.eq.'ESS')then
               read(luvel,3847,end=1011)test
 3847          format(1x,a3,//)
            endif

            nn = nn - 1
         else
            nn = nn + 1
            goto 31
         endif

c echo function just read in

         write(LERR,*)' '
         write(LERR,*)'Input velocity function'

         do j=1,nn
            if(sin.eq.'T')then
               write(LERR,100)j,rt(j),rv(j),irec
 100        format(i4,' Time =',f9.3,' Velocity =',f10.2,' Index =',i6)
            elseif(sin.eq.'D')then
               write(LERR,110)j,rt(j),rv(j),irec
 110        format(i4,' Depth =',f9.3,' Velocity =',f10.2,' Index =',i6)
            endif
         enddo

      ELSEIF ( tdfn ) then

         call ReadTDFN ( luvel, rt, rv, nn, irec, MaxTime, tfact,
     :        EndFunctionReadFlag)


         if ( .not. EndFunctionReadFlag ) then

c echo function just read in

            write(LERR,*)' '
            write(LERR,*)'Input velocity function'

            do j=1,nn
               if(sin.eq.'T')then
                  write(LERR,100)j,rt(j),rv(j),irec
               elseif(sin.eq.'D')then
                  write(LERR,110)j,rt(j),rv(j),irec
               endif
            enddo

         else
            goto 1001
         endif

      ELSEIF (tape) then

c default read of velocity tape

         call rtape(luvel,lvhed,nvbytes)

         if(nvbytes .eq. 0) then
            goto 1001
         endif

         call vmov(lvhed(ITHWP1),1,rv,1,nsampv)
         nn = nsampv
         call saver(lvhed,'RecNum',irec,1)

         do i=1,nn

c make sure first sample is time zero

            rt(i) = float(nsi*(i-1))/tfact
         enddo

c echo function

         if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'Input velocity function '
            do j=1,nn,10
               if(sin.eq.'T')then
                  write(LERR,100)j,rt(j),rv(j),irec
               elseif(sin.eq.'D')then
                  write(LERR,110)j,rt(j),rv(j),irec
               endif
            enddo
         endif

      ELSEIF (disco) then
         nn = 0

c the following logic assumes nothing on the HANDVEL card except
c All this rubbish is required due to DISCO left justify on pkey
c HANDVEL PKEY

 400     read(luvel,'(a80)',end=1001,err=412)Shot
         call fsscnf(Shot,' %s %d ',ajunk,irec)

         if ( irec .lt. 1 ) then
            write(LERR,*)' VELIN: No shot point number in '
            write(LERR,*)'        HANDVEL velocity file'
            write(LERR,*)' FATAL'
            stop
         endif

c fill out function to next HANDVEL card

 410     read(luvel,*,end=415,err=415)(rt(ii),rv(ii),ii=nn+1,nn+4)
         nn = nn+4
         goto 410
c on eof must handle correcting nn and go on to bdvel
c on err must assume have just read an HANDVEL card and
c must back up one card and go on to bdvel.  The
c pointer in the luvel file will now be at the 
c appropriate place to begin the next function read
c on the next call to velinp

 412     goto 400

 415     continue

c a read ended by reading the handvel entry of the next function
c must back up to read the next function on the next try

         backspace luvel

c reset nn as function has obviously ended prematurely

         if(rv(nn+1).eq.0.)then
            nn=nn
         elseif(rv(nn+2).eq.0.)then
            nn=nn+1
         elseif(rv(nn+3).eq.0.)then
            nn=nn+2
         elseif(rv(nn+4).eq.0.)then
            nn=nn+3
         endif

c convert times to seconds

         do i=1,nn
            rt(i)=rt(i)/tfact
         enddo

c increment nn to be compatible with tensor etal logic

         nn=nn+1

c echo function just read in
        
         write(LERR,*)' '
         write(LERR,*)'Input velocity function'

      ELSE

         write(LERR,*)' VELIN: no velocity option specified on command'
         write(LERR,*)'        line.  Rerun with appropriate option.'
         write(LERR,*)' Fatal'
         stop

      ENDIF

 1002 if( .not. hmig .and. .not. tape .and. .not. tdfn ) then
         
         if (rv(1) .eq. 0.0) then
            write(LERR,*)'VELIN: First entry in velocity function'
            write(LERR,*)'       invalid.  If there is a zero'
            write(LERR,*)'       time =  0000  try setting it to'
            write(LERR,*)'       be simply 0'
            write(LERR,*)'FATAL'  
            stop
         endif

         nn=nn-1

         do j=1,nn
            write(LERR,100) j, rt(j), rv(j), irec
         enddo

      endif

c in unlikely event we haven't fixed v-functions that are too long/short
c warn user, itrlen is calculated with sample one being time zero

      itrlen = nsi * (nsamp - 1)
      itim = tfact * rt(nn)

      if( itim .gt. itrlen ) then
         write(LERR,*)'VELIN: Last function time of ',itim,' ms exceeds'
         write(LERR,*)'       trace length of ',itrlen,' ms'
         write(LERR,*)'WARNING'
      endif

      if( itim .lt. itrlen ) then
         write(LERR,*)'VELIN: Last function time of ',itim,' ms less '
         write(LERR,*)'       than trace length of ',itrlen,' ms'
         write(LERR,*)'WARNING'
      endif

      call bdvel( rt, rv, nn, sin, vin, sout, vout, MaxTime, MaxDepth, 
     :     nsi, tape, SlopeAdjustmentFactor, Force, verbos, rnmo)

         if(vout.eq.'I') then

c if output sample int override is requested call BuildIntervalVelocity
c with osi instead of nsi

            if ( ilis ) then
               if ( osi .eq. 0 ) then
                  call FifthOrderPolyApprox ( rt, rv, nn, nsamp, nsi, 
     :                 tri, sout )
               else
                  call FifthOrderPolyApprox ( rt, rv, nn, nsamp, osi, 
     :                 tri, sout )
               endif
            else
               if ( osi .eq. 0 ) then
                  call BuildIntervalVelocity ( rt, rv, nsamp, nsi, nn, 
     :                 tri, sout )
               else
                  call BuildIntervalVelocity ( rt, rv, nsamp, osi, nn, 
     :                 tri, sout )
               endif
            endif
         else

c if output sample int override is requested call vel with
c osi instead of nsi

            if ( ilis ) then
               if ( osi .eq. 0 ) then
                  call FifthOrderPolyApprox ( rt, rv, nn, nsamp, nsi, 
     :                 tri, sout )
               else
                  call FifthOrderPolyApprox ( rt, rv, nn, nsamp, osi, 
     :                 tri, sout )
               endif
            else
               if ( osi .eq. 0 ) then
                  call BuildOtherVelocity ( rt, rv, nsamp, nsi, nn, tri,
     :                 sout )
               else
                  call BuildOtherVelocity ( rt, rv, nsamp, osi, nn, tri,
     :                 sout )
               endif
            endif
         endif
c      endif
       
      if ( verbos .and. nn .gt. 80 ) then
             
         write(LERR,*)'Output velocity function'
         do j=1,nn,10
            if(sout.eq.'D')then
               write(LERR,110)j,rt(j),rv(j),irec
            else
               write(LERR,100)j,rt(j),rv(j),irec
            endif
         enddo
         
      endif
         
      if ( verbos .and. nn .le. 80 ) then
         
         write(LERR,*)'Output velocity function'
         do j=1,nn
            if(sout.eq.'D')then
               write(LERR,110)j,rt(j),rv(j),irec
            else
               write(LERR,100)j,rt(j),rv(j),irec
            endif
         enddo
         
      endif

c output velocity function to in XSD pick file format if requested

      if ( ptap(1) .ne. ' ' ) then

         if ( icount .eq. 1 ) then


c write XSD output pick file header

            if ( osi .eq. 0 .and. .not. XSDHeaderWritten ) then
               write ( lupick, 500 )1.0, XSDVelUnitsOverride, float(nsi) 
     :               , nrec, ntrc, nsamp, float(irec - 1), 
     :              XSDInitVelOverride, 0.0
 500           format('Units ',f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5
     :              ,' Offset ',f12.6,1x,f12.6,1x,f12.6,' Count ')
               XSDHeaderWritten = .true.
            elseif ( .not. XSDHeaderWritten ) then
               write ( lupick, 500 )1.0, XSDVelUnitsOverride, float(osi) 
     :              , nrec, ntrc, nsamp, float(irec - 1), 
     :              XSDInitVelOverride, 0.0
               XSDHeaderWritten = .true.
            endif
         endif

c if tape and output is rms or avg then glean values according to 
c SlopeAdjustmentFactor

         if ( tape .and. ( vout .eq. 'R' .or. vout .eq. 'A') ) then
            call sloper(rt, rv, nn, SlopeAdjustmentFactor)
         endif

c output individual pick segments 

         if ( osi .eq. 0 ) then
            XSDsegmentNumber = XSDsegmentNumber + 1
            call WritePick ( lupick, irec, rv, 
     :           rt, nn, nsi, tfact, sout,XSDsegmentNumber )
         else
            XSDsegmentNumber = XSDsegmentNumber + 1
            call WritePick ( lupick, irec, rv, 
     :           rt, nn, osi, tfact, sout,XSDsegmentNumber )
         endif
      endif

      return

 1001 continue
      EndFunctionReadFlag = .true.
      write(LERR,*)'EOF reached on input velocity dataset'
      return

 1003 continue
      EndFunctionReadFlag = .true.
      write(LERR,*)'ERROR reading input velocity dataset'
      stop

 1010 continue
      write(LERR,*)' VELIN: Premature EOF on input velocity dataset'
      write(LERR,*)' FATAL'
      stop

 1011 continue
      write(LERR,*)' VELIN: Premature EOF on input velocity dataset '
      write(LERR,*)'        QC all input and output data '
      write(LERR,*)' ' 
      write(LERR,*)'        Most likely problem is that you have been '
      write(LERR,*)'        editting your velocity file and have'
      write(LERR,*)'        corrupted the SATTLEGGER format '
      write(LERR,*)' '
      write(LERR,*)'        Last function read was : ' 

c increment nn

      nn = nn - 1

c flip interval velocity to top of interval
c required because Sattlegger defines it at bottom of interval

      if(vin.eq.'I')then

         do j=nn,2,-1
            rt(j) = rt(j-1)
         enddo

         rt(1) = 0.
         write(LERR,*)'VELIN: INTERVAL velocity adjusted to top of'
         write(LERR,*)'       interval'
         write(LERR,*)'WARNING'
      endif

c echo function just read in

      write(LERR,*)' '
      write(LERR,*)'Input velocity function'

      do j=1,nn
         if(sin.eq.'T')then
            write(LERR,100)j,rt(j),rv(j),irec
         elseif(sin.eq.'D')then
            write(LERR,110)j,rt(j),rv(j),irec
         endif
      enddo

      EndFunctionReadFlag = .true.
      goto 1002
      end
