C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( nsamp, nsi, ntrc, nrec, nrecv, iform, nsampv, 
     :     nsiv, ntrcv, iformv, iwd, sin, sout, vin, vout, delt, ilis, 
     :     osi, vtap, ntap, otap, ptap, tape, SlopeAdjustmentFactor,
     :     Force)

#include <f77/iounit.h>

      integer   nsamp, nsampv, nsi, nsiv, ntrc, ntrcv, nrec, nrecv
      integer   iform, iformv, delt, osi, lentap, leotap, levtap, leptap

      real      SlopeAdjustmentFactor

      character sin*(*), vin*(*), sout*(*), vout*(*)
      character ntap*(*), otap*(*), vtap*(*), ptap*(*), iwd*(*)

      logical     tape, ilis, Force
 
      lentap = lenth(ntap)
      leotap = lenth(otap)
      levtap = lenth(vtap)
      leptap = lenth(ptap)

      write(LERR,*)' '
      write(LERR,*)'           Global Program Parameters'
      write(LERR,*)' '
      if (lentap .gt. 0) then
        write(LERR,*)'Input seismic data set name = ',ntap(1:lentap)
      else
        write(LERR,*)'Input seismic data set      = stdin'
      endif
      if (leotap .gt. 0) then
        write(LERR,*)'Output velocity data set name= ',otap(1:leotap)
      else
        write(LERR,*)'Output velocity data set     = stdout'
      endif
      if (levtap .gt. 0) then
        write(LERR,*)'Input velocity data set name = ',vtap(1:levtap)
      else
        write(LERR,*)'Input velocity data set      = pipe'
      endif
      if ( ptap .ne. ' ' ) 
     :write(LERR,*)'Output XSD pick file name= ', ptap(1:leptap)
      write(LERR,*)' '
      write(LERR,*)'      seismic data line header values '
      write(LERR,*)' '
      write(LERR,*)'samples/trace      =  ', nsamp
      write(LERR,*)'sample interval    =  ', nsi
      write(LERR,*)'traces per record  =  ', ntrc
      write(LERR,*)'records per line   =  ', nrec
      write(LERR,*)'format of data     =  ', iform
      write(LERR,*)' '

      if(tape)then

         write(LERR,*)'    velocity data line header values '
         write(LERR,*)' '
         write(LERR,*)'samples/trace      =  ', nsampv
         write(LERR,*)'sample interval    =  ', nsiv
         write(LERR,*)'traces per record  =  ', ntrcv
         write(LERR,*)'records per line   =  ', nrecv
         write(LERR,*)'format of data     =  ', iformv

      endif

      write(LERR,*)' '

      if(sin.eq.'T')write(LERR,*)'Input velocity sample scale is Time'    
      if(sin.eq.'D')write(LERR,*)'Input velocity sample scale is Depth'
      if(vin.eq.'I')write(LERR,*)'Input velocity type is Interval'
      if(vin.eq.'R')write(LERR,*)'Input velocity type is RMS'
      if(vin.eq.'A')write(LERR,*)'Input velocity type is Average'
      if(sout.eq.'T')write(LERR,*)'Output velocity sample scale is Time'
      if(sout.eq.'D')write(LERR,*)'Output velocity sample scale is Depth
     :'
      if(vout.eq.'I')write(LERR,*)'Output velocity type is Interval'
      if(vout.eq.'R')write(LERR,*)'Output velocity type is RMS'
      if(vout.eq.'A')write(LERR,*)'Output velocity type is Average'

      write(LERR,*)' '

      if(tape)
     :write(LERR,*)'Slope Adjustment Factor = ',SlopeAdjustmentFactor

      write(LERR,*)' '
      write(LERR,*)'Trace header entry used for indexing = ',iwd

      if(delt.ne.0)write(LERR,*)
     :'Input sample interval override = ',delt

      if(osi.ne.0)write(LERR,*)
     :'Output sample interval override = ',osi

      if(ilis)write(LERR,*)
     :     'Ilis System Fifth Order Polynomial Approximation in Use'

      if(Force)then
         write(LERR,*)' '
         write(LERR,*)
     :        'Zones of RMS velocity inversion will be filled in using'
         write(LERR,*)
     :        'last calculated interval velocity for a given trace'
      endif

      write(LERR,*)' '
      write(LERR,*)' '
      return
      end


