C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rmsint (v,t,n,vi)
C ********************************************************************
C |                                                
C |    Subroutine to compute interval velocity from RMS 
C |    velocity using Dix's equation.                   
C |                                                    
C |    Input:                                         
C |    V   - R*4() - Vector of RMS velocities, in ft/m per sec.
C |    t   - R*4() - Vector of times for the V vector, in sec.
C |    n   - I*4   - Length of the V vector.        
C |                                               
C |    OUTPUT:                                      
C |    vi  - R*4() - Vector of inteval velocities.     
C |                                                  
C ********************************************************************
      DIMENSION V(*),T(*),vi(*)

      vi(1)=v(1)
      DO I=2,N
         T2=T(I)
         T1=T(I-1)
         TDEL=T2-T1
         vi(I)=V(I)*V(I)*T2-V(I-1)*V(I-1)*T1
         vi(I)=vi(I)/TDEL
         if(vi(i).le.0.0)then
           vi(i)=vi(i-1)
         else
          vi(I)=SQRT(vi(I))
         endif
      end do
      RETURN
      END
