C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadNextFcn ( luin, JJ, FormatIn, NumEntries, Record, 
c vxos specifics
c 3D specifics
c xsd specifics
c charisma specifics
c landmark specifics
     : Velocity, Unit, N, Vxos_NumPicks, EndFlag, LI, DI, Xsd_SegNum, 
     : Xsd_SegColor, Xsd_SegName, Xsd_mnemonic, ifmt_TVPT, l_TVPT, 
     : Landmark_Gradient, Landmark_Vzero, ln_TVPT, ifmt_TVPV, l_TVPV,
     : Landmark_Dzero, Landmark_Vmax, Landmark_nhor, ln_TVPV, UnitSc,
     : Landmark_watvel, Charisma_vel_flag,
c usp specifics
c vds3d specifics
c flat3d specifics
     : iwd, ifmt_iwd, l_iwd, ln_iwd, itr, ifmt_DphInd, l_DphInd, 
     : ln_DphInd, ifmt_LinInd, l_LinInd, ln_LinInd, Usp_SmpIntOverride, 
     : ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, ifmt_CDPBCY, l_CDPBCY, 
     : ln_CDPBCY, Vds_OacLine, Flat3d_LI, Flat3d_DI, Geco_type, 
c flat3d1 specifics
c geco specifics
     :     Flat3d1_LI, Flat3d1_DI, Flat3d1_Nelem,
c ev3d specifics
     :     Earth_NumX, Earth_NumY, Earth_NumZ, Work, itemSpace,
     :     Earth_DI, Earth_LI, Earth_X, Earth_Y, topWrd, botWrd,
     :     EarthSpace, Earth_TopSurface, Earth_BottomSurface, 
c western3d specifics
c disco3d specifics
     :     West_Line, West_Shot, West_Reshot, West_Long, West_Lat, 
     :     West_Units, disco_LI, disco_DI, Geco_comment, Geco_LineName,
c ukooa specifics
     :     ukooa_LI, ukooa_DI, ukooa_LatLong, ukooa_X, ukooa_Y, verbos,
c agip specifics
     :     agip_flg )

c routine to read the next velocity function and supply data back to 
c main in arrays of
c
c     Record -> record number
c     Velocity -> velocity in units/second
c     Unit -> time or depth in seconds or meters [ft]

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <save_defs.h>

c variables passed from calling routine

      integer luin, JJ, NumEntries, N, itr(SZLNHD)
      integer Vxos_NumPicks(NumEntries)
      integer Xsd_SegNum, Xsd_SegColor
      integer ifmt_iwd, l_iwd, ln_iwd
      integer ifmt_DphInd, l_DphInd, ln_DphInd
      integer ifmt_LinInd, l_LinInd, ln_LinInd
      integer ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer LI, DI, Landmark_nhor, Usp_SmpIntOverride
      integer Flat3d1_Nelem
      integer Earth_NumX, Earth_NumY, Earth_NumZ, itemSpace
      integer Earth_DI, Earth_LI, Earth_X, Earth_Y, topWrd
      integer botWrd, EarthSpace
      integer West_Shot, West_NumPairs
      integer disco_LI, disco_DI
      integer ukooa_LI, ukooa_DI, ukooa_X, ukooa_Y
      integer Geco_type
      integer ifmt_TVPT(21), l_TVPT(21), ln_TVPT(21)
      integer ifmt_TVPV(21), l_TVPV(21), ln_TVPV(21)

      real  Record(NumEntries), Velocity(NumEntries), Unit(NumEntries)
      real  Landmark_Gradient, Landmark_Vmax, Landmark_Vzero
      real  Landmark_Dzero, Landmark_watvel 
      real  Flat3d_LI, Flat3d_DI
      real  Flat3d1_LI, Flat3d1_DI
      real  Work(itemSpace)
      real  Earth_TopSurface(EarthSpace)
      real  Earth_BottomSurface(EarthSpace)
      real  West_Lat, West_Long

      character FormatIn*(*), Xsd_SegName*20, Xsd_mnemonic*6, iwd*6
      character Vds_OacLine*7
      character West_Line*7, West_Reshot*1, West_Units*1
      character ukooa_LatLong*26
      character Geco_LineName*10, Geco_comment*14

      logical EndFlag, agip_flg, Charisma_vel_flag, verbos

c local variables

      integer irec, limit, Step, count, U_index, V_index
      integer ukooa_time(4), ukooa_velocity(4), usp_X, usp_Y
      integer western_time(5), western_velocity(5)

      real junkDI, junkLI, uWork(SZLNHD), vWork(SZLNHD)
      real junkX, junkY
      real*8 djunkX, djunkY
      
      character Shot*80, ajunk*7, ukooa_end*3, card*80

c save inline number
      real r_li_junk
      save r_li_junk
c initialize variables

      call vclr(Record, 1, NumEntries)
      call vclr(Velocity, 1, NumEntries)
      call vclr(Unit, 1, NumEntries)
      Step = 1

      IF ( FormatIn .eq. 'xsd' ) then

         call XsdReadPicks( luin, Record, Velocity, Unit, N, 
     :        NumEntries, Xsd_SegNum, Xsd_SegName, Xsd_SegColor )
         call EchoFunction( LERR, Record, Velocity, Unit, N, step )
         return
         
      ELSEIF ( FormatIn .eq. 'xsdheader' ) then

         call XsdReadHeader(luin, Record, Velocity, Unit, N, 
     :        Xsd_SegName, Xsd_SegColor, Xsd_mnemonic, NumEntries )
         call EchoFunction(LERR, Record, Velocity, Unit, N, Step)
         return

      ELSEIF ( FormatIn .eq. 'geco' ) then

         call GecoReadCards(luin, Velocity, Unit, N, NumEntries, LI, 
     :        DI, Geco_LineName, Geco_comment, Geco_type )
         if ( verbos ) then
            call EchoFlat3dFunction ( float(LI), float(DI), Unit, 
     :           Velocity, N)
         endif
         return

      ELSEIF ( FormatIn .eq. 'flat' ) then

         N = 0
         do while (1 .eq. 1 )
            N = N + 1
            read(luin, *, end=1001, err=1003) Unit(N), Velocity(N), 
     :           Record(N)

            if ( Unit(N) .lt. 0.0 ) then

c echo function just read in

               N = N - 1
               call EchoFunction(LERR, Record, Velocity, Unit, N, Step)
               call vclr ( Unit(N+1), 1, NumEntries - N ) 
               return
            endif
         enddo

      ELSEIF ( FormatIn .eq. 'tdfn' ) then

         call TdfnReadCards ( luin, Record, Velocity, Unit, N, 
     :     NumEntries )
         call EchoFunction(LERR, Record, Velocity, Unit, N, Step)
         ukooa_LI = 1
         ukooa_DI = Record(1)
         ukooa_X = 0
         ukooa_Y = 0
         ukooa_LatLong = ' '
         return

      ELSEIF ( FormatIn .eq. 'usp' ) then

c  read USP velocity dataset

         call rtape( luin, itr, lbytes )

         if(lbytes .eq. 0) then
            EndFlag = .true.
            return
         endif

         N = NumEntries
         call vmov(itr(ITHWP1),1, Velocity, 1, N)
         call saver2(itr, ifmt_iwd, l_iwd, ln_iwd, irec, 
     :        TRACEHEADER )
         do i = 1, N
            Record(i) = float(irec)
c set first sample to zero time
            Unit(i) = (i-1)
         enddo

         if (verbos) then
            if ( N .gt. 30 ) Step = 50
            call EchoFunction(LERR, Record, Velocity, Unit, N, 
     :           Step)
         endif

c following is to handle vds3d, flat3d, disco3d, ukooa or landmark output

         call saver2(itr, ifmt_LinInd, l_LinInd, ln_LinInd, LI, 
     :        TRACEHEADER )
         call saver2(itr, ifmt_DphInd, l_DphInd, ln_DphInd, DI, 
     :        TRACEHEADER )
         call saver2(itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, usp_X, 
     :        TRACEHEADER )
         call saver2(itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, usp_Y, 
     :        TRACEHEADER )
         Flat3d_DI = float(DI)
         Flat3d_LI = float(LI)
         Flat3d1_DI = float(DI)
         Flat3d1_LI = float(LI)
         ukooa_LI = LI
         ukooa_DI = DI
         ukooa_X = usp_X
         ukooa_Y = usp_Y
         ukooa_LatLong = ' '
         disco_LI = LI
         disco_DI = DI
         Xsd_SegNum = float(JJ)

         return
        
      ELSEIF ( FormatIn .eq. 'disco' .or. 
     :        FormatIn .eq. 'disco3d' .or. 
     :        FormatIn .eq. 'disco3dxy' .or. 
     :        FormatIn .eq. 'disco3d3' .or. 
     :        FormatIn .eq. 'disco3d1' ) then

         N = 0

c read disco HANDVEL format card entry

 400     if ( FormatIn .eq. 'disco3d1' ) then

            read(luin,'(8x,I4,I4)') disco_LI, disco_DI
         else
            read(luin,'(a80)',end=1001,err=412) Shot
         endif

         if ( FormatIn .eq. 'disco' ) then
            call fsscnf(Shot,' %s %d ',ajunk,irec)
            if ( irec .lt. 1 ) then
               write(LERR,*)' VOMIT: No shot point number in '
               write(LERR,*)'        HANDVEL velocity file'
               write(LERR,*)' FATAL'
               stop
            endif

         elseif ( FormatIn .eq. 'disco3d' ) then
            call fsscnf(Shot,' %s %d %d %d ', ajunk, irec, disco_LI, 
     :           disco_DI)
            if ( irec .lt. 1 ) then
               write(LERR,*)' VOMIT: No shot point number in '
               write(LERR,*)'        HANDVEL velocity file'
               write(LERR,*)' FATAL'
               stop
            endif

         elseif ( FormatIn .eq. 'disco3d3' ) then

            call fsscnf(Shot,' %s %d %d ', ajunk, disco_LI, disco_DI)

         elseif ( FormatIn .eq. 'disco3dxy' ) then

            call fsscnf(Shot,' %s %d %f %f %d %d ', ajunk, irec, junkX,
     :           junkY, disco_LI, disco_DI)
            ukooa_X = nint(junkX)
            ukooa_Y = nint(junkY)

         endif

c fill out function to next HANDVEL card

         do while ( 1 .eq. 1 )
            read ( luin, *, end=415, err=415) 
     :           ( Unit(ii), Velocity(ii), ii = N+1, N+4 )
            N = N+4
         enddo

c on eof must handle correcting N 
c on err must assume have just read an HANDVEL card and
c must back up one card and go on.  The
c pointer in the luin file will now be at the 
c appropriate place to begin the next function read
c on the next call to ReadNextFcn.

 412     goto 400
 415     continue

c a read ended by reading the handvel entry of the next function
c must back up to read the next function on the next try

         backspace luin

c reset N to account for actual number of non-zero velocity entries.
c if last handvel card is not full then N will be too big and if we
c bailed on the last handvel entry due to hitting the EOF we may have
c to add up to 4 to N.

         do i = 1,N+4
            if ( Velocity(i) .gt. 1.e-32 )ntemp = i
         enddo

         N = ntemp

c echo function just read in

         if ( FormatIn .eq. 'disco' ) then
 
            do j = 1, N
               Record(j) = irec
            enddo

            if ( verbos ) 
     :           call EchoFunction(LERR, Record, Velocity, Unit, N, 
     :           Step)
        else

           LI = disco_LI
           DI = disco_DI

           do j = 1, N
              Record(J) = float(LI)
           enddo

           if ( verbos )
     :          call EchoFlat3dFunction ( disco_LI, disco_DI, Unit, 
     :          Velocity, N )
        endif

        return

      ELSEIF ( FormatIn .eq. 'vxos' ) then
         
         N = Vxos_NumPicks(JJ)
         call VxosReadPicks( luin, Record, Velocity, Unit, N, 
     :        NumEntries, Xsd_SegNum, Xsd_SegName, Xsd_SegColor )

c again if appending to a file [which is the norm in vxos] the segment
c numbers may be bogus so use sequential number for segment number

         Xsd_SegNum = float(JJ)

         call EchoFunction( LERR, Record, Velocity, Unit, N, step )
         return
         
      ELSEIF ( FormatIn .eq. 'landmark' ) then

         N = Landmark_nhor
         read(luin,*,err=1003, end=1001) DI, LI, Landmark_Gradient,
     :        ( unit(i), velocity(i), i=1, N )

         Flat3d_DI = DI
         Flat3d_LI = LI

         if (verbos) then
            write(LERR,*)' DI =', DI, ' LI = ', LI,' Gradient = ', 
     :           Landmark_Gradient, ' Fcn = ', 
     :           (unit(i), velocity(i), i = 1, N )
         endif

c construct first velocity using v0 and K and Vmax
         
         Landmark_Vzero = velocity(1)
         Landmark_Dzero = unit(1)

         velocity(1) = velocity(1) + Landmark_Gradient * unit(1)
         if ( velocity(1) .gt. Landmark_Vmax 
     :        .and. Landmark_Vmax .gt. 0.0 ) 
     :        velocity(1) = Landmark_Vmax

c interpolate instantaneous interval velocity values for the first layer
c based on gradient from card

         vWork(1) = Landmark_Vzero
         uWork(1) = 0.0
         N = N + 1

         limit = nint( Landmark_Dzero/ float(Usp_SmpIntOverride) )
         do i = 2, limit
            uWork(i) = float(i-1) * float(Usp_SmpIntOverride)
            vWork(i) = vWork(i-1) + Landmark_Gradient * 
     :           (uWork(i)- uWork(i-1))
            if ( vWork(i) .gt. Landmark_Vmax ) vWork(i) = Landmark_Vmax
            N = N + 1
         enddo

         do i = 1, Landmark_nhor
            uWork(limit + i) = unit(i)
            vWork(limit + i) = velocity(i)
         enddo

         do i = 1, N
            unit(i) = uWork(i)
            velocity(i) = vWork(i)
         enddo
            
         return

      ELSEIF ( FormatIn .eq. 'landmark2' ) then

         N = Landmark_nhor
         read(luin,*,err=1003, end=1001) DI, LI, Landmark_Gradient,
     :        ( unit(i), velocity(i), i=1, N )

         Flat3d_DI = DI
         Flat3d_LI = LI

         if (verbos) then
            write(LERR,*)' DI =', DI, ' LI = ', LI,' Gradient = ', 
     :           Landmark_Gradient, ' Fcn = ', 
     :           (unit(i), velocity(i), i = 1, N )
         endif

c construct first layer using watvel 

         uWork(1) = unit(1)
         vWork(1) = Landmark_watvel

c interpolate instantaneous interval velocity values for the second layer
c based on gradient from card
         
         Landmark_Vzero = velocity(1)
         Landmark_Dzero = unit(1)

         if ( velocity(1) .gt. Landmark_Vmax 
     :        .and. Landmark_Vmax .gt. 0.0 ) 
     :        velocity(1) = Landmark_Vmax

c interpolate instantaneous interval velocity values for the first layer
c based on gradient from card

         vWork(2) = Landmark_Vzero
         uWork(2) = unit(1) + float(Usp_SmpIntOverride)
         N = N + 1

         limit = nint( (unit(2) - unit(1) )/ float(Usp_SmpIntOverride) )
         do i = 3, limit
            uWork(i) = unit(1) + float(i-1) * float(Usp_SmpIntOverride)
            vWork(i) = vWork(i-1) + Landmark_Gradient * 
     :           (uWork(i)- uWork(i-1))
            if ( vWork(i) .gt. Landmark_Vmax .and.
     :           Landmark_Vmax .ne. 0.0  ) vWork(i) = Landmark_Vmax
            N = N + 1
         enddo

         do i = 2, Landmark_nhor
            uWork(limit + i - 1) = unit(i)
            vWork(limit + i - 1) = velocity(i)
         enddo

         do i = 1, N
            unit(i) = uWork(i)
            velocity(i) = vWork(i)
         enddo
            
         return

      ELSEIF ( FormatIn .eq. 'vds3d' ) then

c read and echo function at this location

         call Vds3dReadCards( luin, Velocity, Unit, N, NumEntries, 
     :        Vds_OacLine, DI, LI )
         call EchoVds3dFunction( LERR, DI, LI, Vds_OacLine,
     :        Velocity, Unit, N )
         Flat3d_LI = float(LI)
         Flat3d_DI = float(DI)
         Flat3d1_LI = float(LI)
         Flat3d1_DI = float(DI)
         disco_LI = LI
         disco_DI = DI
         ukooa_LI = LI
         ukooa_DI = DI
         ukooa_X = 0
         ukooa_Y = 0
         ukooa_LatLong = ' '

         return

      ELSEIF ( FormatIn .eq. 'vip' ) then

c read and echo function at this location

         N = 0

c read **location card entry

 500     read(luin,'(a80)',end=1001,err=512) Shot

         call fsscnf(Shot,' %s %d %d ', ajunk, DI, LI )

c read past bogus HANDVEL card

         read ( luin,'(a80)',end=1001,err=512) Shot

c fill out function to next **location card

         do while ( 1 .eq. 1 )
            read ( luin, *, end=515, err=515) 
     :           ( Unit(ii), Velocity(ii), ii = N+1, N+4 )
            N = N+4
         enddo

c on eof must handle correcting N 
c on err must assume have just read an **location card and
c must back up one card and go on.  The
c pointer in the luin file will now be at the 
c appropriate place to begin the next function read
c on the next call to ReadNextFcn.

 512     goto 500
 515     continue

c a read ended by reading the handvel entry of the next function
c must back up to read the next function on the next try

         backspace luin

c reset N to account for actual number of non-zero velocity entries.
c if last handvel card is not full then N will be too big and if we
c bailed on the last handvel entry due to hitting the EOF we may have
c to add up to 4 to N.

         do i = 1,N+4
            if ( Velocity(i) .gt. 1.e-32 )ntemp = i
         enddo

         N = ntemp

         Flat3d_LI = float(LI)
         Flat3d_DI = float(DI)
         Flat3d1_LI = float(LI)
         Flat3d1_DI = float(DI)
         disco_LI = LI
         disco_DI = DI
         ukooa_LI = LI
         ukooa_DI = DI
         ukooa_X = 0
         ukooa_Y = 0
         ukooa_LatLong = ' '

         if ( verbos )
     :        call EchoFlat3dFunction ( Flat3d_LI, Flat3d_DI, 
     :        Unit,Velocity, N )

         return

      ELSEIF ( FormatIn .eq. 'flat3d' ) then
         i = 1
         read(luin, *, err=1003, end=1001) Flat3d_LI, Flat3d_DI, 
     :        Unit(i), Velocity(i)

         do while ( 1 .eq. 1 )
            i = i + 1
            read(luin, *, err=1003, end=1001) junkLI, junkDI, 
     :           Unit(i), Velocity(i)
            if ( abs ( junkLI - Flat3d_LI ) .gt. 1.e-30  .or.
     :           abs ( junkDI - Flat3d_DI) .gt. 1.e-30 ) then
               Velocity(i) = 0.0
               Unit(i) = 0.0
               N = i - 1
               backspace ( luin )
               DI = nint ( Flat3d_DI ) 
               LI = nint ( Flat3d_LI )
               Flat3d1_LI = Flat3d_LI
               Flat3d1_DI = Flat3d_DI
               disco_LI = LI
               disco_DI = DI
               if ( verbos ) then
                  call EchoFlat3dFunction ( Flat3d_LI, Flat3d_DI, Unit, 
     :                 Velocity, N)
               endif
               return
            endif
         enddo


      ELSEIF ( FormatIn .eq. 'promax3d' ) then

c pointer is positioned to read  first line of function.  Read until
c next function is encountered then back up one.

         i = 1
         read (luin,'(10x,2f10.0,f10.2,10x,f10.2)', err=1003, end=302)
     :           Flat3d_LI, Flat3d_DI, Unit(i), Velocity(i)
         if (Flat3d_LI .ne. 0.0) then
             r_li_junk = Flat3d_LI
         else
             Flat3d_LI = r_li_junk
         endif

         do while (1.eq.1)

            i = i + 1

            read (luin,'(10x,2f10.0,f10.2,10x,f10.2)',err=1003,end=302)
     :           junkLI, junkDI, Unit(i), Velocity(i)

            if ( junkDI .ne. Flat3d_DI .and. i .gt. 1
     :           .and. junkDI .ne. 0.0 ) then
               Velocity(i) = 0.0
               Unit(i) = 0.0
               N = i - 1
               backspace ( luin )
               DI = nint ( Flat3d_DI)
               LI = nint ( Flat3d_LI )
               Flat3d1_LI = Flat3d_LI
               Flat3d1_DI = Flat3d_DI
               disco_LI = LI
               disco_DI = DI
               if ( verbos ) then
                  call EchoFlat3dFunction ( Flat3d_LI, Flat3d_DI, Unit,
     :                 Velocity, N)
               endif
               return
            endif

         enddo

 302     continue
         N = i - 1
         call EchoFlat3dFunction ( Flat3d_LI, Flat3d_DI, Unit,
     :                 Velocity, N)
         return

      ELSEIF ( FormatIn .eq. 'flat3d1' ) then

         read ( luin, *, err=1003, end=1001 ) Flat3d1_LI, Flat3d1_DI, 
     :        ( Unit(i), Velocity(i), i = 1, NumEntries )
         N = NumEntries
         DI = nint ( Flat3d1_DI ) 
         LI = nint ( Flat3d1_LI )
         Flat3d_LI = Flat3d1_LI
         Flat3d_DI = Flat3d1_DI
         disco_LI = LI
         disco_DI = DI
         if ( verbos ) then
            call EchoFlat3dFunction ( Flat3d1_LI, Flat3d1_DI, Unit, 
     :           Velocity, N)
         endif
         return

      ELSEIF ( FormatIn .eq. 'ev3d' ) then

c with this option I already have read the entire function set into memory and
c may now step around in memory picking out the induvidual elements of each function
c as they are required.  They where read in in the order that they appeared in the
c original file.  It is assumed that the first index [X] corresponds to the induvidual
c traces of a record, the second index [Y] corresponds to the records so that Earth_NumX
c is the number of traces/record and Earth_NumY is the number of records in the dataset.

         count = 1
         U_index = 2 * Earth_NumX * Earth_NumY * Earth_NumZ
         V_index = 3 * Earth_NumX * Earth_NumY * Earth_NumZ

         do i = JJ, Earth_NumX*Earth_NumY*Earth_NumZ, 
     :        Earth_NumX*Earth_NumY

c pick up abs(unit) as Earth Vision output has depth increasing negative

            Unit(count) = abs(Work(U_index + i))
            if ( Unit(count) .ge. abs(Earth_TopSurface(JJ)) .and.
     :           Unit(count) .le. abs(Earth_BottomSurface(JJ) ) ) then
               Velocity(count) = Work(V_index + i )
               count = count + 1
            endif
         enddo

         N = count - 1

c sort into increasing depth if required

         if ( Unit(N) .lt. Unit(1) )
     :        call hsort2 ( N, Unit, Velocity )

         Earth_X = nint ( Work( JJ ) )
         Earth_Y = 
     :        nint ( Work( Earth_NumX * Earth_NumY *Earth_NumZ + JJ ) )

c increment LI and DI indexing based on (mod(JJ,Earth_NumX) ) as the input 
c grid has x [trace] incrementing the fastest.  The vel data is actually
c stored in depth slices.

         Earth_DI = Earth_DI + 1
         if ( Earth_DI .gt. Earth_NumX ) then
            Earth_DI = 1
            Earth_LI = Earth_LI + 1
         endif

c assign top and bottom headerword values to be output to the trace header
c of this trace.

         topWrd = nint(abs(Earth_TopSurface(JJ)))
         botWrd = nint(abs(Earth_BottomSurface(JJ)))

      ELSEIF ( FormatIn .eq. 'kelman' ) then

c read function header card to get coordinates

         read(luin, '(6x,i6,10x,i6,6x,2d12.2)', err=1003, end=1001) LI, 
     :        DI, djunkX, djunkY

         ukooa_X = dnint(djunkX)
         ukooa_Y = dnint(djunkY)
         flat3d_LI = float(LI)
         flat3d_DI = float(DI)

c read function

         i = 1

         do while ( 1 .eq. 1 )

            read ( luin, '(a5)', err=1003, end=1001) ajunk
            
            if ( ajunk .eq. 'INLIN' ) then
               
               N = i - 1
               backspace ( luin )
               if ( verbos ) then
                  call EchoUkooaFunction ( LI, DI, ukooa_X, ukooa_Y, 
     :              Unit, Velocity, N)
               endif
               return

            else

               backspace ( luin )
               read(luin, '(2i10)', err=1003, end=1001)
     :              ukooa_time(1), ukooa_velocity(1)
               Unit(i) = float(ukooa_time(1))
               Velocity(i) = float(ukooa_velocity(1))
               i = i + 1

            endif
               
         enddo

      ELSEIF ( FormatIn .eq. 'western3d' ) then

c Max of 34 time-velocity pairs per location, missing pairs will be blank.

         read(luin, 100, err=1003, end=1001)West_Line, West_Shot, 
     :        West_Reshot, West_Long, West_Lat, West_Units, 
     :        West_NumPairs
 100     format(a7, i5, a1, 13x, 2f8.3, 13x, a1, i4)

c now we know how many pairs to read so back up and read them

         backspace luin  

         N = West_NumPairs
         read ( luin, 101, err=1003, end=1001 ) (Unit(i),i=1,N), 
     :        (Velocity(j),j=1,N)
 101     format(60x,68f5.0)

         if (verbos) 
     :        call EchoWestern3dFunction(West_Shot, Velocity, Unit, N)

         return

      ELSEIF ( FormatIn .eq. 'western3d1' ) then

c read SPNT card

         read ( luin,'(17x,f8.1,3I10)',err=1003) junkDI, ukooa_X, 
     :        ukooa_Y, LI
         DI = nint(junkDI)

c read first VELF card
         
         read ( luin,'(20x,10I5)',err=1003) 
     :        ( western_time(i),western_velocity(i),i=1,5 )
         N=5
         do i = 1,N
            Unit(i) = float(western_time(i) )
            Velocity(i) = float(western_velocity(i) )
         enddo

c read rest of Velf cards but check to make sure you haven't stumbled on the next
c SPNT card

         do  while ( 1 .eq. 1 )
         
            read ( luin,'(a80)', err=1003, end=99 ) Card
                  
            if ( Card(1:4) .eq. 'SPNT' ) then

               backspace(luin)

c reset N to account for actual number of non-zero velocity entries.
c if last card is not full then N will be too big and if we
c bailed on the last entry due to hitting the EOF we may have
c to add up to 5 to N.

               do i = 1, N
                  if ( Velocity(i) .gt. 1.e-32 )ntemp = i
               enddo

               N = ntemp

c echo function read in

               call EchoUkooaFunction ( LI, DI, ukooa_X, ukooa_Y, Unit, 
     :              Velocity, N )

               return

            else

               backspace(luin)

               read ( luin,'(20x,10I5)',err=98) ( western_time(i),
     :              western_velocity(i),i=1,5 )

               do i = N+1, N+5
                  Unit(i) = float( western_time(i-N) )
                  Velocity(i) = float( western_velocity(i-N) )
               enddo

               N = N + 5
            endif

         enddo

 98      continue

c need to read last card again and pick up the correct number of entries

         backspace(luin)

         do i = 1,5
            western_time(i) = 0
            western_velocity(i) = 0
         enddo

         read (luin,'(a80)', err=98) Card
         
         if ( Card(54:55) .ne. ' ' ) then
            call fsscnf ( Card, ' %s %d %d %d %d %d %d %d %d ', ajunk,
     :           western_time(1), western_velocity(1),
     :           western_time(2), western_velocity(2),
     :           western_time(3), western_velocity(3),
     :           western_time(4), western_velocity(4) )
            do i = N+1, N+4
                  Unit(i) = float( western_time(i-N) )
                  Velocity(i) = float( western_velocity(i-N) )
            enddo
            N = N + 4
            
         elseif ( Card(44:45) .ne. ' ' ) then
            call fsscnf ( Card, ' %s %d %d %d %d %d %d ', ajunk,
     :           western_time(1), western_velocity(1),
     :           western_time(2), western_velocity(2),
     :           western_time(3), western_velocity(3))
            do i = N+1, N+3
                  Unit(i) = float( western_time(i-N) )
                  Velocity(i) = float( western_velocity(i-N) )
            enddo
            N = N + 3
         elseif  ( Card(34:35) .ne. ' ' ) then
            call fsscnf ( Card, ' %s %d %d %d %d ', ajunk,
     :           western_time(1), western_velocity(1),
     :           western_time(2), western_velocity(2))
            do i = N+1, N+2
                  Unit(i) = float( western_time(i-N) )
                  Velocity(i) = float( western_velocity(i-N) )
            enddo
            N = N + 2
         elseif  ( Card(24:25) .ne. ' ' ) then
            call fsscnf ( Card, ' %s %d %d ', ajunk,
     :           western_time(1), western_velocity(1) )
            do i = N+1, N+1
                  Unit(i) = float( western_time(i-N) )
                  Velocity(i) = float( western_velocity(i-N) )
            enddo
            N = N + 1
         endif
            
 99      continue


c reset N to account for actual number of non-zero velocity entries.
c if last card is not full then N will be too big and if we
c bailed on the last entry due to hitting the EOF we may have
c to add up to 5 to N.

         do i = 1, N
            if ( Velocity(i) .gt. 1.e-32 )ntemp = i
         enddo

         N = ntemp

c echo function read in

         call EchoUkooaFunction ( LI, DI, usp_X, usp_Y, Unit, 
     :        Velocity, N )

         return

      ELSEIF ( FormatIn .eq. 'ukooa' ) then

c read the function header [UKOOA 9.1 Ascii Card Format]

         read ( luin, '(4x,2i5,4x,a26,2i8)' ) ukooa_LI, ukooa_DI, 
     :        ukooa_LatLong, ukooa_X, ukooa_Y

         LI = ukooa_LI
         DI = ukooa_DI

c read the associated  function

         ukooa_end = '   '
         count = 1
         do while ( ukooa_end .ne. 'END' )
            read ( luin, '(a3,5x,4(2i5,10x))' ) ukooa_end, 
     :           (ukooa_time(i), ukooa_velocity(i), i=1,4)

            if ( ukooa_end .ne. 'END' ) then
               do i = 1,4
                  Record(count + i - 1) = float(ukooa_LI)
                  Unit(count + i - 1) = float(ukooa_time(i))
                  Velocity(count + i - 1) = float(ukooa_velocity(i))
               enddo
               count = count + 4
            endif
         enddo

c determine number of elements in this function.  unused elements
c are flagged with a -1 on the input

         N = 0

         do i = 1, count
            if ( Unit(i) .gt. 0.0 ) N = N + 1
         enddo

         if ( Unit(1) .eq. 0.0 ) N = N + 1

c clear out negative time entries which bugger up conversion to other
c formats

         do i = N+1, count
            Unit(i) = 0.0
            Velocity(i) = 0.0
            Record(i) = 0.0
         enddo

c echo input function to printout file

         if ( verbos ) call EchoUkooaFunction ( ukooa_LI, ukooa_DI, 
     :        ukooa_X, ukooa_Y, Unit, Velocity, N )

         return

      ELSEIF ( FormatIn .eq. 'ukooa1' ) then

c read the function header [UKOOA 8.3.1 Ascii Card Format]

         read ( luin, '(4x,2i10,a20,2i8)' ) ukooa_LI, ukooa_DI, 
     :        ukooa_LatLong, ukooa_X, ukooa_Y

         LI = ukooa_LI
         DI = ukooa_DI

c read the associated  function

         ukooa_end = '   '
         count = 1
         do while ( ukooa_end .ne. 'END' )
            read ( luin, '(a3,5x,4(2i5,10x))' ) ukooa_end, 
     :           (ukooa_time(i), ukooa_velocity(i), i=1,4)

            if ( ukooa_end .ne. 'END' ) then
               do i = 1,4
                  Record(count + i - 1) = float(ukooa_LI)
                  Unit(count + i - 1) = float(ukooa_time(i))
                  Velocity(count + i - 1) = float(ukooa_velocity(i))
               enddo
               count = count + 4
            endif
         enddo

c determine number of elements in this function.  unused elements
c are flagged with a -1 on the input

         N = 1

         do i = 2, count
            if ( Unit(i) .gt. Unit(i-1)) N = N + 1
         enddo

c clear out negative time entries which bugger up conversion to other
c formats [these may or may not be here but it won't hurt to make sure]

         do i = N+1, count
            Unit(i) = 0.0
            Velocity(i) = 0.0
            Record(i) = 0.0
         enddo

c echo input function to printout file

         if ( verbos ) call EchoUkooaFunction ( ukooa_LI, ukooa_DI, 
     :        ukooa_X, ukooa_Y, Unit, Velocity, N )

         return

      ELSEIF ( FormatIn .eq. 'ukooa2' ) then

c read the function header [UKOOA P1/1990 format]

         read ( luin, '(1x,f7.2,11x,f8.3,a19,2f9.1)' ) junkLI, junkDI, 
     :        ukooa_LatLong, junkX, junkY

         LI = nint(junkLI)
         DI = nint(junkDI)
         ukooa_X = nint(junkX)
         ukooa_Y = nint(junkY)
         disco_LI = LI
         disco_DI = DI

c read the associated  function

         count = 1
         ukooa_end = ' '

         do while ( ukooa_end .ne. 'C' )

            read ( luin, '(a1)', end=102 ) ukooa_end

            if ( ukooa_end .ne. 'C' ) then
               backspace ( luin )
               read ( luin, '(a1,3(8x,i5,4x,i5,4x))', end=102 ) 
     :              ukooa_end, 
     :              (ukooa_time(i), ukooa_velocity(i), i=1,3)
               do i = 1,3
                  Record(count + i - 1) = junkLI
                  Unit(count + i - 1) = float(ukooa_time(i))
                  Velocity(count + i - 1) = float(ukooa_velocity(i))
               enddo
               count = count + 3
            endif

         enddo

c determine number of elements in this function.  unused elements
c are flagged with a -1 on the input

c if we have just bumped into the next function be sure to backspace the
c file so the pointer is in the correct position to read the next function.
c If we jump to 102 then we are at the last function.  Just count the 
c entries and go

         if ( ukooa_end .eq. 'C' ) backspace(luin)

102     continue

         N = 1

         do i = 2, count
            if ( Unit(i) .gt. Unit(i-1)) N = N + 1
         enddo

c echo input function to printout file

         if ( verbos ) call EchoUkooaFunction ( LI, DI, 
     :        ukooa_X, ukooa_Y, Unit, Velocity, N )

         return

      ELSEIF ( FormatIn .eq. 'promax' ) then

c pointer is positioned to read  first line of function.  Read until 
c next function is encountered then back up one.

         count = 0

         do while (1.eq.1)

            count = count + 1

            read (luin,'(f10.1,10x,2f10.1)', err=1003, end=202 ) 
     :           junkDI, Unit(count), Velocity(count)

            if (count .eq. 1 ) then
               Record(count) = junkDI
            else
               Record(count) = Record(1)
            endif

            if ( junkDI .ne. Record(1) .and. count .gt. 1 
     :           .and. junkDI .ne. 0.0 ) then
               N = count - 1
               call EchoFunction(LERR, Record, Velocity, Unit, N, Step)
               backspace luin
               return
            endif

         enddo

 202     continue
         N = count - 1
         call EchoFunction(LERR, Record, Velocity, Unit, N, Step)
         return

      
      ELSEIF ( FormatIn .eq. 'digicon' ) then

cmam...add option for reading digicon format
         call digicon (luin, N, Velocity, Unit, ukooa_X, ukooa_Y, 
     :		ukooa_LI, ukooa_DI )

c echo input function to printout file
 
         if ( verbos ) call EchoDigiconFunction ( LERR, ukooa_X,
     :       ukooa_Y, ukooa_LI, ukooa_DI, Velocity, Unit, N)

      ELSEIF ( FormatIn .eq. 'essov2' ) then
cmam...add option for reading essov2 format
         call essov2 (luin, N, Velocity, Unit, ukooa_LI, ukooa_DI,
     :                uWork, vWork )
 
c echo input function to printout file
 
         if ( verbos ) call EchoEssov2Function ( LERR, 
     :       ukooa_LI, ukooa_DI, Velocity, Unit, N)

      ELSEIF ( FormatIn .eq. 'charisma' ) then

cmam...add option for reading charisma format
c  read USP velocity dataset
 
         call rtape( luin, itr, lbytes )
 
         if(lbytes .eq. 0) then
            EndFlag = .true.
            return
         endif
 
         call saver2(itr, ifmt_iwd, l_iwd, ln_iwd, irec,
     :        TRACEHEADER )
 
	 do jj = 1, 21

c read time,depth pair

             call saver2(itr, ifmt_TVPT(jj), l_TVPT(jj), ln_TVPT(jj),
     :        itime, TRACEHEADER )
             call saver2(itr, ifmt_TVPV(jj), l_TVPV(jj), ln_TVPV(jj),
     :        ivel, TRACEHEADER )

           Record(jj) = float(irec)
	   Unit(jj) = float(itime)

c if hit a zero entry prior to TVPT21 then jump out

           if (itime.eq.0 .and. ivel.eq.0) then
             N = jj - 1
             goto 123
           endif

           if ( Charisma_vel_flag ) then
              
c form average velocity if itime is non-zero, this is what Per Gunnar
c wanted.  The rnmo kicker is for Jim Mika who wants to use the 
c Charisma option to just get velocities from loaded headers into USP
c without using the depth, time stuff that was written for Per.  In that
c case we do not want to do anything to the velocities...just use them.

              Velocity(jj) = float(ivel)
           else

              Velocity(jj) = (float(ivel) * 2.) / ( Unit(jj) * UnitSc )
           endif

	 enddo
         N = 21
 123   continue

       if (verbos) then
          if ( N .gt. 30 ) Step = 50
          call EchoFunction(LERR, Record, Velocity, Unit, N,
     :         Step)
       endif

cmam read agip format
      ELSEIF ( FormatIn .eq. 'agip' ) then

cmam check to make sure we haven't already exhausted the input file
   9   if(agip_flg) then
cmam......error: file already read and we expect to read more
           write(LERR,*)' '
	   write(LERR,*)'VOMIT: agip input format'
           write(LERR,*)' premature end of input functions '
           write(LER,*)' '
           write(LER,*)'VOMIT: agip input format'
           write(LER,*)' premature end of input functions '
           return
       endif

        newcnt = -3
        DO while (1.eq.1)
         read (luin, '(a80)', end=10, err=666) card
 
         go to 13
c----
c   last function read hit end of input file
c----
10       continue
         agip_flg = .true.
         if (newcnt .le. 1) go to 9
c----
c   read "card" for input values.
c
c----
13       continue
 
         if ( card(80:80) .eq. '*' ) then
	  if(newcnt.lt.0) then
	   read(card,'(76x,i3,x)') numtv
cmam must be header card for a new function
           call fsscnf (card,'%f %f %f %f', ali, adi, ax, ay )
	   ukooa_LI = nint(ali)
	   ukooa_DI = nint(adi)
	   ukooa_X  = nint(ax)
	   ukooa_Y  = nint(ay)
	  else
cmam this is the header card for the next function
	   backspace luin
	   go to 15
	  endif
 
         else
cmam must be a card containing up to 4 pairs of time/vel info
         newcnt = newcnt + 4
         read(card,14) (Unit(ii),Velocity(ii),ii=newcnt,newcnt+3)
 14      format (8f10.0)
 
         endif

	 if (agip_flg ) then
	    newcnt = newcnt - 4
	    goto 15
	 endif

        ENDDO 
c----
c   for completed valid function:
c   sort in case times are not in ascending order
c----
   15   continue
          kf = newcnt
          do i = 1, newcnt
cmam look for a zero or negative velocity as flag of end of function
           if(Velocity(i).le.0.0) then
            kf = i - 1
            go to 16
           endif
          enddo

   16     continue
 
cmam sort into increasing time
          call hsort2 ( kf, Unit, Velocity )
          ikf = 1
          uWork(1) = Unit(1)
          vWork(1) = Velocity(1)
          do i = 2, kf
	   if (Unit(i).ne.Unit(i-1)) then
            ikf = ikf + 1
            uWork(ikf) = Unit(i)
            vWork(ikf) = Velocity(i)
	   else
	    write(LERR,*)'dropping index=',i
           endif
          enddo
cmam check to see if any t/v pairs were dropped because of duplicate times
          if(ikf.lt.kf) then
            call vmov(uWork,1,Unit,1,ikf)
            call vmov(vWork,1,Velocity,1,ikf)
            kf = ikf
          endif
cmam fill Record for now with function number
	  aJJ = float(jj)
          call vfill (aJJ,Record,1,kf)
	  N = kf
          return
cmam error reading input file
  666     write(LERR,*)' '
          write(LERR,*)'VOMIT: error reading input agip file'
          write(LER ,*)' '
          write(LER ,*)'VOMIT: error reading input agip file'
          EndFlag = .true.
          return

      ENDIF

      return

 1001 continue

      if ( FormatIn .eq. 'flat3d' ) then
         N = i - 1
         if ( verbos ) then
            call EchoFlat3dFunction ( Flat3d_LI, Flat3d_DI, Unit, 
     :           Velocity, N)
         endif
      endif
      DI = nint ( Flat3d_DI ) 
      LI = nint ( Flat3d_LI )
      Flat3d1_LI = Flat3d_LI
      Flat3d1_DI = Flat3d_DI
      disco_LI = LI
      disco_DI = DI
      EndFlag = .true.
      write(LERR,*)'EOF reached on input velocity dataset'
      return

 1003 continue
      EndFlag = .true.
      write(LERR,*)'ERROR reading input velocity dataset'
      stop

      end
