C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine UniqueIntVel( rt, rv, nn, verbos)
 
c input interval velocity came in on tape in which case there will
c be [usually, but not always] many samples with same velocity value.
c this routine will glean out the unique values and form an output
c function where nn is a new number of elements and the interval velocity
c is referenced to the base of the interval
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer nn, count, i
 
      real rt(nn), rv(nn), ttemp(SZLNHD), vtemp(SZLNHD)
 
      logical verbos
 
c initialize memory
 
      call vclr(ttemp,1,SZLNHD)
      call vclr(vtemp,1,SZLNHD)
 
c initialize variables
 
      count = 1
 
c start subroutine
 
      do i=2,nn
 	if(rv(i).ne.rv(i-1)) then
                 vtemp(count) = rv(i-1)
                 ttemp(count) = rt(i-1)
                 count = count+1
         endif
      enddo
 
      vtemp(count) = rv(nn)
      ttemp(count) = rt(nn)
 
      if(count.eq.nn)then
         write(LERR,*)' '
         write(LERR,*)'VOMIT: You have INTERVAL velocity input on'
         write(LERR,*)'       tape with a unique interval at every'
         write(LERR,*)'       sample.  This is very suspicious.   '
         write(LERR,*)'       Check your input function and rebuild'
         write(LERR,*)'       if necessary.'
         write(LERR,*)'WARNING'
      endif
 
      nn = count
 
      do i=1,nn
         rt(i) = ttemp(i)
         rv(i) = vtemp(i)
      enddo
 
c write extracted function to printfile if verbose
 
      if(verbos)then
         write(LERR,*)' Velocity function extracted from tape '
         write(LERR,*)' '
 
         do j=1,nn
            write(LERR,100)j,rt(j),rv(j)
 100  format(i4,' Time/Depth =',f9.3,' Velocity =',f10.2)
         enddo
      endif
 
      return
      end
