C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine UnitsBack( FormatOut, sin, Unit, N, Xsd_SmpUnit,
     :     Xsd_SmpOffset, Xsd_SmpUnitOverride, nsi, Usp_SmpIntOverride,
     :     UnitSc_out )
 
#include <f77/iounit.h>
 
c convert Unit() array to milliseconds from input seconds
 
c variables passed from calling routine
 
      integer N, nsi, Usp_SmpIntOverride
 
      real    Unit(N), Xsd_SmpUnit, Xsd_SmpOffset
      real    Xsd_SmpUnitOverride, UnitSc_out
 
      character sin*1, FormatOut*20
 
c local variables
 
      real tfact, toffset
 
c initialize variables
 
      IF ( FormatOut .eq. 'disco' .or.
     :     FormatOut .eq. 'disco3d' .or.
     :     FormatOut .eq. 'disco3d2' .or.
     :     FormatOut .eq. 'flat' .or.
     :     FormatOut .eq. 'flat3d' .or.
     :     FormatOut .eq. 'flat3d1' .or.
     :     FormatOut .eq. 'geco' .or.
     :     FormatOut .eq. 'landmark' .or.
     :     FormatOut .eq. 'landmark2' .or.
     :     FormatOut .eq. 'tdfn' .or.
     :     FormatOut .eq. 'tdq' .or.
     :     FormatOut .eq. 'tdq2' .or.
     :     FormatOut .eq. 'ukooa' .or.
     :     FormatOut .eq. 'ukooa1' .or.
     :     FormatOut .eq. 'ukooa2' .or.
     :     FormatOut .eq. 'vds3d' .or.
     :     FormatOut .eq. 'vip' .or.
     :     FormatOut .eq. 'western3d' .or.
     :     FormatOut .eq. 'western3d1' .or.
     :     FormatOut .eq. 'zmap' ) then
 
c seconds --> milliseconds
 
         call vsmul ( Unit, 1, 1000.0, Unit, 1, N )
 
      ELSEIF ( FormatOut .eq. 'xsd' .or. FormatOut .eq. 'vxos' ) then
 
         tfact = 1000.0 * Xsd_SmpUnitOverride
         call vsmul ( Unit, 1, tfact, Unit, 1, N )
 
      ELSEIF ( FormatOut .eq. 'xsdheader' ) then
 
c seconds  -->  samples
 
         tfact =  1000.0 / Xsd_SmpUnit
         toffset = Xsd_SmpOffset / 1000.0
 
         do i = 1, N
            Unit(i) = ( Unit(i) - toffset ) * tfact
         enddo
 
      ELSEIF ( FormatOut .eq. 'usp' ) then
 
         if ( sin .eq. 'T' ) then
 
c convert Unit() array back to user required scale using units scale
c factor 

            tfact = 1.0 / UnitSc_out

         else
 
c convert Unit() array back to milliseconds or microseconds
c using -osi if defined else -nsi
 
            if ( Usp_SmpIntOverride .ne. 0 ) then

               tfact = 1.0 / UnitSc_out

            else
               write(lerr,*)' '
               write(lerr,*)'VOMIT: no sample interval specified '
               write(lerr,*)'       for output dataset'
               write(lerr,*)'FATAL'
               write(ler,*)' '
               write(ler,*)'VOMIT: no sample interval specified '
               write(ler,*)'       for output dataset'
               write(ler,*)'FATAL'
               stop
            endif
         endif
 
         call vsmul ( Unit, 1, tfact, Unit, 1, N )
 
      ELSEIF ( FormatOut .eq. 'promax' ) then
 
         write(LERR,*) 'Not Yet'
 
      ELSEIF ( FormatOut .eq. 'promax3d' ) then
 
         write(LERR,*) 'Not Yet'
 
      ENDIF
 
      return
      end
 
