C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine UspResampTrace ( Unit, Velocity, N, nsi,
     :     Usp_SmpIntOverride, nsampo, NumEntries, linear )
 
c routine to resample a currently existing USP format velocity
c trace.  It is assumed that Unit() contains the time axis and
c Velocity() contains velocity and that the units of Unit(),
c and Usp_SmpIntOverride are compatible [i.e.
c if Unit() is in ms then so is  Usp_SmpIntOverride
c if Unit() is microseconds then so is Usp_SmpIntOverride
c if Unit() is meters then so is Usp_SmpIntOverride
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
 
c variables passed from calling routine
 
      integer N, Usp_SmpIntOverride, nsampo, NumEntries, nsi
 
      real Unit(2*NumEntries), Velocity(2*NumEntries)
 
      logical linear
 
c local variables
 
      integer i, j
 
      real yp1, ypn, y2(2*SZLNHD), work(SZLNHD), Sample
 
      logical reset
 
c initialize variables
 
      call vclr(work,1,SZLNHD)
      reset = .false.
 
c if Usp_SmpIntOverride is not defined that implies that nsi and osi are
c the same but something happened to trip the resample [i.e. time to depth
c conversion].  In this case better assign the override here
 
      if ( Usp_SmpIntOverride .eq. 0 ) Usp_SmpIntOverride = nsi
 
c determine if cubic spline or linear interpolation is appropriate.  This is
c done based on the occurance of adjacent identical velocities.  If this
c occurs then linear is the way to go to prevent the second derivative calculati
c from cratering in the spline interpolator.
 
      if ( .not. linear ) then
 
         i = 2
         do while ( i .lt.  N .and. .not. linear )
            if ( ( Velocity(i) - Velocity(i-1) ) .lt. 1.e-4 ) then
               linear = .true.
               reset = .true.
            endif
            i = i + 1
         enddo
 
      endif
 
 
      IF ( .not. linear ) then
 
         call vclr(y2,1,2*SZLNHD)
         yp1 = 1.e+31
         ypn = 1.e+31
 
 
         if ( N .lt. 4 ) then
 
c not enough data to fit spline
 
            write(LERR,*)'  '
            write(LERR,*)' VOMIT: less than 4 input samples in '
            write(LERR,*)'         velocity trace. Resampling to'
            write(LERR,*)'         new output sample interval not'
            write(LERR,*)'         done.  '
            write(LERR,*)' WARNING'
            write(LER,*)'  '
            write(LER,*)' VOMIT: less than 4 input samples in '
            write(LER,*)'         velocity trace. Resampling to'
            write(LER,*)'         new output sample interval not'
            write(LER,*)'         done.  '
            write(LER,*)' WARNING'
            return
         endif
 
c form array of second derivatives for trace
 
         call spline( Unit, Velocity, N, yp1, ypn, y2 )
 
c interpolate output trace
 
         do i = 1, nsampo
            rj = float(i -1) * float(Usp_SmpIntOverride)
 
c don't let the spline extrapolate as it does a really poor job
 
            if ( rj .lt. Unit(N) ) then
               call splint( Unit, Velocity, y2, N, rj, yj)
            else
               yj = work(i-1)
            endif
 
            work(i) = yj
         enddo
 
      ELSEIF ( linear ) then
 
         DO i = 1, nsampo
 
c assign Sample from 1st sample at Sample = zero to be compatible with
c ProMax, CogniSeis, Ilis, MBS, PPRED etc.
 
            Sample  = float(Usp_SmpIntOverride) * float(i-1)
 
            if ( (Sample - Unit(1)) .le. 1.e-4 ) then
 
c first velocity will be used from Sample zero down to and including
c first function Sample
 
               work(i) = Velocity(1)
            elseif ( (Sample - Unit(N)) .ge. 1.e-4 ) then
 
c last velocity will be used from last function Sample to end of trace
c if not specified
 
               work(i) = Velocity(N)
            else
 
c do linear interpolation of velocity such that a given velocity will
c only appear at the Sample specified in the function.
 
               do j=2,N
 
                  if( ( Sample - Unit(j-1)) .ge. 1.e-4
     :                 .and. (Sample - Unit(j)) .le. 1.e-4 ) then
                     fac = (Sample - Unit(j-1)) / (Unit(j) - Unit(j-1))
                     work(i) = Velocity(j-1) + fac *
     :                    ( Velocity(j) - Velocity(j-1) )
                     go to 1002
                  endif
 
               enddo
 
            endif
 
 1002       continue
 
         ENDDO
 
      ENDIF
 
      call vclr ( Velocity, 1, N )
      call vmov( work, 1, Velocity, 1, nsampo )

c rebuild Unit array with new sample interval

      do i = 1, nsampo
         Unit(i) = float ( (i-1) * Usp_SmpIntOverride )
      enddo
 
c if reset is true then linear was set true in this subroutine due to adjacent
c like velocity values.  For now I am going to set linear false again as the
c user has not asked for linear and it may not be the case that it is required
c for the majority of the dataset.
 
      if (reset) linear = .false.
 
      return
      end
