C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine essov2 (luin, N, Velocity, Unit, jnline, jxline,
     :                    uWork, vWork )

#include <f77/iounit.h>

      real        Unit (*), Velocity (*)
      real        uWork(*), vWork(*)
      character   card * 80, ahd*10

C**********************************************************************C
C     read input vel file
C**********************************************************************C
      ixlst  = 0
      iylst  = 0
      N = 0
 
      DO while (1.eq.1)
 
         read (luin, '(a80)', end=93, err=900) card
 
c----
c   read "card" for input values. The valid ones are ICX,ICY,time,vel
c   the first 2 can be dummy integers (this is basically Landmark format).
c----
         call fsscnf (card,'%s %d %d %d %d',
     1                ahd, nline,ixline,itime,ivel)

c----
c   assuming each function is together in the file determine end of function
c   by sensing when either the X or Y coordinate changes. 
c----
         IF (nline .ne. ixlst .OR. ixline .ne. iylst) THEN
c....
c   change in function sensed
c....
            if (N.ge.1) then
cmam...........        if (N.gt.1) then
c....
c   this is not the first card of a function
c   assume this is a new function
c....
               backspace (luin)
cmam           call sort2 (N, Unit, Velocity)
c....
c   check for duplicate velocities for a time...drop the second one
c....
               nn = 1
               vWork(1) = Velocity(1)
               uWork(1) = Unit(1)

               do i = 2, N

                 if(Unit(i) .gt. Unit(i-1)) then
                    nn = nn + 1
                    uWork(nn) = Unit(i)
                    vWork(nn) = Velocity(i)
                 endif
               enddo

               if (nn .lt. N) then
                 call vmov (uWork,1,Unit,1,nn)
                 call vmov (vWork,1,Velocity,1,nn)
                 N = nn
               endif

               return
            else
c....
c   this is the first card of current function
c....
               ixlst = nline
               iylst = ixline
               jnline = nline
               jxline = ixline/2
c....
c   this technically shouldn't happen, but we check to make sure a
c   nonzero velocity was entered
c....
               if (ivel.gt.0) then
                  N = N + 1
                  Unit(N) = float(itime)
                  Velocity(N) = float(ivel)
               endif

            endif

        ELSE
c....
c   no change in the X or Y = same function
c....

c....
c   this technically shouldn't happen, but we check to make sure a
c   nonzero velocity was entered
c....
            if (ivel.gt.0) then
               N = N + 1
               Unit(N) = float(itime)
               Velocity(N) = float(ivel)
            endif

        ENDIF

      enddo

   93   continue

        if (N.gt.0) then
           if (N.ge.2) then
cmam          call sort2 (N, Unit, Velocity)
c....
c   check for duplicate velocities for a time...drop the second one
c....
               nn = 1
               vWork(1) = Velocity(1)
               uWork(1) = Unit(1)
 
               do i = 2, N
 
                 if(Unit(i) .gt. Unit(i-1)) then
                    nn = nn + 1
                    uWork(nn) = Unit(i)
                    vWork(nn) = Velocity(i)
                 endif
               enddo
 
               if (nn .lt. N) then
                 call vmov (uWork,1,Unit,1,nn)
                 call vmov (vWork,1,Velocity,1,nn)
                 N = nn
               endif

              return
           else
              go to 901
           endif
        endif
 
900   continue

      write(LERR,*)' '
      write(LERR,*)'ERROR in VOMIT:reading essov2 format'
      write(LERR,*)'Something bad happened while reading input vel'
      write(LERR,*)' line was:',card
      write(LER ,*)' '
      write(LER ,*)'ERROR in VOMIT:reading essov2 format'
      write(LER ,*)'Something bad happened while reading input vel'
      write(LER ,*)' line was:',card

      stop

901   continue

      write(LERR,*)' '
      write(LERR,*)'WARNING in VOMIT:reading essov2 format'
      write(LERR,*)'Fewer than 2 entries read for a function'
      write(LER ,*)' '
      write(LER ,*)'WARNING in VOMIT:reading essov2 format'
      write(LER ,*)'Fewer than 2 entries read for a function'

      return
      end
