C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c subroutine splint
c
c from Numerical Recipes - Press etal - pp 89
c
      subroutine splint(xa,ya,y2a,n,x,y)
 
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
 
      integer n, khi, klo, k
      real xa(n),ya(n),y2a(2*n)
      real x,y,a,b,h
 
      a = 0.
      b = 0.
      h = 0.
      klo=1
      khi=n
 
1	if (khi-klo.gt.1)then
		k=(khi+klo)/2
		if(xa(k).gt.x)then
			khi=k
		else
			klo=k
		endif
	 goto 1
	endif
      h=xa(khi)-xa(klo)
      if(h.eq.0)goto 999
      a=(xa(khi)-x)/h
      b=(x-xa(klo))/h
      y = a * ya(klo) + b * ya(khi) + ( ( (a*a*a) - a ) * y2a(klo) +
     :     ( (b*b*b) - b) * y2a(khi) ) * ( h**2 ) / 6.
 
      return
999   write (LERR,*)'xa(',klo,') == xa(',khi,') == ',xa(klo)
      write(LERR,*)' FATAL -- for now'
      stop
      end
