C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ta2ti( rt, rv, nn, tape , SlopeAdjustmentFactor, vflag)
 
c ta2ti converts an input AVERAGE velocity function to INTERVAL velocity
c using Dix Equation.
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = AVERAGE velocity in units/second
c
c on output rv() = INTERVAL velocity in units/second
c velocity is referenced to the bottom of the interval
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer nn, i, NewNumberOfPoints
 
      real rt(*), rv(*), vint(SZLNHD), Depth
      real IntervalTime(SZLNHD), temprv(SZLNHD), temprt(SZLNHD), Slope
      real NewSlope, SlopeAdjustmentFactor
 
      logical tape, vflag
 
      character switch*3
 
c initialize memory
 
      call vclr ( vint, 1, SZLNHD )
      call vclr ( IntervalTime, 1, SZLNHD )
      call vclr ( temprv, 1, SZLNHD )
      call vclr ( temprt, 1, SZLNHD )
 
c initialize Depth and set first interval velocity
 
      vint(1) = rv(1)
      Depth = 0.
 
c if TAPE glean samples when slope changes by more than
c        SlopeAdjustmentFactor * Slope
 
      IF ( tape ) then
 
 
c this tells the routine that the reduction of the number
c of function elements has been done so that any future
c routine (ie. tr2ti) doesn't try to do it again.
 
        vflag = .true.
 
         switch = 'off'
         Slope = ( rv(2) - rv(1) ) / ( rt(2) - rt(1) )
         NewNumberOfPoints = 0
 
         DO i = 3 , nn
 
            NewSlope = ( rv(i) - rv(i-1) ) / (rt(i) - rt(i-1) )
 
            if( ( abs( NewSlope - Slope) ) .gt.
     :           ( SlopeAdjustmentFactor * abs( Slope ) ) ) then
               if(switch.ne.'on')then
                  switch = 'on'
                  NewNumberOfPoints = NewNumberOfPoints + 1
                  temprt(NewNumberOfPoints) = rt(i)
                  temprv(NewNumberOfPoints) = rv(i)
                  Slope = NewSlope
               else
                  switch = 'off'
                  Slope = NewSlope
               endif
            endif
 
         ENDDO
 
         do i = 1, NewNumberOfPoints
            rt(i) = temprt(i)
            rv(i) = temprv(i)
         enddo
 
        NewNumberOfPoints = NewNumberOfPoints + 1
        rv(NewNumberOfPoints) = rv(nn)
        rt(NewNumberOfPoints) = rt(nn)
        nn = NewNumberOfPoints
      ENDIF
 
c assign IntervalTime[1]
 
      IntervalTime(1) = rt(1)/2.0
 
      DO i = 2, nn
         IntervalTime(i) = ( rt(i) - rt(i-1) ) / 2.
         Depth = Depth + vint(i-1) * IntervalTime(i-1)
         vint(i) = ( rv(i) * rt(i) / 2. - Depth ) / IntervalTime(i)
      ENDDO
 
      IF ( rt(1) .gt. 1.e-20 ) then
 
c bump rt() array values up one slot to make room for zero entry
 
         do i = nn + 1, 2, -1
            rt(i) = rt(i-1)
         enddo
 
c assign zero time value
 
         rt(1) = 0.
 
c load interval velocities
 
         call vmov ( vint, 1, rv(2), 1, nn )
         rv(1) = rv(2)
         nn = nn+1
      ELSE
 
c load interval velocities
 
         call vmov ( vint, 1, rv, 1, nn )
 
      ENDIF
 
      return
      end
