C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c <<<<<<<<<<<<<<<<<<<<<<<<<<<<< vomit >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c Changes:
c
c Nov 16, 2001 - fixed a bug that Dennis Yanchak encountered in the 
c                logic to get around negative numerators in the Dix
c                square root expression caused by large RMS velocity 
c                inversions.  Dennis had this occur at the end of a 
c                trace using usp input and output format.  The result
c                was a resulting velocity array with N-4 entries.  It
c                got back to the main, was not resampled, and N values
c                were output.  Of course the last 4 values were rubbish.
c                The fix was to add a policeman to the main routine that
c                checked to see, in the case of usp in and out, if N
c                came back less than nsampo, and force was set.  If so
c                then resample was set to .true.  I also set resample
c                to .false. prior to the read of each function so that
c                all traces from that point on were not resampled
c                needlessly as that is very time consuming.
c           Garossino
c
c Nov 2, 2001 - fixed promax3d format description in help and man pages
c               to indicate [input only] status.  Kenny reported discrepancy.
c           Garossino
c
c Sept 25, 2001 - added -promax3d output format for Sandy Rothe, GM, UTG
c           xia
c
c Sept 24, 2001 - added -tdq2 output format for Khaled Khafagy, GUPCO
c           Garossino
c 
c Sept 19, 2001 - folded in Joe Wades logic for dynamic allocation
c                 of the input dataset size for USP or Charisma input
c           Wade/Garossino
c 
c Sept 17, 2001 - added disco3d3 format capability [input only]
c                requested by Alan Poole [UTG]
c           Garossino
c 
c Oct 11, 2000 - added disco3dxy format capability [input only]
c                requested by Alan Poole [UTG]
c           Garossino
c 
c Sept 24 2000 - added zmap format capability [output only]
c                requested by Odd Fogelstad [Stavangar]
c           Garossino
c 
c Sept 2 2000 - added promax format capability [input only]
c           Garossino
c
c Sept 1 2000 - added c_junk4 to western3d1 function counter in Memory.F
c               the junk*8 was failing when the input function had an
c               entry prior to 4 spaces after SPNT
c           Garossino
c
c July 10, 2000 - added -kelman option [uses -vref[] ] for Frank Mixon
c                Red Oak team.  In doing this I finally fixed the negative
c                square root problem to simply drop the offensive function
c                element and go on to the next in an attempt to get a 
c                positive numerator in the tr2ti.F routine.  I am not really
c                sure of all the problems this may cause.  I guess we will find
c                out in time.
c           Garossino
c
c June 23, 2000 - added -landmark2 input format to allow a water column
c                 followed by a gradient layer followed by a function
c                 [GUPCO]
c           Garossino
c
c June 22, 2000 - added -disco3d2 output format - Leendert Padmos
c           Garossino
c
c June 13, 2000 - added -ukooa2 format UKOOA P1/1990 - Leendert Padmos
c                 outputs allowed are usp and tdq for now.
c           Garossino
c
c Apr 18 2000 - added -UnitSc_out to cover conversion from one UnitSc base
c               to another [Tanis:Sunbury]
c           Garossino
c
c Apr 5 2000 - added -disco3d1 format for Jan Kommedal 
c           Garossino
c
c Oct 11 1999 - added -tdq format for Steve Wigger to allow
c              velocity input to Landmark Time Depth Conversion
c              routine
c           Garossino
c
c
c Aug 20 1999 - added -western3d1 format for Jim Mika
c           Garossino
c
c
c Aug 16 1999 - added -vip format for Don Wagner
c           Garossino
c
c Nov 3 1998: - added -ukooa1 format for Deedee [does ukooa8.3.1] 
c           Garossino
c
c Oct 30 1998: - added -velst[] -veled[] for Gutowski
c           M.Miller
c
c Oct 5 1998: - fixed bug in memory management with ukooa option for 
c               Andy Longo
c           Garossino
c
c July 1998: - added -omnivel option for Yan Quist.
c           M.Miller
c
c March 1998: - added -velocity option to be used in conjunction with
c               -charisma option.  If flagged no conversion to average
c               velocity is assumed or done.
c           Garossino
c
c Sept 1997: - added charisma format for Per Folstadt
c           M.Miller
c
c Sept 1997:   - fixed disco handvel output from usp input. Needed to 
c                 clear memory at each function to prevent garbage going
c                 out to resulting disco function.
c           Garossino
c
c November 1996: - corrected problem with flat3d format in Memory.F where
c                  if only a single function was input the NumEntries
c                  would return as 1 always.  Put a MaxNumEntries check
c                  at the 50 statment which solved the problem.
c           Garossino
c September 1996: - added UnitSc determination to replace nsi .gt. 32
c                   microsecond decision.
c           Garossino
c
c August 1996: - fixed landmark option, time input was not making it to 
c                the Units and Units_Back routines.  Also if number of
c                functions was not as prescribed on the command line the
c                routine would output zero traces until JJ = NumFcns.  I 
c                put in some endflag logic to prevent this and warn the user
c                of something fishy with input function.
c           Garossino
c
c August 1996: - added geco format option for Sam Gray
c           Garossino
c
c August 1996: - added ukooa to tdfn and vds3d capability for Richard Crider
c           Garossino
c
c April 1996: - added -ukooa format option for Trinidad Tringas project [does ukooa9.1]
c           Garossino
c
c April 1996: - added -disco3d format option to handle HANDVEL cards with LI,DI
c               information included
c           Garossino
c
c March 1996: - enabled resample from usp in to usp out
c             - fixed bug when depth to time or time to depth and nsi = osi
c               the resample was not tripped
c             - fixed bug in vds3d mc3d card reader
c             - fixed interpolator bug by adding linear option to take over
c               when adjacent samples are equal thereby croaking the 2nd derivat
c               spline calculation
c           Garossino
c
c October 1995: added -western3d format for Kommedal STAT.
c           Garossino
c
c August 1995: added -ev3d format for Day/Mika in GUPCO.
c           Garossino
c
c July 1995: added -flat3d1 format for Steve Wigger in GUPCO.
c           Garossino
c
c Feb 1995: added -flat3d, -vds3d and upgraded -landmark to handle an
c           initial layer with k,d,vo and a -vmax on the command line.
c           Garossino
c
c vomit:
c
c handles velocity data in a variety of formats:
c
c agip
c charisma
c digicon
c disco - handvel
c disco3d - handvel with LI,DI information [Gupco - Nada]
c disco3d1 - handvel with LI,DI information no gaps [Sunbury - Kommedal]
c disco3d2 - handvel with LI,DI immediately after HANDVEL [Stavanger - Padmos]
c disco3dxy - handvel with CDP, X, Y, LI, DI [UTG - Poole]
c essov2
c ev3d [EarthVision_3d ascii grid files Gupco Specification - Day/Mika]
c ev2d [EarthVision_2d ascii files waiting on Gupco Specification - Day/Mika]
c flat file
c flat3d [OBU Specifications]
c flat3d1 [GUPCO Specifications - Wigger]
c geco [Sam Gray request]
c kelman [Frank Mixon request]
c landmark [Gupco Specifications - Mika]
c landmark2 [Gupco Specifications - Mika]
c omnivel
c promax 
c promax3d 
c tdfn
c tdq - landmark TDQ module format
c ukooa - 9.1 velocity format requested by Trinidad Tringas project
c ukooa1 - 8.3.1 velocity format requested by DeeDee Albertin
c ukooa2 - UKOOA P1/1990 format - requested by Leendert Padmos
c usp
c vds3d [OBU Specifications]
c vip
c vxos pickfile
c western3d [Western Geophysical 3D velocity format - Jan Kommedal]
c western3d1 [another Western Geophysical 3D velocity format - Jim Mika]
c xsd pickfile
c xsd header file
c
c allows conversion between RMS, Average and Interval velocity
c allows time --> depth and depth --> time conversions
c
c <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<..>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
 
c platform dependant variables

      implicit none
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
 
c standard USP variables

      integer    nsamp, nsi, ntrc, nrec, nsampo
      integer    luin, luout, nbytes, lbytes, obytes, lbyout
      integer    argis, jerr
 
      character  ntap*255, otap*255, name*5
 
      logical    verbos
 
c program specific variables
 
      integer   NumFcns, NumEntries, N, ierr, length, lenth
      integer   Vxos_NumPicks(SZLNHD)
      integer   ifmt_iwd, l_iwd, ln_iwd
      integer   ifmt_RecNum, l_RecNum, ln_RecNum
      integer   ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer   ifmt_DphInd, l_DphInd, ln_DphInd
      integer   ifmt_LinInd, l_LinInd, ln_LinInd
      integer   ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer   ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer   ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer   ifmt_SoPtAl, l_SoPtAl, ln_SoPtAl
      integer   ifmt_RfsRel, l_RfsRel, ln_RfsRel
      integer   ifmt_WDepDP, l_WDepDP, ln_WDepDP
      integer   ifmt_FldTel, l_FldTel, ln_FldTel
      integer   ifmt_SrPrLt, l_SrPrLt, ln_SrPrLt
      integer   ifmt_SrPrLn, l_SrPrLn, ln_SrPrLn
      integer   ifmt_PrRcNm, l_PrRcNm, ln_PrRcNm
      integer   ifmt_PrTrNm, l_PrTrNm, ln_PrTrNm
      integer   ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer   ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer   SoPtLt
      integer   SoPtLN
      integer	ifmt_TVPT(21), l_TVPT(21), ln_TVPT(21)
      integer	ifmt_TVPV(21), l_TVPV(21), ln_TVPV(21)

      integer   MBSdx, MBSdy, MBSdz, JJ, i
      integer   Xsd_SegNum, Xsd_SegColor, Usp_SmpInt, Usp_SmpIntOverride
      integer   Landmark_nhor
      integer   Vds_StaticsMode, Vds_JobConstantStatic
      integer   Vds_MutePercent, Vds_WaterBottom
      integer   Vds_MinDI, Vds_MaxDI, Vds_MinLI, Vds_MaxLI
      integer   Vds_LIinc, Vds_DIinc, Vds_InterpRadius
      integer   Vds_NumScheme, Vds_DipAzimFlag, Vds_VelPrtInc
      integer   Vds_PrtWgtFlag
      integer   LI, DI
      integer   Flat3d1_Nelem
      integer   Earth_NumX, Earth_NumY, Earth_NumZ, Earth_DI, Earth_LI
      integer   Earth_X, Earth_Y, Earth_lutop, Earth_lubottom
      integer   ifmt_topWrd, l_topWrd, ln_topWrd, topWrd
      integer   ifmt_botWrd, l_botWrd, ln_botWrd, botWrd
      integer   West_Shot
      integer   disco_LI, disco_DI
      integer   ukooa_LI, ukooa_DI, ukooa_X, ukooa_Y
      integer   Geco_type
      integer   SrPtXC, SrPtYC
 
      real      Xsd_VelOffsetOverride, Xsd_VelUnitOverride
      real      Xsd_SmpUnitOverride, SlopeAdjustmentFactor
      real      Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit
      real      Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset
      real      MaxTime, MaxDepth
      real      Vds_BinsizeDI, Vds_BinsizeLI
      real      Flat3d_LI, Flat3d_DI
      real      Landmark_Gradient, Landmark_Vmax, Landmark_Vzero
      real      Landmark_Dzero, Landmark_watvel
      real      Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth
      real      Flat3d1_LI, Flat3d1_DI
      real      West_Lat, West_Long
      real      UnitSc, UnitSc_override, UnitSc_out
      real      velst
      real      veled, Kelman_vref
      real      tdq_datum
 
      character FormatIn*20, FormatOut*20, vin*1, vout*1, sin*1, sout*1
      character iwd*6, Xsd_SegName*20, Xsd_mnemonic*6, Vds_OacLine*7
      character Earth_ntop*255, Earth_nbottom*255, Earth_topWrd*6
      character Earth_botWrd*6
      character West_Line*7, West_Reshot*1, West_Units*1
      character ukooa_LatLong*26, EOF*3
      character Geco_LineName*10, Geco_comment*14
      character tdq_c_units*6
 
      logical   Force, resample, linear, EndFlag, eta, rnmo
      logical	agip_flg, Charisma_vel_flag
      logical	Omni_3D, time_depth_curve, depth_time_curve
 
      character OACLin*8, LinNam*8, JobNum*8, DatTyp*1, PrcNam*10,
     :          APIWNo*12, PrcDat*8
      integer*2 CDPFLD
      integer WatVel
      integer LinInd, DphInd, RfSrEl, WDepDP, FlDtEl, PrRcNm, PrTrNm
      integer SoPtNm
      character SoPtAl

c dynamic memory variables
 
      integer itr
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, abort
      integer itemVelocity, itemSpace, EarthSpace
      integer errcod, alloc_size
 
      real    Record, Velocity, Unit, Work, Earth_TopSurface
      real    Earth_BottomSurface
 
      pointer (memadr_Record, Record(200000))
      pointer (memadr_Velocity, Velocity(200000))
      pointer (memadr_Unit, Unit(200000))
      pointer (memadr_work, Work(200000))
      pointer (memadr_Earth_TopSurface, Earth_TopSurface(200000) )
      pointer (memadr_Earth_BottomSurface, Earth_BottomSurface(200000) )
      pointer (memadr_itr, itr(200000) )
 
c initialize variables
 
      data name/'VOMIT'/
      data lbytes/0/
      data nbytes/0/
      data lbyout/0/
      data luout/6/
      data abort/0/
      data Xsd_SegName/' '/
      data nsampo/0/
      data resample/.false./
      data Earth_DI/0/
      data Earth_LI/1/
      data EOF/'EOF'/
      data Geco_LineName/'          '/
      data Geco_comment/'              '/
      data UnitSc/0.001/
      data eta/.false./
      data rnmo/.false./
      data agip_flg/.false./
 
c check for help request from user
 
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c open printout files
 
#include <f77/open.h>
 
 
c get command line parameters
 
      call cmdln ( ntap, otap, FormatIn, FormatOut, vin, vout,
     :     sin, sout, linear, eta, rnmo, Charisma_vel_flag,
c xsd specifics
     :     Xsd_SmpUnitOverride, Xsd_VelOffsetOverride,
     :     Xsd_VelUnitOverride, Xsd_mnemonic,
c usp specifics
     :     SlopeAdjustmentFactor, iwd, Force, depth_time_curve,
     :     nsamp, nrec, ntrc, nsi, Usp_SmpIntOverride, UnitSc_out,
     :     MBSdx, MBSdy, MBSdz, UnitSc_override, time_depth_curve,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c landmark specifics
     :     Landmark_nhor, Landmark_Vmax, Landmark_watvel,
c vds specifics
     :     Vds_OacLine,
c flat3d1 specifics, kelman specifics
     :     Flat3d1_Nelem, Kelman_vref,
c earth vision specifics
     :     Earth_ntop, Earth_nbottom, Earth_topWrd, Earth_botWrd,
c western3d specifics
     :     West_Line, West_Reshot, West_Units,
c geco specifics
     :     Geco_LineName, Geco_comment,
c Omnivel specifics
     :     Omni_3D,
     :     tdq_c_units, tdq_datum, verbos,velst,veled)

c UnitSc is set to 0.001 by default.  This logic will make sure that happens
c if the user has not had other ideas on the command line

      if ( UnitSc_out .eq. 0.0 ) UnitSc_out = UnitSc
 
c echo parameter choices to print file
 
      call verbal ( ntap, otap, FormatIn, FormatOut, vin, vout,
     :     sin, sout, linear, eta, rnmo,
     :     time_depth_curve, depth_time_curve,
c xsd specifics
     :     Xsd_SmpUnitOverride, Xsd_VelOffsetOverride,
     :     Xsd_VelUnitOverride, Xsd_mnemonic,
c usp specifics
     :     SlopeAdjustmentFactor, iwd, Force,
     :     Usp_SmpIntOverride, UnitSc_override, UnitSc_out,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c landmark specifics
     :     Landmark_nhor, Landmark_Vmax,
c vds specifics
     :     Vds_OacLine,
c flat3d1 specifics, kelman specifics
     :     Flat3d1_Nelem, Kelman_vref,
c earth vision specifics
     :     Earth_ntop, Earth_nbottom, Earth_topWrd, Earth_botWrd,
c western3d specifics
     :     West_Line, West_Reshot, West_Units,
c geco specifics
     :     Geco_LineName, Geco_comment,
c tdq specifics
     :     tdq_c_units, tdq_datum, verbos)
 
c verify that conversion requested is possible with this routine. Not
c all formats are compatible and no attempt has been made to give
c univeral conversion capability.  This routine is user driven.  If a
c conversion is requested, it is implimented as requested.  Check
c in this subroutine for compatibility issues.
 
      call ConversionCheck( FormatIn, FormatOut )
 
c conditionally open input and output velocity function sets
 
      call OpenVelData ( luin, ntap, FormatIn, luout, otap, FormatOut )
 
      if ( FormatIn .eq. 'ev3d' ) then
 
c open Earth Vision 2D horizon constraint files
 
         call alloclun(Earth_lutop)
         length = lenth(Earth_ntop)
         open ( unit = Earth_lutop, file = Earth_ntop(1:length),
     :        status = 'old', iostat = ierr )
         if(ierr .ne. 0) then
            write(LERR,*)' '
            write(LERR,*)'VOMIT: Could not open Earth Vision 2D '
            write(LERR,*)'       top horizon constraint file: ',
     :           Earth_ntop(1:length)
            write(LERR,*)'       Check existance and rerun '
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: Could not open Earth Vision 2D '
            write(LER,*)'       top horizon constraint file: ',
     :           Earth_ntop(1:length)
            write(LER,*)'       Check existance and rerun '
            write(LER,*)'FATAL'
            stop
         endif
 
         call alloclun(Earth_lubottom)
         length = lenth(Earth_nbottom)
         open ( unit = Earth_lubottom, file = Earth_nbottom(1:length),
     :        status = 'old', iostat = ierr )
         if(ierr .ne. 0) then
            write(LERR,*)' '
            write(LERR,*)'VOMIT: Could not open Earth Vision 2D '
            write(LERR,*)'       bottom horizon constraint file: ',
     :           Earth_nbottom(1:length)
            write(LERR,*)'       Check existance and rerun '
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: Could not open Earth Vision 2D '
            write(LER,*)'       bottom  horizon constraint file: ',
     :           Earth_nbottom(1:length)
            write(LER,*)'       Check existance and rerun '
            write(LER,*)'FATAL'
            stop
         endif
 
      endif
 
c allocate USP works space for line header if necessary

      if ( ( FormatIn .eq. 'usp' .or. FormatOut .eq. 'usp') .or.
     :     ( FormatIn .eq. 'charisma' ) ) then
	alloc_size = SZLNHD * SZSMPD
	errcod = 0
	call galloc( memadr_itr, alloc_size, errcod, abort)
	if (errcod .ne. 0) then
          write(LERR,*)' '
          write(LERR,*)'ERROR - Unable to allocate workspace:'
          write(LERR,*) alloc_size,'  bytes'
          write(LERR,*)'FATAL ........... '
          write(LER,*)' '
          write(LER,*)name,': ERROR - Unable to allocate workspace:'
          write(LER,*) alloc_size,'  bytes'
          write(LER,*)'FATAL ........... '
	  stop 100
	endif
      endif

c allocate required memory
 
      call Memory(luin, ntap, FormatIn, NumFcns, NumEntries,
c xsd specifics
     :     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit,
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
c vxos specifics
     :     Vxos_NumPicks,
c landmark specifics
     :     Landmark_nhor, Usp_SmpIntOverride,
c usp specifics
     :     itr, lbytes, nsamp, nsi, ntrc, nrec, UnitSc_override,
     :     iwd, ifmt_iwd, l_iwd, ln_iwd, obytes, nsampo, UnitSc,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c vds3d specifics
     :     Vds_StaticsMode, Vds_JobConstantStatic, Vds_MutePercent,
     :     Vds_WaterBottom, Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI,
     :     Vds_LIinc, Vds_DIinc, Vds_InterpRadius, Vds_PrtWgtFlag,
     :     Vds_BinsizeLI, Vds_BinsizeDI, Vds_NumScheme, Vds_DipAzimFlag,
     :     Vds_OacLine, Vds_VelPrtInc,
c flat3d1 specifics
     :     Flat3d1_Nelem,
c earth vision specifics
     :     Earth_NumX, Earth_NumY, Earth_NumZ,
c omnivel specifics
     :     OACLin,LinNam,JobNum,DatTyp,PrcNam,APIWNo,CDPFLD,PrcDat,
     :     WatVel,
     :     verbos )
 
      if ( ( FormatIn .eq. FormatOut .and. FormatIn .eq. 'usp' ) .or.
     :     ( FormatIn .eq. 'charisma' .and. FormatOut .eq. 'usp' ) ) 
     :     then
         if ( nsampo .gt. nsamp ) then
            itemVelocity = 2 * nsampo
         else
            itemVelocity = 2 * nsamp
         endif
         itemSpace = 3 * itemVelocity
 
      elseif ( FormatIn .eq. 'ev3d' ) then
 
c since we have to read in the whole grid of data I will put it into
c the work array and extract the function to output for each location
c using the Velocity and  Unit arrays.  There will be a copy of the
c X locations, Y locations, depths and velocities meaning I will need
c 4 time the total number of functions worth of space to store them all.
c EarthSpace is for the constraint horizon surfaces
 
         itemVelocity = 2 * Earth_NumZ
         itemSpace = (4+(Earth_NumX * Earth_NumY * Earth_NumZ))*4
         EarthSpace = Earth_NumX * Earth_NumY + Earth_NumX
 
c allocate space for constraint surfaces here as no other option requires
c this space at present
 
         call galloc ( memadr_Earth_TopSurface, EarthSpace * SZSMPD,
     :        errcd5, abort )
         call galloc ( memadr_Earth_BottomSurface, EarthSpace * SZSMPD,
     :        errcd6, abort )
 
         if ( errcd5 .ne. 0
     :        .or. errcd6 .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2 * EarthSpace * SZSMPD,'  bytes'
            write(LERR,*)'FATAL ........... '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) 2 * EarthSpace * SZSMPD,'  bytes'
            write(LER,*)'FATAL ........... '
            stop
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2 * EarthSpace * SZSMPD,'  bytes'
            write(LERR,*)' '
         endif
 
c initialize memory
 
         call vclr( Earth_TopSurface, 1, EarthSpace )
         call vclr( Earth_BottomSurface, 1, EarthSpace )
 
      elseif (FormatIn .eq. 'omnivel') then
         if ( nsampo .gt. nsamp ) then
            itemVelocity = 2 * nsampo
         else
            itemVelocity = 2 * nsamp
         endif
         itemSpace = 3 * itemVelocity
      else
         itemVelocity = 2 * NumEntries
         itemSpace = 3 * itemVelocity
      endif
 
c allocate memory common to all options
 
      call galloc( memadr_Record, itemVelocity* SZSMPD , errcd1,
     :     abort )
      call galloc( memadr_Velocity, itemVelocity* SZSMPD , errcd2,
     :     abort )
      call galloc( memadr_Unit, itemVelocity* SZSMPD , errcd3,
     :     abort )
      call galloc( memadr_work, itemSpace* SZSMPD , errcd4, abort )
 
      if ( errcd1 .ne. 0
     :     .or. errcd2 .ne. 0
     :     .or. errcd3 .ne. 0
     :     .or. errcd4 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 3 * itemVelocity* SZSMPD,'  bytes'
         write(LERR,*) itemSpace* SZSMPD,'  bytes'
         write(LERR,*)'FATAL ........... '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 3 * itemVelocity* SZSMPD,'  bytes'
         write(LER,*) itemSpace* SZSMPD,'  bytes'
         write(LER,*)'FATAL ........... '
         stop
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3 * itemVelocity* SZSMPD,'  bytes'
         write(LERR,*) itemSpace* SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
 
c initialize memory
 
      call vclr( Record, 1, itemVelocity )
      call vclr( Velocity, 1, itemVelocity  )
      call vclr( Unit, 1, itemVelocity  )
      call vclr( Work, 1,  itemSpace )
 
c setup pointers to output trace headers that may or may not be used
c overhead to set these up is minimal and logic to determine under which
c conditions they are used is onerous
 
      if ( FormatIn .eq. 'landmark' ) N = Landmark_nhor
 
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum,
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :     TRACEHEADER )
      call savelu ( 'LinInd', ifmt_LinInd, l_LinInd, ln_LinInd,
     :     TRACEHEADER )
      call savelu ( 'DphInd', ifmt_DphInd, l_DphInd, ln_DphInd,
     :     TRACEHEADER )
      call savelu ( 'CDPBCX', ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     :     TRACEHEADER )
      call savelu ( 'CDPBCY', ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     :     TRACEHEADER )
      call savelu ( iwd, ifmt_iwd, l_iwd, ln_iwd, TRACEHEADER )
 
      if ( FormatIn .eq. 'ev3d' ) then
 
         call savelu ( Earth_topWrd, ifmt_topWrd, l_topWrd, ln_topWrd,
     :     TRACEHEADER )
         call savelu ( Earth_botWrd, ifmt_botWrd, l_botWrd, ln_botWrd,
     :     TRACEHEADER )
         N = Earth_NumZ
 
c read in top and bottom constraint surfaces
 
         call ReadEv2d ( Earth_lutop, EarthSpace, Earth_NumX,
     :        Earth_NumY,Earth_TopSurface )
         call ReadEv2d ( Earth_lubottom, EarthSpace, Earth_NumX,
     :        Earth_NumY, Earth_BottomSurface )
 
c read ev3d grid of data into memory
 
         call ReadEv3d( luin, itemSpace, Earth_NumX, Earth_NumY,
     :        Earth_NumZ, Work )
 
      endif

      if ( FormatIn .eq. 'omnivel' ) then
          call savelu ('SoPtNm', ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :          TRACEHEADER )
          call savelu ('SoPtAl', ifmt_SoPtAl, l_SoPtAl, ln_SoPtAl,
     :          TRACEHEADER )
          call savelu ('LinInd', ifmt_LinInd, l_LinInd, ln_LinInd,
     :          TRACEHEADER )
          call savelu ('DphInd', ifmt_DphInd, l_DphInd, ln_DphInd,
     :          TRACEHEADER )
          call savelu ('RfSrEl', ifmt_RfSrEl, l_RfSrEl, ln_RfSrEl,
     :          TRACEHEADER )
          call savelu ('WDepDP', ifmt_WDepDP, l_WDepDP, ln_WDepDP,
     :          TRACEHEADER )
          call savelu ('FlDtEl', ifmt_FlDtEl, l_FlDtEl, ln_FlDtEl,
     :          TRACEHEADER )
          call savelu ('SrPrLt', ifmt_SrPrLt, l_SrPrLt, ln_SrPrLt,
     :          TRACEHEADER )
          call savelu ('SrPrLn', ifmt_SrPrLn, l_SrPrLn, ln_SrPrLn,
     :          TRACEHEADER )
          call savelu ('PrRcNm', ifmt_PrRcNm, l_PrRcNm, ln_PrRcNm,
     :          TRACEHEADER )
          call savelu ('PrTrNm', ifmt_PrTrNm, l_PrTrNm, ln_PrTrNm,
     :          TRACEHEADER )
          call savelu ('SrPtXC', ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :          TRACEHEADER )
          call savelu ('SrPtYC', ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     :          TRACEHEADER )
      endif


c handle velocity type for geco format if output format is geco.  I
c still have to verify that this is the scheme GECO uses.  I am not
c sure at all what the type number signifies and have just made this
c up to fill in the slot until I have talked with someone who has
c definite knowledge of GECO's format description....Garossino

      if ( FormatOut .eq. 'geco' ) then
         if ( vout .eq. 'I' ) Geco_type = 2
         if ( vout .eq. 'R' ) Geco_type = 0
         if ( vout .eq. 'A' ) Geco_type = 1
      endif
 
      if ( FormatIn .eq. 'charisma' ) then
         call savelu ( 'TVPT01', ifmt_TVPT(1), l_TVPT(1), ln_TVPT(1),
     :     TRACEHEADER )
         call savelu ( 'TVPV01', ifmt_TVPV(1), l_TVPV(1), ln_TVPV(1),
     :     TRACEHEADER )
         call savelu ( 'TVPT02', ifmt_TVPT(2), l_TVPT(2), ln_TVPT(2),
     :     TRACEHEADER )
         call savelu ( 'TVPV02', ifmt_TVPV(2), l_TVPV(2), ln_TVPV(2),
     :     TRACEHEADER )
         call savelu ( 'TVPT03', ifmt_TVPT(3), l_TVPT(3), ln_TVPT(3),
     :     TRACEHEADER )
         call savelu ( 'TVPV03', ifmt_TVPV(3), l_TVPV(3), ln_TVPV(3),
     :     TRACEHEADER )
         call savelu ( 'TVPT04', ifmt_TVPT(4), l_TVPT(4), ln_TVPT(4),
     :     TRACEHEADER )
         call savelu ( 'TVPV04', ifmt_TVPV(4), l_TVPV(4), ln_TVPV(4),
     :     TRACEHEADER )
         call savelu ( 'TVPT05', ifmt_TVPT(5), l_TVPT(5), ln_TVPT(5),
     :     TRACEHEADER )
         call savelu ( 'TVPV05', ifmt_TVPV(5), l_TVPV(5), ln_TVPV(5),
     :     TRACEHEADER )
         call savelu ( 'TVPT06', ifmt_TVPT(6), l_TVPT(6), ln_TVPT(6),
     :     TRACEHEADER )
         call savelu ( 'TVPV06', ifmt_TVPV(6), l_TVPV(6), ln_TVPV(6),
     :     TRACEHEADER )
         call savelu ( 'TVPT07', ifmt_TVPT(7), l_TVPT(7), ln_TVPT(7),
     :     TRACEHEADER )
         call savelu ( 'TVPV07', ifmt_TVPV(7), l_TVPV(7), ln_TVPV(7),
     :     TRACEHEADER )
         call savelu ( 'TVPT08', ifmt_TVPT(8), l_TVPT(8), ln_TVPT(8),
     :     TRACEHEADER )
         call savelu ( 'TVPV08', ifmt_TVPV(8), l_TVPV(8), ln_TVPV(8),
     :     TRACEHEADER )
         call savelu ( 'TVPT09', ifmt_TVPT(9), l_TVPT(9), ln_TVPT(9),
     :     TRACEHEADER )
         call savelu ( 'TVPV09', ifmt_TVPV(9), l_TVPV(9), ln_TVPV(9),
     :     TRACEHEADER )
         call savelu ( 'TVPT10', ifmt_TVPT(10), l_TVPT(10), ln_TVPT(10),
     :     TRACEHEADER )
         call savelu ( 'TVPV10', ifmt_TVPV(10), l_TVPV(10), ln_TVPV(10),
     :     TRACEHEADER )
         call savelu ( 'TVPT11', ifmt_TVPT(11), l_TVPT(11), ln_TVPT(11),
     :     TRACEHEADER )
         call savelu ( 'TVPV11', ifmt_TVPV(11), l_TVPV(11), ln_TVPV(11),
     :     TRACEHEADER )
         call savelu ( 'TVPT12', ifmt_TVPT(12), l_TVPT(12), ln_TVPT(12),
     :     TRACEHEADER )
         call savelu ( 'TVPV12', ifmt_TVPV(12), l_TVPV(12), ln_TVPV(12),
     :     TRACEHEADER )
         call savelu ( 'TVPT13', ifmt_TVPT(13), l_TVPT(13), ln_TVPT(13),
     :     TRACEHEADER )
         call savelu ( 'TVPV13', ifmt_TVPV(13), l_TVPV(13), ln_TVPV(13),
     :     TRACEHEADER )
         call savelu ( 'TVPT14', ifmt_TVPT(14), l_TVPT(14), ln_TVPT(14),
     :     TRACEHEADER )
         call savelu ( 'TVPV14', ifmt_TVPV(14), l_TVPV(14), ln_TVPV(14),
     :     TRACEHEADER )
         call savelu ( 'TVPT15', ifmt_TVPT(15), l_TVPT(15), ln_TVPT(15),
     :     TRACEHEADER )
         call savelu ( 'TVPV15', ifmt_TVPV(15), l_TVPV(15), ln_TVPV(15),
     :     TRACEHEADER )
         call savelu ( 'TVPT16', ifmt_TVPT(16), l_TVPT(16), ln_TVPT(16),
     :     TRACEHEADER )
         call savelu ( 'TVPV16', ifmt_TVPV(16), l_TVPV(16), ln_TVPV(16),
     :     TRACEHEADER )
         call savelu ( 'TVPT17', ifmt_TVPT(17), l_TVPT(17), ln_TVPT(17),
     :     TRACEHEADER )
         call savelu ( 'TVPV17', ifmt_TVPV(17), l_TVPV(17), ln_TVPV(17),
     :     TRACEHEADER )
         call savelu ( 'TVPT18', ifmt_TVPT(18), l_TVPT(18), ln_TVPT(18),
     :     TRACEHEADER )
         call savelu ( 'TVPV18', ifmt_TVPV(18), l_TVPV(18), ln_TVPV(18),
     :     TRACEHEADER )
         call savelu ( 'TVPT19', ifmt_TVPT(19), l_TVPT(19), ln_TVPT(19),
     :     TRACEHEADER )
         call savelu ( 'TVPV19', ifmt_TVPV(19), l_TVPV(19), ln_TVPV(19),
     :     TRACEHEADER )
         call savelu ( 'TVPT20', ifmt_TVPT(20), l_TVPT(20), ln_TVPT(20),
     :     TRACEHEADER )
         call savelu ( 'TVPV20', ifmt_TVPV(20), l_TVPV(20), ln_TVPV(20),
     :     TRACEHEADER )
         call savelu ( 'TVPT21', ifmt_TVPT(21), l_TVPT(21), ln_TVPT(21),
     :     TRACEHEADER )
         call savelu ( 'TVPV21', ifmt_TVPV(21), l_TVPV(21), ln_TVPV(21),
     :     TRACEHEADER )
      endif

c write the output header for the chosen format if required
 
      call WriteHeader(luout, FormatIn, FormatOut, NumEntries,
     :     sin, sout, luin, time_depth_curve, depth_time_curve,
c xsd specifics
     :     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit, NumFcns,
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
     :     Xsd_VelOffsetOverride, Xsd_VelUnitOverride,
     :     Xsd_SmpUnitOverride,
c usp specifics
     :     itr, lbytes, name, nsamp, nsi, ntrc, nrec, nsampo,
     :     Usp_SmpIntOverride, MBSdx, MBSdy, MBSdz, UnitSc_out,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c vds3d specifics
     :     Vds_StaticsMode, Vds_JobConstantStatic, Vds_MutePercent,
     :     Vds_WaterBottom, Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI,
     :     Vds_LIinc, Vds_DIinc, Vds_InterpRadius, Vds_PrtWgtFlag,
     :     Vds_BinsizeLI, Vds_BinsizeDI, Vds_NumScheme, Vds_DipAzimFlag,
     :     Vds_OacLine, Vds_VelPrtInc,
c ev3d specifics
     :     Earth_NumX, Earth_NumY, Earth_NumZ,
c omnivel specifics
     :     OACLin,LinNam,JobNum,DatTyp,PrcNam,APIWNo,CDPFLD,PrcDat,
     :     WatVel,vout,
c tdq specifics
     :     tdq_datum, tdq_c_units, verbos )

c allocate USP works space for trace if necessary

      if ( ( FormatIn .eq. 'usp' ) .or.
     :     (FormatOut .eq. 'usp' ) .or.
     :     ( FormatIn .eq. 'charisma' ) ) then
	alloc_size = nsamp * SZSMPD + SZTRHD
	errcod = 0
	call grealloc( memadr_itr, alloc_size, errcod, abort)
	if (errcod .ne. 0) then
          write(LERR,*)' '
          write(LERR,*)' Unable to allocate workspace:'
          write(LERR,*) alloc_size,'  bytes'
          write(LERR,*)'FATAL'
          write(LER,*)' '
          write(LER,*)name,': ERROR - Unable to allocate workspace:'
          write(LER,*) alloc_size,'  bytes'
          write(LER,*)'FATAL ........... '
	  stop 101
	endif
      endif
 
c process velocities

      DO JJ = 1, NumFcns

       resample = .false.

c GET THE NEXT velocity function
 
       if (FormatIn .eq. 'omnivel') then

	 call ReadOmnivel(luin, Velocity, Unit,Record, SoPtNm, SoPtAl,
     :        DphInd, LinInd, RfSrEl, WDepDP, FlDtEl,
     :        SoPtLt, SoPtLn, PrRcNm, PrTrNm, SrPtXC, SrPtYC ,
     :        sin, sout, vin, vout, NumEntries, N,JJ)
         call vclr(itr,1,SZLNHD)
         Record(1) = JJ

       else

         call ReadNextFcn( luin, JJ, FormatIn, NumEntries, Record,
c vxos specifics
c 3D specifics
c xsd specifics
c charisma specifics
c landmark specifics
     : Velocity, Unit, N, Vxos_NumPicks, EndFlag, LI, DI, Xsd_SegNum, 
     : Xsd_SegColor, Xsd_SegName, Xsd_mnemonic, ifmt_TVPT, l_TVPT, 
     : Landmark_Gradient, Landmark_Vzero, ln_TVPT, ifmt_TVPV, l_TVPV, 
     : Landmark_Dzero, Landmark_Vmax, Landmark_nhor, ln_TVPV, UnitSc,
     : Landmark_watvel, Charisma_vel_flag,
c usp specifics
c vds3d specifics
c flat3d specifics
     : iwd, ifmt_iwd, l_iwd, ln_iwd, itr, ifmt_DphInd, l_DphInd, 
     : ln_DphInd, ifmt_LinInd, l_LinInd, ln_LinInd, Usp_SmpIntOverride,
     : ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, ifmt_CDPBCY, l_CDPBCY, 
     : ln_CDPBCY, Vds_OacLine, Flat3d_LI, Flat3d_DI, Geco_type, 
c flat3d1 specifics
c geco specifics
     :  Flat3d1_LI, Flat3d1_DI, Flat3d1_Nelem,
c ev3d specifics
     : Earth_NumX, Earth_NumY, Earth_NumZ, Work, itemSpace, Earth_DI, 
     : Earth_LI, Earth_X, Earth_Y, topWrd, botWrd, EarthSpace, 
     : Earth_TopSurface, Earth_BottomSurface,
c western3d specifics
c disco3d specifics
     : West_Line, West_Shot, West_Reshot, West_Long, West_Lat, 
     : West_Units, disco_LI, disco_DI, Geco_comment, Geco_LineName,
c ukooa specifics
     : ukooa_LI, ukooa_DI, ukooa_LatLong, ukooa_X, ukooa_Y, verbos,
c agip specifics,  digicon specifics
     : agip_flg )

       endif

c Policeman - watch for premature end of input function

         if ( EndFlag ) then
            if ( FormatIn .eq. 'landmark' .or. 
     :           FormatIn .eq. 'landmark2' .or. 
     :           FormatIn .eq. 'agip' ) then
               if ( JJ .ne. NumFcns ) then
                  write(LERR,*)' '
                  write(LERR,*)' premature end of input functions '
                  write(LER,*)' '
                  write(LER,*)'VOMIT: '
                  write(LER,*)' premature end of input functions '
                  write(LER,*)' '
                  goto 999
               endif
            endif
         endif
 
C HANDLE SAMPLE UNITS() CONVERSION TO SECONDS, METERS  OR FEET
 
c convert time units to seconds
 
         if ( sin .eq. 'T' ) then
       	     call Units( FormatIn, sin, Unit, N,
     :        Xsd_SmpUnit, Xsd_SmpOffset, Xsd_SmpUnitOverride, nsi, 
     :        UnitSc )
	 endif
 
c convert usp input depth units to meters or feet as required
 
         if ( sin .eq. 'D' .and. FormatIn .eq. 'usp' ) then
            do i = 1, N
               Unit(i) = Unit(i) * float(nsi) * UnitSc
            enddo
         endif
 
c convert velocity units to ft/sec or m/sec for xsd or vxos pickfile input
 
         if ( FormatIn .eq. 'xsd' .or. FormatIn .eq. 'vxos')
     :        call MakeVelocity ( Velocity, N, Xsd_VelUnit,
     :        Xsd_VelOffset, Xsd_VelUnitOverride,
     :        Xsd_VelOffsetOverride )
 
c determine maximum time for usp output trace
 
         if (FormatOut .eq. 'usp' .and. FormatIn .ne. 'usp' )then

            MaxTime = float( nsi * nsamp ) * UnitSc

         elseif(FormatOut .eq. 'usp' .and. FormatIn .eq. 'usp' .and.
     :           sin .eq. 'D' .and. sout .eq. 'T' ) then
 
c require a MaxTime in seconds for the last sample of the input dataset
 
            if ( Usp_SmpIntOverride .ne. 0 ) then

               MaxTime = float ( nsamp ) * Usp_SmpIntOverride * UnitSc

            else

               MaxTime = float( nsi * nsamp ) * UnitSc

            endif
         endif
 
c decimate input velocity function
 
         if ( (FormatIn .eq. 'usp' .and. FormatOut .ne. 'usp') .and.
     :        ( vin .eq. 'R' .or. vin .eq. 'A') ) then
            call sloper ( Unit, Velocity, N, SlopeAdjustmentFactor )
            call vclr(Velocity(N+1),1,nsamp-N)
            call vclr(Unit(N+1),1,nsamp-N)
         elseif ( (FormatIn .eq. 'usp' .and. FormatOut .ne. 'usp') .and.
     :           vin .eq. 'I' ) then
            call UniqueIntVel ( Unit, Velocity, N, verbos )
            call vclr(Velocity(N+1),1,nsamp-N)
            call vclr(Unit(N+1),1,nsamp-N)
         endif
 
c for kelman format need to move functions from the input floating datum to 
c a start time of zero seconds.

         if ( FormatIn .eq. 'kelman' ) 
     :        call Kelman_redatum ( Unit, Velocity, N, Kelman_vref, 
     :        SlopeAdjustmentFactor, Force, JJ, Maxtime, nsi, verbos )

c do any required Velocity conversions
 
         call bd_vel(Unit, Velocity, N, sin, vin, sout, vout, MaxTime,
     :       MaxDepth, nsi, FormatIn, SlopeAdjustmentFactor, Force,
     :        eta, rnmo, verbos, itemVelocity, JJ )
 
c build output usp velocity trace from another input format
 
         if ( FormatOut .eq. 'usp' .and. FormatIn .ne. 'usp' ) then
 
            if ( Usp_SmpIntOverride .ne. 0 ) then
               Usp_SmpInt = Usp_SmpIntOverride
            else
               Usp_SmpInt = nsi
            endif
 
	   if (FormatIn .eq. 'charisma') then

c here we must use nsampo instead of nsamp when building the trace as 
c the only thing we can trust in the input dataset is that the headers
c were loaded with the function desired.  The actual number of output
c samples is a command line parameter

              call UspTrace ( Unit, Velocity, nsampo, Usp_SmpInt, N, 
     :             itr, sout, vout, linear, UnitSc )

	   else

              call UspTrace ( Unit, Velocity, nsamp, Usp_SmpInt, N, 
     :           itr, sout, vout, linear, UnitSc )
           endif
 
c calculate the number of output bytes required to write this trace
 
           obytes = SZTRHD + SZSMPD * nsamp
 
c fill out trace header entries as required
 
              if ( FormatIn .eq. 'landmark' .or.
     :             FormatIn .eq. 'landmark2' .or.
     :             FormatIn .eq. 'vds3d' .or.
     :             FormatIn .eq. 'vip' .or.
     :             FormatIn .eq. 'flat3d' .or.
     :             FormatIn .eq. 'promax3d' .or.
     :             FormatIn .eq. 'disco3d' .or.
     :             FormatIn .eq. 'disco3d1' .or.
     :             FormatIn .eq. 'disco3d3' .or.
     :             FormatIn .eq. 'geco' .or.
     :             FormatIn .eq. 'flat3d1' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                DI, TRACEHEADER)
              elseif ( FormatIn .eq. 'disco3dxy' .or.
     :                FormatIn .eq. 'ukooa' .or.
     :                FormatIn .eq. 'ukooa1' .or.
     :                FormatIn .eq. 'ukooa2' .or.
     :                FormatIn .eq. 'western3d1' .or.
     :                FormatIn .eq. 'kelman' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     :                ukooa_X, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     :                ukooa_Y, TRACEHEADER)
              elseif ( FormatIn .eq. 'ev3d' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                Earth_LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                Earth_DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                Earth_LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                Earth_DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     :                Earth_X, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     :                Earth_Y, TRACEHEADER)
                 call savew2 ( itr, ifmt_topWrd, l_topWrd, ln_topWrd,
     :                topWrd, TRACEHEADER)
                 call savew2 ( itr, ifmt_botWrd, l_botWrd, ln_botWrd,
     :                botWrd, TRACEHEADER)
              elseif ( FormatIn .eq. 'western3d' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                West_Shot, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                1, TRACEHEADER)
cmam agip stuff -and- digicon stuff
              elseif ( FormatIn .eq. 'agip' .or.
     :                 FormatIn .eq. 'digicon' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                JJ, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                1, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                ukooa_LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                ukooa_DI, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX,
     :                ukooa_X, TRACEHEADER)
                 call savew2 ( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     :                ukooa_Y, TRACEHEADER)
cmam essov2 stuff
              elseif ( FormatIn .eq. 'essov2' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                JJ, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                1, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                ukooa_LI, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                ukooa_DI, TRACEHEADER)

cmam omnivel stuff
              elseif ( FormatIn .eq. 'omnivel' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                JJ, TRACEHEADER)
                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                1, TRACEHEADER)
                 call savew2 ( itr, ifmt_LinInd, l_LinInd, ln_LinInd,
     :                LinInd, TRACEHEADER)
                 call savew2 ( itr, ifmt_DphInd, l_DphInd, ln_DphInd,
     :                DphInd, TRACEHEADER)
                 call savew2 ( itr, ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :                SrPtXC, TRACEHEADER)
                 call savew2 ( itr, ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC,
     :                SrPtYC, TRACEHEADER)
                 call savew2 ( itr, ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm,
     :                SoPtNm, TRACEHEADER)
                 call savew2 ( itr, ifmt_RfSrEl, l_RfSrEl, ln_RfSrEl,
     :                RfSrEl, TRACEHEADER)
                 call savew2 ( itr, ifmt_WDepDP, l_WDepDP, ln_WDepDP,
     :                WDepDP, TRACEHEADER)
                 call savew2 ( itr, ifmt_FlDtEl, l_FlDtEl, ln_FlDtEl,
     :                FlDtEl, TRACEHEADER)
                 call savew2 ( itr, ifmt_SrPrLt, l_SrPrLt, ln_SrPrLt,
     :                SoPtLt, TRACEHEADER)
                 call savew2 ( itr, ifmt_SrPrLn, l_SrPrLn, ln_SrPrLn,
     :                SoPtLn, TRACEHEADER)
                 call savew2 ( itr, ifmt_PrRcNm, l_PrRcNm, ln_PrRcNm,
     :                PrRcNm, TRACEHEADER)
                 call savew2 ( itr, ifmt_PrTrNm, l_PrTrNm, ln_PrTrNm,
     :                PrTrNm, TRACEHEADER)

              elseif ( FormatIn .eq. 'promax' ) then

                 call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :                1, TRACEHEADER)

              elseif ( iwd .ne. 'RecNum' ) then
                 call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                JJ, TRACEHEADER)
              endif

cmam       endif
 
        endif
 
c if time depth curve output requested then will have time, vavg at this
c point and need to compute depth for sample output

        if ( time_depth_curve ) then
           Call TimeDepthCurve(Unit, Velocity, N)
        endif

c if depth time curve output requested then will have depth, vavg at this
c point and need to compute 2-way time for sample output

        if ( depth_time_curve ) then
           Call DepthTimeCurve(Unit, Velocity, N)
        endif

c CONVERT TIME UNITS TO MILLISECONDS / METERS OR FEET PRIOR TO WRITING OUT FUNCTION
 
        if ( sout .eq. 'T' ) then
           call UnitsBack( FormatOut, sin, Unit, N,
     :          Xsd_SmpUnit, Xsd_SmpOffset, Xsd_SmpUnitOverride,
     :          nsi, Usp_SmpIntOverride, UnitSc_out )
        endif
 
c determine if resampling of velocity function for usp output is required
 
        if ( FormatOut .eq. 'usp' .and. .not. resample ) then
 
           if( FormatIn .ne. 'charisma' ) then
c if a sample interval override was requested and has not been done yet
 
              if ( Usp_SmpIntOverride .ne. 0 .and.
     :             Usp_SmpIntOverride .ne. nsi ) resample = .true.
 
c if the output requested has a different number of samples that the current
c function in memory [i.e. dt2max or t2dmax may have been used]
 
              if ( nsampo .ne. nsamp  .and. nsampo .ne. 0 )
     :             resample = .true.
 
c if the sample interval for any reason [d2t conversion for instance] is not
c equal to the output sample interval requested
 
              if ( nint (Unit(2) - Unit(1)) .ne. nsi ) resample = .true.
 
              if ( nsampo .eq. 0 ) nsampo = N
cmam omnivel
              if (FormatIn .eq. 'omnivel') resample = .true.

c if the format in and out are both usp, and due to -force N has come back
c from bd_vel less than the original nsamp then we need to resample

              if ( FormatIn .eq. 'usp' .and. 
     :             FormatOut .eq. 'usp' .and. 
     :             force .and. 
     :             N .lt. nsampo ) resample = .true.

           endif

        elseif ( FormatIn .eq. 'usp' .and. .not. resample ) then

           if( FormatIn .ne. 'charisma') then
c if a sample interval override was requested and has not been done yet
 
              if ( Usp_SmpIntOverride .ne. 0 .and.
     :             Usp_SmpIntOverride .ne. nsi ) resample = .true.
              if ( nsampo .eq. 0 .and. Usp_SmpIntOverride .ne. 0) then
                 nsampo = nint ( float ( nsi ) / 
     :                float (Usp_SmpIntOverride) * float (nsamp)) 
              elseif ( nsampo .eq. 0 ) then
                 nsampo = N
              endif
           endif
 
        endif
 
        if ( resample .and. (FormatIn .ne. 'charisma') ) then
 
c build a USP trace from a non-sparse input velocity function set
c such as occurs when changing sample interval in USP format.  In this
c case may use cubic spline interpolation.  Note: this routine sometimes
c throws up IEEE errors if the input dataset is not well conditioned
c but so far has not actually made errors in interpolation.  The IEEE
c errors are inexact and underflow.  I ran purify and prism looking for
c the offensive condition to no avail so have left it for now...Paul
 
           call UspResampTrace ( Unit, Velocity, N, nsi,
     :          Usp_SmpIntOverride, nsampo, NumEntries, linear )

c if we have resampled an input usp function and are outputting say something
c like flat3d format then we need to reassign the number of output function
c elements to be nsampo

           if ( FormatOut .ne. 'usp' ) N = nsampo
        endif
 
c OUTPUT VELOCITY FUNCTION data one function at a time
 
        call WriteFcn(luout, JJ, FormatIn, FormatOut, Record,
     :       Velocity, Unit, N,
c xsd specifics
     :       Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit,
     :       Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
     :       Xsd_SegNum, Xsd_SegName, Xsd_SegColor,
c vxos specifics
     :       Vxos_NumPicks,
c 3D specifics
     :       LI, DI,
c landmark specifics
     :       Landmark_Gradient, Landmark_Dzero, Landmark_Vzero,
c usp specifics
     :       nsi, ntrc, nrec, obytes, nsampo, itr,
     :       iwd, ifmt_iwd, ln_iwd, l_iwd,
c vds3d specifics
c geco specifics
     :       Vds_OacLine, Geco_type, Geco_LineName, Geco_comment,
c flat3d specifics
     :       Flat3d_LI, Flat3d_DI,
c flat3d1 specifics,
     :       Flat3d1_LI, Flat3d1_DI,
c western3d specifics
c disco3d specifics
     :       West_Line, West_Shot, West_Reshot, West_Long, West_Lat,
     :       West_Units, disco_LI, disco_DI,  
c ukooa specifics
     : ukooa_LI, ukooa_DI, ukooa_LatLong, ukooa_X, ukooa_Y, verbos,
     : velst, veled,nsamp)
 
      ENDDO
 
c normal termination
 
      if ( FormatIn .eq. 'usp' .or. 
     :     FormatIn .eq. 'charisma' ) then
         call lbclos(luin)
      else
         close(luin)
      endif
 
      if ( FormatOut .eq. 'usp' ) then
         call lbclos(luout)
      else
         if ( FormatOut .eq. 'ukooa' .or. 
     :        FormatOut .eq. 'ukooa1' ) write(luout,'(a3)')EOF
         close(luout)
      endif
 
      write(LERR,*)'  '
      write(LERR,*)' VOMIT: Normal Termination'
      write(LERR,*)' processed ', NumFcns, ' functions'
      write(LER,*)' vomit: Normal Termination'
 
      stop

 999  continue

cmam  if ( FormatIn .eq. 'usp' ) then
      if ( FormatIn .eq. 'usp' .or. FormatIn .eq. 'charisma' ) then
         call lbclos(luin)
      else
         close(luin)
      endif
 
      if ( FormatOut .eq. 'usp' ) then
         call lbclos(luout)
      else
         if ( FormatOut .eq. 'ukooa' .or. 
     :        FormatOut .eq. 'ukooa1' ) write(luout,'(a3)')EOF
         close(luout)
      endif
 
      write(LERR,*)'  '
      write(LERR,*)' VOMIT: ABNORMAL Termination'
      write(LERR,*)' processed ', JJ, ' of ',NumFcns, ' functions'
      write(LER,*)'  '
      write(LER,*)' vomit: ABNORMAL Termination'
      stop
      end
