C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rshift(u,nt,ntnew,sv,omega,expphi)     

      implicit none

c declare variables passed from calling routine

      integer nt, ntnew
      real sv
      real u(ntnew)
      real omega(ntnew/2+1)
      complex   expphi(ntnew/2+1)                   

c declare local variables

      integer mute, k, iomega, nzero, m

      real arg

C_______________________________________________________________________
C     calculate phase shift operator in frequency domain.
c     this will vectorize on the cray.
C_______________________________________________________________________
      do 50000 iomega=1,ntnew/2+1
       arg=-omega(iomega)*sv
       expphi(iomega)=cmplx(cos(arg),sin(arg))
50000 continue
C_______________________________________________________________________
C     DETERMINE FRONT END MUTE
C_______________________________________________________________________
      MUTE=0
      do 10000 k=1,nt   
       if(u(k) .eq. 0.) then 
          mute=mute+1
       else
          go to 10001
       endif
10000 continue
10001 continue
C_______________________________________________________________________
C     pad end of trace with zeros.           
C_______________________________________________________________________
      NZERO=NTNEW-NT
      CALL VCLR(U(NT+1),1,NZERO)
C_______________________________________________________________________
C     TAKE FORWARD FFT FROM T TO OMEGA
C     A REAL TO COMPLEX FFT (IN PLACE)
C_______________________________________________________________________
      CALL RFFT(U(1),NTNEW,1)
      CALL RFFTSC(U(1),NTNEW,3,1)
C_______________________________________________________________________
C     perform phase shift in the frequency domain.
C_______________________________________________________________________
      call cvmul(u,2,expphi,2,u,2,ntnew/2+1,1)
C_______________________________________________________________________
C     TAKE INVERSE FFT FROM OMEGA TO T
C     A COMPLEX TO REAL FFT (IN PLACE)
C_______________________________________________________________________
      CALL RFFTSC(U(1),NTNEW,-3,0)
      call rfft(u(1),ntnew,-1)
C_______________________________________________________________________
C     apply front end mute to kill positive wrap around.
C_______________________________________________________________________
      m=nint(sv)
      do 30000 k=1,mute+m
       u(k)=0.       
30000 continue
C_______________________________________________________________________
C     apply back end mute to kill negative wrap around.
c     only need to apply to OUTPUT end of trace at nt, vs ntnew.
C_______________________________________________________________________
      do 40000 k=nt+1+m,nt 
       u(k)=0.  
40000 continue
c
      RETURN
      END
