C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
      program VSAMP  
c_______________________________________________________________________
c     irregularly resample a smooth velocity model using a fixed number of 	c     depth points per minimum wavelength criteon.
c_______________________________________________________________________
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <save_defs.h>

c
      parameter (maxs=1,maxt=1)                      
      parameter (nfine=20)
      parameter (pi=3.1415926)
      dimension s(maxs),t(maxt)       
      pointer   (pntrs,s)   
      pointer   (pntrt,t)   
C
      integer   argis
      integer   ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer   ifmt_SrPtEl, l_SrPtEl, ln_SrPtEl
C
      integer   vheader(6000)
      logical   query,verbose
      logical   tdatum
C
      character*80 file_vgrid,file_vsamp,file_irreg,file_twt
      data         luirreg/81/
      data         undefined/1.e+32/
      character*5  name

#include <save_defs.h>
C
      data name     /'VSAMP'/
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      query=(argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help()
         call exitfu(0)
      endif
c____________________________________________________________________
c     open printer image output files
c____________________________________________________________________
      call openpr(lupprt,lerr,name,jerr)
c__________________________________________________________________
c     look up hardware specific trace header indices.
c     these indices will be the same for all output records.
c__________________________________________________________________
      call savelu('SrPtXC',ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl, l_SrPtEl, ln_SrPtEl,TRACEHEADER)
      call savelu('FlDtEl',ifmt_FlDtEl, l_FlDtEl, ln_FlDtEl,TRACEHEADER)
c____________________________________________________________________
c     read input/output file names
c____________________________________________________________________
      call argstr('-N',file_vgrid,' ',' ')
      call argstr('-O',file_vsamp,' ',' ')
      call argstr('-Z',file_irreg,' ',' ')
      call argstr('-T',file_twt,' ',' ')
c____________________________________________________________________
C     open seismic worktape format files.
c     warning, unit numbers will be changed by getln or lbopen!
c____________________________________________________________________
      ierror=0
c
      call getln(luvgrid,file_vgrid,'r',0)
      call getln(luvsamp,file_vsamp,'w',1)
c
      if(file_irreg .ne. ' ') then
         open(luirreg,file=file_irreg,status='UNKNOWN',
     1         form='FORMATTED',iostat=ioerror)
         if(ioerror .ne. 0) then
            write(lerr,*)'enter file name after -Z option'
            write(lerr,*) 'error opening file ',file_irreg
            ierror=ierror+1
         endif
      else
         ierror=ierror+1
      endif
      if(file_twt .ne. ' ') then
         call lbopen(lutwt,file_twt,'w')
      else
         write(lerr,*)'must supply twt file name!'
         write(lerr,*)'enter file name after -T option'
         ierror=ierror+1
      endif

      if(ierror .gt. 0) then
         write(lerr,*) 'program vsamp aborted due to command line'//
     1                   'errors'
         close(lerr)
         call exitfu(666)
      endif
      write(lerr,'(a10,a10,5x,a)') 'file','unit','file name'
      write(lerr,'(a10,i10,5x,a)') 'file_vgrid',luvgrid,file_vgrid,
     1                             'file_vsamp',luvsamp,file_vsamp,
     2                             'file_twt',lutwt,file_twt,
     3                             'file_irreg',luirreg,file_irreg 
c____________________________________________________________________
C     read in velocity work tape header
c____________________________________________________________________
      lenvh=0
      call rtape(luvgrid,vheader,lenvh)
      call hlhprt(vheader,lenvh,name,4,lerr)
c____________________________________________________________________
c     pull input data parameters off the line header.
c____________________________________________________________________
      status=saver(vheader,'NumTrc',nveltr,LINEHEADER)
      status=saver(vheader,'NumRec',nvelrec,LINEHEADER)
      status=saver(vheader,'NumSmp',nz_tape,LINEHEADER)
      status=saver(vheader,'TmMsSl',idx_1000,LINEHEADER)
      status=saver(vheader,'TmSlIn',idz_1000,LINEHEADER)
      nzgrid=nz_tape-1
      if(nveltr .eq. 1) then
         nxgrid=nvelrec
      else
         nxgrid=nveltr
      endif
      dxheader=.001*idx_1000       
      dzheader=.001*idz_1000       
c____________________________________________________________________
C     read in command line arguements   
c____________________________________________________________________
      call argr4('-dxv',dxgrid,0.0,0.0)   
      if (dxgrid .eq. 0.) dxgrid = dxheader
c
      call argr4('-dzv',dzgrid,0.0,0.0)  
      if (dzgrid .eq. 0.) dzgrid = dzheader
c
      call argr4('-fref',fref,50.,50.)               
c
      call argr4('-xvo',xvo,999999.,999999.)
      if (xvo .eq. 999999.) xvo = undefined
c
      call argr4('-zvo',zvo,999999.,999999.)
      if (zvo .eq. 999999.) zvo = undefined
c
      call argr4('-zmax',zmax,-999999.,-999999.)
      if (zmax .eq. -999999.) zmax = dzgrid*nzgrid-zvo
c
      call argr4('-dzeql',dzeql,0.,0.)             
      if(dzeql .lt. 0.) dzeql=dzgrid
c
      call argi4('-maxzeta',maxzeta,2000,2000)     
c
      call argr4('-vsr',vsr,4.,4.)           
c
      tdatum=(argis('-FlDtEl') .gt. 0)
      verbose=(argis('-V') .gt. 0)
c______________________________________________________________________
c     check command line data.
c______________________________________________________________________
      ierror=0
      if(dxgrid .le. 0. .or. dxgrid .gt. 1000.)  then
         write(lerr,*) 'error in input parameters detected in vsamp!'
         write(lerr,*) 'velocity worktape increment (-dxv) = ',dxgrid 
         write(lerr,*) 'dxheader = ',dxheader
         write(lerr,*) 'Dx1000   = ',idx_1000
         write(lerr,*)
         ierror=ierror+1
      endif
      if(dzgrid .le. 0. .or. dzgrid .gt. 1000.)  then
         write(lerr,*) 'error in input parameters detected in vsamp!'
         write(lerr,*) 'velocity worktape increment (-dzv) = ',dzgrid
         write(lerr,*) 'dzheader = ',dzheader
         write(lerr,*) 'Dz1000   = ',idz_1000
         write(lerr,*)
         ierror=ierror+1
      endif
c
      if(xvo .eq. undefined) then
         write(lerr,*) 'error in input parameters detected in vsamp!'
         write(lerr,*) 'velocity worktape x origin  (-xvo) undefined'
         write(lerr,*)
         ierror=ierror+1
      endif
c
      if(zvo .eq. undefined) then
         write(lerr,*) 'error in input parameters detected in vsamp!'
         write(lerr,*) 'velocity worktape z origin  (-zvo) undefined'
         write(lerr,*)
         ierror=ierror+1
      endif
c
      if(ierror .gt. 0) then
         write(lerr,*)'program aborted in vsamp due to input errrors'
         write(lerr,*)
         call exitfu(7666)
      endif
c
      zmin=-zvo
      xmin=xvo
      nzgrid_extend=(zmax-zmin)/dzgrid+2
c
      write(lerr,*) 'nxgrid        = ',nxgrid
      write(lerr,*) 'nz_tape       = ',nz_tape
      write(lerr,*) 'nzgrid        = ',nzgrid
      write(lerr,*) 'nzgrid_extend = ',nzgrid_extend
      write(lerr,*) 'dxgrid        = ',dxgrid
      write(lerr,*) 'dzgrid        = ',dzgrid
      write(lerr,*) 'dzheader      = ',dzheader
      write(lerr,*) 'dzeql         = ',dzeql   
      write(lerr,*) 'xvo           = ',xvo    
      write(lerr,*) 'zvo           = ',zvo    
      write(lerr,*) 'zmin          = ',zmin  
      write(lerr,*) 'zmax          = ',zmax  
      write(lerr,*) 'dzeql         = ',dzeql 
      write(lerr,*) 'fref          = ',fref  
      write(lerr,*) 'vsr           = ',vsr
      write(lerr,*) 'maxzeta       = ',maxzeta
C_______________________________________________________________________
C     calculate memory requirements to read in the velocity model and
c     calculate the irregular grid zeta.
C_______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'STORAGE MAP OF MAJOR ARRAYS'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'VARIABLE NAME','BEGIN','END','LENGTH'
C
      l_free=1
      call mapmem('vgrid',l_vgrid ,l_free,
     1               (ITRWRD+nzgrid+1)*nxgrid,lerr)
      call mapmem('twtgrid',l_twtgrid ,l_free,
     1               (nzgrid_extend+1)*nxgrid,lerr)
      call mapmem('zeta',l_zeta,l_free,maxzeta+1,lerr)
      call mapmem('savg',l_savg,l_free,nzgrid+1,lerr)
      call mapmem('sfine',l_sfine,l_free,nfine*(nzgrid+1),lerr)
      call mapmem('zdatum',l_zdatum,l_free,nxgrid,lerr)
      call mapmem('twtdatum',l_twtdatum,l_free,nxgrid,lerr)
C_______________________________________________________________________
C     allocate dynamic memory for s vector.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate initial dynamic memory'
     1                    //' for VSAMP: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate initial dynamic memory'
     1                    //' for VSAMP: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'s vector. ierrcd = ',ierrcd
         write(lerr,*)'program VSAMP aborted'
         close(lerr)
         call exitfu(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
C_______________________________________________________________________
c     read in the velocity worktape.
C_______________________________________________________________________
      call rdv(s(l_vgrid),s(l_zdatum),
     1         tdatum,zmin,nxgrid,nzgrid,ITRWRD,
     3         ifmt_FlDtEl,l_FlDtEl,ln_FlDtEl,
     4         luvgrid,TRACEHEADER,verbose,lerr)
C_______________________________________________________________________
c     resample equally spaced input depth increment to an optimally
c     sampled output depth increment (vsr points/wavelength).
C_______________________________________________________________________
      pclambda=1./vsr 
      call getzeta(s(l_vgrid),s(l_zeta),s(l_sfine),s(l_savg),
     1             ITRWRD,dzgrid,dzeql,zmin,zmax,
     2             nxgrid,nzgrid,nz,fref,
     3             pclambda,maxzeta,nfine,lerr)
C_______________________________________________________________________
C     calculate memory requirements needed to resample the velocity
c     field at the irregular grid spacing.
C_______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'STORAGE MAP OF MAJOR ARRAYS'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'VARIABLE NAME','BEGIN','END','LENGTH'
C
      l_free=1
      call mapmem('v',l_v,l_free,(ITRWRD+nz+1)*nxgrid,lerr)
      call mapmem('twt',l_twt,l_free,(ITRWRD+nz+2)*nxgrid,lerr)
      call mapmem('zetamid',l_zetamid,l_free,nz+2,lerr)
C_______________________________________________________________________
C     allocate dynamic memory for s vector.
C_______________________________________________________________________
      lent=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lent
      write(lerr,'(//,a)') 'allocate additional dynamic memory'
     1                    //' for VSAMP: '
      write(lerr,*) 1.e-6*lent,' Mwords'
      write(lerr,*) 1.e-6*lent*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate additional dynamic memory'
     1                    //' for VSAMP: '
      write(ler,*) 1.e-6*lent,' Mwords'
      write(ler,*) 1.e-6*lent*szsmpd,' Mbytes'
      call galloc(pntrt,lent*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'t vector. ierrcd = ',ierrcd
         write(lerr,*)'program VSAMP aborted'
         close(lerr)
         call exitfu(102)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lent
C_______________________________________________________________________
c     write out velocity worktape control information.
c     close the file so that so that it can be read as soon as the
c     velocity worktape line header is read in the following program
c     sammig.
C_______________________________________________________________________
      write(luirreg,'(5a12)',err=94000)'xvo','dxgrid','dzeql','fref',
     1                         'vsr'
      write(luirreg,'(f12.3,5f12.6)') xvo,dxgrid,dzeql,fref,vsr
      write(luirreg,'(3a12)')'zmin','zmax','nz'
      write(luirreg,'(2f12.3,i12)') zmin,zmax,nz
      write(luirreg,'(2a12)') 'izeta','zeta(izeta)'
      write(luirreg,'(i12,f12.3)') (izeta,s(l_zeta+izeta),izeta=0,nz)
      close(luirreg)
C_______________________________________________________________________
c     write out the resampled velocity worktape line header.
c     for irregularly spaced output, dzeql will be zero!
C_______________________________________________________________________
      nsi=-1
      idx_1000=nint(1000.*dxgrid)               
      idz_1000=nint(1000.*dzgrid)                
c
      call savew(vheader,'NumSmp',nz+1,LINEHEADER)
      call savew(vheader,'SmpInt',nsi,LINEHEADER)
      call savew(vheader,'TmMsSl',idx_1000,LINEHEADER)
      call savew(vheader,'TmSlIn',idz_1000,LINEHEADER)
      call savew(vheader,'MxRSEL',nint(zvo),LINEHEADER)
      call savew(vheader,'MnTrOf',nint(xvo),LINEHEADER)
c
      call savhlh(vheader,lenvh,lbyout)
      call wrtape(luvsamp,vheader,lbyout)
      call wrtape(lutwt,vheader,lbyout)
C_______________________________________________________________________
c     update the trace headers.                           
C_______________________________________________________________________
      call hdupdat(s(l_vgrid),nzgrid,ITRWRD,
     1             nxgrid,xmin,zmin,dxgrid, 
     2             ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,
     3             ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,
     4             TRACEHEADER)
C_______________________________________________________________________
c     resample the velocity data set.
C_______________________________________________________________________
      call vsampsub(s(l_vgrid),s(l_twtgrid),t(l_v),t(l_twt),s(l_zeta),
     1              t(l_zetamid),s(l_zdatum),s(l_twtdatum),
     2              ITRWRD,dxgrid,dzgrid,zmin,
     3              nxgrid,nzgrid,nzgrid_extend,nz,lerr)
C_______________________________________________________________________
c     write out the irregularly sampled velocity and two way travel time
c     data.
C_______________________________________________________________________
      nbytes_out=(ITRWRD+nz+1)*szsmpd
      call wrsis(t(l_v),nz,1,nxgrid,ITRWRD,luvsamp,nbytes_out)
      call lbclos(luvsamp)
      call wrsis(t(l_twt),nz+1,1,nxgrid,ITRWRD,lutwt,nbytes_out)
      call lbclos(lutwt)
      write(lerr,*) 'Normal completion of routine VSAMP'
      write(ler,*) 'Normal completion of routine VSAMP'

      close(lerr)
      call exitfu(0)
c
94000 write(lerr,*) 'error in writing to file ',file_irreg
      write(lerr,*) 'probable cause: no write permission!'
      close(lerr)
      call exitfu(1666)
      end
      subroutine  help
#include <f77/iounit.h>
      write(LER,*)' '
      write(LER,*)'Command Line Arguments for VSAMP: '
      write(LER,*)'Velocity sampling smoothing program for mbs'   
      write(LER,*)' '
      write(LER,*)'Input....................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N [file_timeshots] (stdin)     :'
      write(ler,*)'                Input velocity model'
      write(LER,*)'-O [file_vsamp] (stdout)      :'
      write(ler,*)'                Output velocity model'  
     1                 //' sampled at irregular grid'
      write(LER,*)'-Z [file_irreg] (no default)  :'
      write(ler,*)'   Output irregular depth sampling information'
      write(LER,*)'-T [file_twt] (no default)  :'
      write(ler,*)'   Output two way travel time sampled at'
     1               //' irregular grid'
c
      write(LER,*)'-dxv[dxgrid] -- velocity tape x increment'//
     1                           ' (.001*TmMsSl)'
      write(LER,*)'-dzv[dzgrid] -- velocity tape z increment'//
     1                           ' (.001*TmMsIn)'
      write(LER,*)'-xvo[xvo]    -- x position of first trace on '//
     1                           ' velocity work tape'
      write(ler,*)'                (x = shot point * dsta) '//
     1                           ' (no default)'
      write(LER,*)'-zvo[zvo]    -- z position of first sample on '//         
     1                           ' velocity work tape'
      write(ler,*)'                (z positive up) (no default)'
      write(LER,*)'-zmax[zmax]  -- maximum migration depth' //
     1                             '  (positive down. no default)'
      write(LER,*)'-fref[fref]  -- reference frequency (50.)'
      write(LER,*)'-vsr[vsr]    -- vertical sampling rate at fref'
     1                               //' (4.)'
      write(LER,*)'-maxzeta[maxzeta] -- maximum allowable'//
     1                       ' output depth points (2000) '
      write(LER,*)'-dzeql[dzeql]-- regular depth sampling flag (0.)'
      write(LER,*)'      dzeql=0 implies optimal irregular sampling'
      write(LER,*)'              using -fref and -vsr options'
      write(ler,*)'      dzeql<0 implies setting dzeql=dzv'
      write(LER,*)'-FlDtEl       - indicates two way travel time'
     1        //' output corrected to floating datum in trace header'
     2        //' word '
      write(LER,*)'-V           -- verbose output'               
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'        vsamp -N[] -O[] -Z[] -T[] -dxv[] -dzv[]'
      write(ler,*)'              -xvo[] -zvo[] -zmax[] -maxzeta[]'
      write(ler,*)'              -fref[] -vsr[] -dzeql[]'
      write(ler,*)'              -[FlDtEl,V]'               
      write(LER,*)' '

      return
      end
