C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vsmsub(slow,sbuf,wgt,ITRWRD,nzgrid,nzpad,
     1                  nxgrid,nxpad,dxgrid,dzgrid,rmax,hsm,dsm,
     2                  radial,rectangular,ztopo,zmin,topo,lerr,
     3                  wgtx,wgtz,notaper,first)
C
      real slow(-ITRWRD:nzgrid,0:nxgrid)                             
      real sbuf(-nzpad:nzgrid+nzpad,-nxpad:nxgrid+nxpad)   
      real wgt(-nzpad:nzpad,-nxpad:nxpad)
      real wgtx(-nxpad:nxpad)
      real wgtz(-nzpad:nzpad)
      real ztopo(0:nxgrid)
      logical  topo,first
      logical  radial,rectangular,notaper
c
c_____________________________________________________________________
c     convert from velocity to slowness.
c   
c     in this way, the predicted travel times from the rough velocity
c     traveling across a grid of spacing dx
c
c     T = sum (dx/v )
c          j       j
c
c     is close to that through the smooth velocity grid
c
c     T = (N*dx) * (1/N)*sum(1/v )
c                         j     j
c______________________________________________________________________
      do 8000 ix=0,nxgrid
       do 7000 iz=0,nzgrid
        sbuf(iz,ix)=slow(iz,ix)
7000   continue
8000  continue

      if(topo) then 
c_______________________________________________________________________
c        flag slowness above topography to be negative.   
c_______________________________________________________________________
         ibegin_no_topo=0
         do 32000 ix=0,nxgrid
          izend=nint((ztopo(ix)-zmin)/dzgrid)
          ibegin_no_topo=max(izend+nzpad,ibegin_no_topo)
          do 31500 iz=-nzpad,izend  
           sbuf(iz,ix)=0.              
31500     continue
32000    continue
      else
         ibegin_no_topo=-1
      endif
      write(lerr,*) 'ibegin_no_topo,nzgrid ',ibegin_no_topo,nzgrid
C_______________________________________________________________________
C     extend beginning and end of traces into buffer. this
c     will preserve edge velocities after low pass filtering.
C_______________________________________________________________________
      do 30000 ix=0,nxgrid              
       do 10000 iz=-nzpad,-1
        sbuf(iz,ix)=sbuf(0,ix)
10000  continue
c
       do 20000 iz=nzgrid+1,nzgrid+nzpad
        sbuf(iz,ix)=sbuf(nzgrid,ix)
20000  continue
c
30000 continue
c
      do 30001 iz=-nzpad,nzgrid+nzpad
c
       do 10001 ix=-nxpad,-1
        sbuf(iz,ix)=sbuf(iz,0)
10001  continue
c
       do 20001 ix=nxgrid+1,nxgrid+nxpad
        sbuf(iz,ix)=sbuf(iz,nxgrid)
20001  continue
c
30001  continue
C_______________________________________________________________________
C      calculate the weights             
C_______________________________________________________________________
      IF (first) THEN
       sumwgt=0.
       if(radial) then
          do 40000 ix=-nxpad,nxpad
           wgtx(ix)=0.
           x2=(ix*dxgrid)**2
           do 35000 iz=-nzpad,nzpad
            wgtz(iz)=0.
            z2=(iz*dzgrid)**2
            r=sqrt(x2+z2)
            if(r .gt. rmax) then
               wgt(iz,ix)=0.
            else
               if(notaper) then
                  wgt(iz,ix)=1.
               else
                  wgt(iz,ix)=1.-r/rmax 
               endif
            endif
            sumwgt=sumwgt+wgt(iz,ix)
35000      continue
40000     continue
       elseif(rectangular) then
          do 41000 ix=-nxpad,nxpad
           x=abs(ix*dxgrid)
           if(notaper) then
              wgtx(ix)=1.
           else
              wgtx(ix)=1.-x/hsm
           endif
           do 36000 iz=-nzpad,nzpad
            z=abs(iz*dzgrid)
            if(notaper) then
               wgtz(iz)=1.
            else
               wgtz(iz)=1.-z/hsm
            endif
            wgt(iz,ix)=wgtx(ix)*wgtz(iz)
            sumwgt=sumwgt+wgt(iz,ix)
36000      continue
41000     continue
       ENDIF
C_______________________________________________________________________
C     normalize                        
C_______________________________________________________________________
      scale=1./sumwgt
      write(lerr,'(//,2a5,5a12)') 'ix','iz','x','z','wgtx(ix)',
     1                         'wgtz(iz)','wgt(iz,ix)' 
      do 40001 ix=-nxpad,nxpad
       do 35001 iz=-nzpad,nzpad
        wgt(iz,ix)=wgt(iz,ix)*scale
        write(lerr,'(2i5,5f12.6)') ix,iz,ix*dxgrid,iz*dzgrid,
     1                             wgtx(ix),wgtz(iz),wgt(iz,ix) 
35001  continue
40001 continue
      endif
c_______________________________________________________________________
c     begin smoothing.
c_____________________________________________________________________
      do 90000 ix=0,nxgrid
c_______________________________________________________________________
c      case 1: there is a finite chance that one of the points included
c              in the slowness smoothing window lies aboive topography.
c_______________________________________________________________________
       do 80000 iz=0,ibegin_no_topo
        if(sbuf(iz,ix) .le. 0.) then
c_______________________________________________________________________
c          grid point lies above topography. leave the slowness unchanged.
c_______________________________________________________________________
        else
c_______________________________________________________________________
c          grid point lies below topography. calculate a smoothed 
c          slowness
c______________________________________________________________________
           slow(iz,ix)=0.
           do 70001 jx=-nxpad,nxpad
            do 60001 jz=-nzpad,nzpad
             if(sbuf(iz+jz,ix+jx) .gt. 0.) then
c______________________________________________________________________
c               point lies within the slowness smoothing window.
c______________________________________________________________________
                slow(iz,ix)=slow(iz,ix)+wgt(jz,jx)*sbuf(iz+jz,ix+jx)
             else
                slow(iz,ix)=slow(iz,ix)+wgt(jz,jx)*sbuf(iz,ix)
             endif
60001       continue
70001      continue
        endif
80000  continue
c_______________________________________________________________________
c       case 2: there is 0 chance that one of the points included
c               in the slowness smoothing window lies aboive topography.
c               this loop (without testing) is faster.
c______________________________________________________________________
       do 80002 iz=ibegin_no_topo+1,nzgrid
           slow(iz,ix)=0.
           do 70002 jx=-nxpad,nxpad
            do 60002 jz=-nzpad,nzpad
             slow(iz,ix)=slow(iz,ix)+wgt(jz,jx)*sbuf(iz+jz,ix+jx)
60002       continue
70002      continue
80002  continue
c_______________________________________________________________________
c      store results as velocity, instead of slowness
c_______________________________________________________________________
       do 82000 iz=0,nzgrid
        slow(iz,ix)=1./slow(iz,ix)
82000  continue
90000 continue
c
      return
      end
