C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function dwmtmm (luprt , q     , nmix  , lmix  , ntwind,
     *                      ntlive, b     , livetr, itotal)
c
c     implement the double window trimmed mean algorithm for finding
c     the representative value of ntwind points in vector b.
c     parameter q determines a +q and -q range around the median
c     value of the elements in an interior window of b.  all members
c     of the entire vector of b lying within that range are averaged
c     to determine the double window modified trimmed mean (dwmtmm)
c     representation of those ntwind points of b.  the remaining
c     points are ignored.
c
      logical livetr(ntwind)
      real b(ntwind), modtmm, median, medpq, medmq
      data iprint/0/
c
c     determine the number of data values to be excluded from
c     the sum based on nmix, the maximum possible value for
c     ntlive.  print this information on the first entry to the
c     function.
c
      if (iprint .eq. 0) then
         iprint = 1
         itotal = 0
         write (luprt,1200) nmix, lmix, q
 1200    format(/' DWMTMM:  nmix = ',i2,3x,'lmix = ',i2,3x,
     *          'q = ',1pe11.4/)
      endif
c
c     set dwmtmm to zero if ntwind < 1 or ntwind > nmix
c
      if ((ntwind .lt. 1) .or. (ntwind .gt. nmix) .or.
     *    (ntlive .lt. 1)) then
         dwmtmm = 0.0
         return
      endif
c
c     set dwmtmm to b(ntwind) if ntwind = 1
c
      if (ntwind .eq. 1) then
         dwmtmm = b(ntwind)
         itotal = itotal + 1
         return
      endif
c
c     if ntwind (from 2 to nmix in value) is < or = lmix, use
c     the modified trimmed mean (modtmm)
c
      if (ntwind .le. lmix) then
         itote = 0
         dwmtmm = modtmm (luprt, q, nmix, ntwind, ntlive, b, livetr,
     *                    itote)
         itotal = itotal + itote
         return
      endif
c
c     determine constants defining the interior window boundaries
c
      nmld2 = (ntwind - lmix)/2
      nml2p1 = nmld2 + 1
      nml2pl = nmld2 + lmix
c
c     within the interior window of b, move any elements
c     of b corresponding to dead traces to the end of the
c     interior window in b.  it is assumed that at least one
c     trace is live.
c
      if (ntlive .lt. ntwind) then
         nlivei = 0
         do 120 k = nml2p1, nml2pl
            if (livetr(k)) then
               nlivei = nlivei + 1
             else
               do 100 l = nml2pl, k+1, -1
                  if (livetr(l)) then
                     b(k) = b(l)
                     b(l) = 0.0
                     livetr(k) = .true.
                     livetr(l) = .false.
                     nlivei = nlivei + 1
                     go to 120
                  endif
  100          continue
            endif
  120    continue
       else
         nlivei = lmix
      endif
c
c     sort the nlivei elements of the interior window of b
c
      call sortqk (nlivei, b(nml2p1))
c
c     find center index of the interior window of b
c     (if nlivei is odd, nid2p1 is center;
c     if nlivei is even, nid2 and nid2p1 are the center 2 values)
c
      nid2 = nmld2 + nlivei/2
      nid2p1 = nid2 + 1
c
c     find the median value of the data in b
c
      if (mod(nlivei,2) .eq. 1) then
         median = b(nid2p1)
       else
         median = 0.5*(b(nid2) + b(nid2p1))
      endif
c
c     calculate the median - q and median + q interval
c
      medmq = median - q
      medpq = median + q
c
c     sum the elements corresponding to live traces over
c     the entire window of b which have values in the
c     (median-q, median+q) interval.  at least one value
c     (median) is guaranteed to be in this interval, even
c     if q = 0.0.  this median value is from data within
c     the interior window of b.  itotal counts the total
c     number of elements summed since the function was
c     first called.  it is used to judge the value assigned
c     to parameter q.
c
      kcount = 0
      dwmtmm = 0.0
      do 200 k = 1, ntwind
         if (livetr(k)) then
            bk = b(k)
            if ((bk .ge. medmq) .and. (bk .le. medpq)) then
               kcount = kcount + 1
               dwmtmm = dwmtmm + bk
            endif
         endif
  200 continue
      if (kcount .gt. 0) then
         dwmtmm = dwmtmm/float(kcount)
       else
         dwmtmm = median
         kcount = 1
      endif
      itotal = itotal + kcount
      return
      end
