C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function dwrtmm (luprt , alphap, nmix  , lmix  , ntwind,
     *                      ntlive, b     , livetr, itotal)
c
c     implement the double window range trimmed mean algorithm for
c     finding the representative value of ntwind points in vector b.
c     parameter alphap determines a percentage of the range (minimum
c     from median to max or min).  the median of the elements
c     within the small window in b is determined.  all members of the
c     entire vector of b lying within that partial range are
c     averaged to determine the double window range trimmed mean
c     (dwrtmm) representation of those ntwind points of b.  the
c     remaining points are ignored.
c
      logical livetr(ntwind)
      real b(ntwind), rngtmm, median, medpq, medmq
      data iprint/0/
c
c     determine the number of data values to be excluded from
c     the sum based on nmix, the maximum possible value for
c     ntlive.  print this information on the first entry to the
c     function.  convert alpha from per cent to decimal.
c
      if (iprint .eq. 0) then
         iprint = 1
         itotal = 0
         alpha = alphap/100.
         write (luprt,1200) nmix, lmix, alphap
 1200    format(/' DWRTMM:  nmix = ',i2,3x,'lmix = ',i2,3x,
     *          'alpha = ',f7.2/)
      endif
c
c     set dwrtmm to zero if ntwind < 1 or ntwind > nmix
c
      if ((ntwind .lt. 1) .or. (ntwind .gt. nmix) .or.
     *    (ntlive .lt. 1)) then
         dwrtmm = 0.0
         return
      endif
c
c     set dwrtmm to b(ntwind) if ntwind = 1
c
c
      if (ntwind .eq. 1) then
         dwrtmm = b(ntwind)
         itotal = itotal + 1
         return
      endif
c
c     if ntwind (from 2 to nmix in value) is < or = lmix, use
c     the range trimmed mean (rngtmm)
c
      if (ntwind .le. lmix) then
         itote = 0
         dwrtmm = rngtmm (luprt , alphap, nmix, ntwind, ntlive, b,
     *                    livetr, itote)
         itotal = itotal + itote
         return
      endif
c
c     determine constants defining the interior window boundaries
c
      nmld2 = (ntwind - lmix)/2
      nml2p1 = nmld2 + 1
      nml2pl = nmld2 + lmix
c
c     within the interior window of b, move any elements
c     of b corresponding to dead traces to the end of the
c     interior window in b.  it is assumed that at least one
c     trace is live.
c
      if (ntlive .lt. ntwind) then
         nlivei = 0
         do 120 k = nml2p1, nml2pl
            if (livetr(k)) then
               nlivei = nlivei + 1
             else
               do 100 l = nml2pl, k+1, -1
                  if (livetr(l)) then
                     b(k) = b(l)
                     b(l) = 0.0
                     livetr(k) = .true.
                     livetr(l) = .false.
                     nlivei = nlivei + 1
                     go to 120
                  endif
  100          continue
            endif
  120    continue
       else
         nlivei = lmix
      endif
c
c     sort the nlivei elements of the interior window of b
c
      call sortqk (nlivei, b(nml2p1))
c
c     find center index of the interior window of b
c     (if nlivei is odd, nid2p1 is center;
c     if nlivei is even, nid2 and nid2p1 are the center 2 values)
c
      nid2 = nmld2 + nlivei/2
      nid2p1 = nid2 + 1
c
c     find the median value of the data in b
c
      if (mod(nlivei,2) .eq. 1) then
         median = b(nid2p1)
       else
         median = 0.5*(b(nid2) + b(nid2p1))
      endif
c
c     compute the range of b and q, which determines the
c     interval around the median from which elements of b
c     are averaged.  the range of b is taken from the elements
c     in the inner window.
c
      range = amin1(b(nmld2+nlivei)-median,median-b(nml2p1))
      q = alpha*range
c
c     calculate the median - q and median + q interval
c
      medmq = median - q
      medpq = median + q
c
c     sum the elements corresponding to live traces over
c     the entire window of b which have values in the
c     (median-q, median+q) interval.  at least one value
c     (median) is guaranteed to be in this interval, even
c     if q = 0.0.  this median value is from data within
c     the interior window of b.  itotal counts the total
c     number of elements summed since the function was
c     first called.  it is used to judge the value assigned
c     to parameter q.
c
      kcount = 0
      dwrtmm = 0.0
      do 200 k = 1, ntwind
         if (livetr(k)) then
            bk = b(k)
            if ((bk .ge. medmq) .and. (bk .le. medpq)) then
               kcount = kcount + 1
               dwrtmm = dwrtmm + bk
            endif
         endif
  200 continue
      if (kcount .gt. 0) then
         dwrtmm = dwrtmm/float(kcount)
       else
         dwrtmm = median
         kcount = 1
      endif
      itotal = itotal + kcount
      return
      end
