C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine velfin (Vn, Tn, Zn, numbn, ttmax, vintar, vscl,
     1                   lunfil, ave, int, rms, nsi, nsamp, itstep,
     2                   tdfn,owt)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    Vn(*), Tn(*), Zn(*), vintar(*)
      real    ht(2*SZLNHD), hv(2*SZLNHD)
      real    tmp(2*SZLNHD), vmp(2*SZLNHD)
      real    vrms(2*SZLNHD), vc(2*SZLNHD), tc(2*SZLNHD)
      real    vint(2*SZLNHD), vavg(2*SZLNHD)
      real    vp(2*SZLNHD)

      real        tabl1 (2*SZLNHD), tabl2(2*SZLNHD)
      real        zz(8*SZLNHD)
      integer     iz(2*SZLNHD)
      integer     ip(2*SZLNHD)
      character   junk * 80

      logical ave, int, rms, tdfn, EOF,owt

      write(LERR,*)' '
      write(LERR,*)'Velocity scale factor= ',vscl

      if (owt) then
         tscl = 2.0
      else
         tscl = 1.0
      endif

      IF (tdfn) THEN

         MaxTime = ( nsamp - 1 ) * nsi * vscl
         tfact   = 1. / vscl
         call ReadTDFN (lunfil, ht, hv, numbc, 1, MaxTime, tfact,
     1                  EOF)

      ELSE

         do  j = 1, SZLNHD
             read (lunfil, '(a80)', err = 300, end=400) junk
             call fsscnf (junk,'%f %f',ht (j), hv (j))
             if (hv(j) .le. 0.) go to 400
             numbc  = j
             ht (j) = tscl * ht (j)
         write(LERR,*)'j= ',j,ht (j),hv (j)
         enddo
         go to 400
300      continue
         numbc = j - 1
         if (j .le. 1) then
            write(LERR,*)'ERROR in vspstk:'
            write(LERR,*)'Error reading velocity file'
            write(LER ,*)'ERROR in vspstk:'
            write(LER ,*)'Error reading velocity file'
            stop 666
         endif
400      continue

      ENDIF

      if(ht(numbc).lt.ttmax)then
        ht(numbc+1)=ttmax
        hv(numbc+1)=hv(numbc)
        numbc=numbc+1
      endif

      if (rms) then

      call pkval (hv, numbc, 1, vp, ip, np)

      if (np .gt. 0) then
      write(LERR,*)' '
      write(LERR,*)'vspstk FATAL ERROR: found ',np,' velocity inversions
     1'
      write(LERR,*)'in your RMS function with minimum velocities at'
      write(LERR,*)(ip(i),i=1,np)
      write(LERR,*)'You must fix these inversion zones by editting the'
      write(LERR,*)'RMS velocity file. Stopping the program'
      write(LER ,*)' '
      write(LER ,*)'vspstk FATAL ERROR: found ',np,' velocity inversions
     1'
      write(LER ,*)'in your RMS function with minimum velocities at'
      write(LER ,*)(ip(i),i=1,np)
      write(LER ,*)'You must fix these inversion zones by editting the'
      write(LER ,*)'RMS velocity file. Stopping the program'
      stop
      endif

      endif


        write(LERR,*)' '
        write(LERR,*)'time    velocity'
        do  i = 1, numbc
            hv  (i) = vscl * hv (i)
            tmp (i) = ht (i)
            vmp (i) = hv (i)
            write(LERR,*)tmp(i), vmp(i)
        enddo
        write(LERR,*)' '
        write(LERR,*)'Input tstep= ',itstep

      if (itstep .eq. 0) then
         itstep = 250
         write(LERR,*)'Using default time step= ',itstep,'ms'
      endif

      IF (itstep .gt. 0) THEN

         write(LERR,*)'Number input velocities = ',numbc
         write(LERR,*)'Number output velocities= ',nt

         write(LERR,*)'Redefining layers at equal time steps= ',
     1                itstep,'ms'
         itstep = itstep / nsi
         nt = nint (float(nsamp) / float(itstep) + 1.0)
         do  i = 1, numbc
             tabl1 (i) = ht (i)
         enddo
         do  i = 1, nt
             tabl2 (i) = i * itstep 
             tmp   (i) = i * itstep
         enddo
         icinit = 1
         call fcuint (tabl1,hv,numbc,tabl2,vmp,nt,iz,zz,icinit)
         do  i = 1, nt
             write(LERR,*)'i= ',i,' tmp, vmp= ',tmp(i),vmp(i)
             ht (i) = tmp (i)
             hv (i) = vmp (i)
         enddo
         numbc = nt

      ELSE

         write(LERR,*)'Using layers defined by input velocity func'
         nt = numbc
         do  i = 1, nt
             write(LERR,*)'i= ',i,' ht, hv= ',ht(i),hv(i)
         enddo

      
      ENDIF


C     now have tc and vc interpolated in time to what ever level
c     user specified numbc is the number of samples in tc and vc
C
C     all records on the input will be moveout corrected with the
c     same input function
C
C
C     CONVERT INTERVAL TO RMS VEL.IF LTYPE =7

C     CONVERT INTERVAL TO RMS VEL.IF LTYPE =7
C

      IF ( int ) THEN
         write(LERR,*)'Converting interval to rms'
         vint(1) = hv(1)
         VRMS(1) = hv(1)
         vc  (1) = hv(1)
c............. better put ht(1) into tc(1) to be consistent!!
         tc(1) = ht(1)
c.............................................................
         DO 180 I=2,NUMBC
         vint(i)=hv(i)
         VRMS(I)=SQRT((hv(I) * hv(I) * (ht(I)-ht(I-1))+
     1    (VRMS(I-1) * VRMS(I-1) * ht(I-1)))/ht(I))
         VC(I)=VRMS(I)
         tc(i)=ht(i)
  180    CONTINUE
      write(LERR,*) ' interval vel converted to rms vel'
      write(LERR,7172)(vc(lll),vint(lll),vrms(lll),tc(lll),lll=1,numbc)
 7172    format (3x,4f10.1)
C
C     CONVERT AVERAGE TO RMS VEL. IF LTYPE =3
C
       ELSEIF ( ave ) THEN
            write(LERR,*)'Converting average to rms'
            VAVG1=hv(1)
            vavg(1)=vavg1
            vc(1) = hv(1)
            tc(1) = ht(1)
            DO 201 I=2,NUMBC
            X=hv(I)*ht(I)-VAVG1*ht(I-1)
            X=(X*X)/(ht(I)-ht(I-1))
            VAVG1=hv(I)
            vavg(i)=hv(i)
            tc(i)=ht(i)
            VC(I)=SQRT((X+VC(I-1)*VC(I-1)*TC(I-1))/TC(I))
  201       CONTINUE
         write(LERR,*) ' average vel converted to rms vel'
         write(LERR,7173)(vc(lll),vavg(lll),tc(lll),lll=1,numbc)
 7173       format (3x,3f10.1)
       ELSEIF ( rms ) then
            write(LERR,*)'rms input velocity'
            do  i = 1, numbc
                vc (i) = hv (i)
                tc (i) = ht (i)
            enddo
       ENDIF

         IF(TC(1) .NE. 0.) THEN
            write(LERR,*)' extending vel function back to time zero'
            J=NUMBC+1
            DO 209 I=1,NUMBC
            TC(J)=TC(J-1)
            VC(J)=VC(J-1)
            J=J-1
  209       CONTINUE
            TC(1)=0.
            NUMBC=NUMBC+1
         ENDIF
         IF(TC(NUMBC) .LT. ttmax) THEN
            NUMBC=NUMBC+1
            TC(NUMBC)=ttmax
            VC(NUMBC)=VC(NUMBC-1)
         ENDIF

      numbn=numbc
      do  i = 1, numbn
          vn (i) = vc (i)
          tn (i) = tc (i)
      enddo

c     do i = 1, numbn
c     write(0,*)'tc= ',tc(i),' vc= ',vc(i)
c     enddo

c
C     PRINT TIME VRMS VAVG DEPTH VINT
C
         ISKIP=0
         VAVG1=VC(1)
         VAVG2=VC(1)
         DEPTH=0
            WRITE(LERR,2028)
 2028       FORMAT(//,13X,
     1      'VELOCITY FUNCTION     ',
     2      //, 1X,'    TIME     VRMS     VAVG',
     3      '    DEPTH     VINT',/,'+', 4X,'____',5X,
     4      '____',5X,'____',4X,'_____',5X,'____')
         DO 2030 I=1,NUMBC
         IF (I.EQ.1) THEN
               WRITE(LERR,2023)TC(1),VC(1),VAVG2,DEPTH
 2023          FORMAT( 1X,4F9.0)
               vint(1)=vc(1)
               vavg(1)=vc(1)
         ELSE
            VVVV=VC(I)*VC(I)*TC(I)-VC(I-1)*VC(I-1)*TC(I-1)
            IF(VVVV.LT.0.) THEN
               ISKIP=1
               VINT(i)=0.
               DEPTH=0.
               VAVG2=VAVG1
               vavg(i)=0.
            ELSE
               VINT(i)=SQRT(VVVV/(TC(I)-TC(I-1)))
               if (i .eq. numbc) then
                   vint (numbc) = vint (numbc-1)
               endif
               IF(ISKIP.NE.1) THEN
                  VAVG1=VAVG2
                  VAVG2=(VINT(i)*(TC(I)-TC(I-1))+(VAVG1*TC(I-1)))/TC(I)
                  DEPTH=VAVG2*TC(I)/2000.
                  vavg(i)=vavg2
               ENDIF
            ENDIF
               WRITE(LERR,2026)TC(I),VC(I),VAVG2,DEPTH,VINT(i)
 2026          FORMAT( 1X,5F9.0)
         ENDIF
 2030    CONTINUE

         call vtz (Vn, Tn, Zn, numbn, vintar)
         if (numbn .gt. 2) then
            vintar (numbn) = vintar (numbn-1)
         endif

         write(LERR,*)' '
         do  i = 1, numbn
             write(LERR,*)'Layer= ',i,' Vn, Vi, Tn, Thickness= ',
     1                    Vn(i),vintar(i),Tn(i),Zn(i)
         enddo
         write(LERR,*)' '

      return
      end
