C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ganmo (X, v, e, offset, NS, sr, Y, work, R, nmo)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM ANISOTROPIC MOVEOUT CORRECTION.             *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           v = V (t) velocity array
*           e = e (t) eta array
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*          sr = SAMPLE INTERVAL IN SEC                                 *
*           Y = CORRECTED DATA                                         *
*                                                                      *
************************************************************************
#include <f77/iounit.h>

      real    X(ns), Y(ns), v(ns), e(ns)
      real    work (ns)
      logical R, nmo

      call vclr (work, 1, ns)

      call vmov (x, 1, work(2), 1, ns)

      work (ns+2) = 0
      r2 = offset * offset
      r4 = r2 * r2
      call vclr (work(ns+2), 1, 2)

      IF (.not.R) THEN

       DO  i = 1, ns

           t0    = (i-1) * sr
           t02   = t0 * t0
           eta   = e (i)
           eta2  = 2 * eta
           vnmo  = v (i)
           vnmo2 = vnmo * vnmo
           if (.not. nmo) then
              xnmo  = r2 / vnmo2
           else
              xnmo  = 0.0
           endif

           shfts = t02 + xnmo - eta2 * r4 /
     1              ( vnmo2 * ( t02 * vnmo2 + (1 + eta2) * r2) )

           IF (shfts .ge. 0.0) THEN

              shft  = sqrt (shfts) / sr + 1.0
              if (shft .le. ns-2) then

                if (shft .gt. 0) then

                    zj = shft
                    it = int(zj)
                    if (it .eq. 0) it = 1
                     f  = zj - aint(zj)
                     fs = f * f
                     c1 = fs - f
                     c2 = 2.0 - 2.0 * fs
                     c3 = fs + f
                     y(i)=0.5 * (
     :                   work(it)   * c1 +
     :                   work(it+1) * c2 +
     :                   work(it+2) * c3
     :                          )
                else
                     y(i) = work(i)
                endif

              else
                y(i) = 0
              endif

           ENDIF

       ENDDO

      ELSE

       call vclr (y, 1, ns)

       DO  i = 2, ns


           t0    = (i-1) * sr
           t02   = t0 * t0
           eta   = e (i)
           eta2  = 2 * eta
           vnmo  = v (i)
           vnmo2 = vnmo * vnmo
           if (.not. nmo) then
              xnmo  = r2 / vnmo2
           else
              xnmo  = 0.0
           endif

           shfts = t02 + xnmo - eta2 * r4 /
     1              ( vnmo2 * ( t02 * vnmo2 + (1 + eta2) * r2) )

           IF (shfts .ge. 0.0) THEN
 
              shft  = sqrt (shfts) / sr + 1.0

              if (shft .le. ns-2) then

                if (shft .gt. 0) then

                    zj = shft
                    it = int(zj)

                    if (it .eq. 0) it = 1
                    f  = zj - aint(zj)
                    fs = f * f
                    c1 = fs - f
                    c2 = 2.0 - 2.0 * fs
                    c3 = fs + f
                    y(it) = 0.5 *   (
     :                     work(i)   * c3 +
     :                     work(i+1) * c2 +
     :                     work(i+2) * c1
     :                              )
                else
                     y(i) = work(i)
                endif

              else
                y(i) = 0

              endif

           ENDIF

       ENDDO

      ENDIF

      RETURN
      END
