C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c

c Changes:

c
c vtinmo reads seismic (MBS depth migrated CRPs) trace data from an input file,
c and applies a gamma-dependent NMO and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( 2*SZLNHD )
      integer     lhed( 2*SZLNHD )
      integer     vtr ( 2*SZLNHD )
      integer     vhed( 2*SZLNHD )
      integer     etr ( 2*SZLNHD )
      integer     ehed( 2*SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform,obytes
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     lvbytes, lebytes, nvbytes, nebytes
      integer     luvel, lueta
      integer     JJ, KK , errcd, abort
      integer     argis, pipe1, pipe2, vflag, eflag
      integer     ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer     ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn
      integer     ifmt_StaCor, l_StaCor, ln_StaCor, StaCor

      real        sii, offset

      real        tri, xtr, v_trace, work
      pointer     (wkwork   , work   (10000000))
      pointer     (wktri    , tri    (10000000))
      pointer     (wkxtr    , xtr    (10000000))
      pointer     (wkv_trace, v_trace(10000000))
      pointer     (wke_trace, e_trace(10000000))

      character   ntap * 256, otap * 256, vtap * 256, name*6
      character   etap * 256

      logical     remove, verbos, heap, nmo
 
      equivalence ( itr(  1), lhed(1) )
      equivalence ( vtr(  1), vhed(1) )
      equivalence ( etr(  1), ehed(1) )

      data  lbytes /0/
      data  nbytes /0/
      data  abort /0/
      data  name /'VTINMO'/
      DATA  pipe1/3/
      DATA  pipe2/4/

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c open printout files

#include <f77/open.h>

c parse command line
 
      call gcmdln ( ntap, otap, vtap, etap, remove, unit, verbos,
     1              nmo)

c check for extraneous arguments and abort if found

      call xtrarg ( name, LER, .FALSE., .FALSE. )
      call xtrarg ( name, LERR, .FALSE., .TRUE. )

c get logical unit numbers for input and output

      call getln ( luin , ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c get logical unit numbers for velocity & eta

      if (etap .ne. ' ') then
          call getln(lueta, etap, 'r',-1)
      else
          write(LERR,*)'vtinmo assumed to be running inside IKP'
          call sisfdfit (lueta, pipe2)
      endif
      if(lueta .lt. 0)   then
         write(lerr,*)'vtinmo error: eta file -e[] not accessible'
      endif

      if (vtap .ne. ' ') then
          call getln(luvel, vtap, 'r',-1)
      else
          write(LERR,*)'vtinmo assumed to be running inside IKP'
          call sisfdfit (luvel, pipe1)
      endif
      if(luvel .lt. 0)   then
         write(lerr,*)
     1   'vtinmo error: velocity file -v[] not accessible'
      endif

c read line header of input
c save certain parameters

      vflag=1
      eflag=1

      lbytes=0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LOT,*)'VTINMO: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c_____________________________________________________________________
c     read in velocity worktape line header.
c_____________________________________________________________________
      call rtape ( luvel, vtr, lvbytes )
      if(lvbytes .eq. 0) then
         write(LER,*)'VTINMO: no header read from unit ',luvel
         write(LER,*)'FATAL'
         stop
      endif
 
      call saver(vtr, 'NumSmp', nsampv, LINHED)
      call saver(vtr, 'SmpInt', nsiv  , LINHED)
      call saver(vtr, 'NumTrc', ntrcv , LINHED)
      call saver(vtr, 'NumRec', nrecv , LINHED)
      call saver(vtr, 'Format', iformv, LINHED)

      if (nsi .ne. nsiv) then
        write(LERR,*)'FATAL ERROR from vtinmo:'
        write(LERR,*)'Sample interval of input data and input velocity'
        write(LERR,*)'traces (',nsi,nsiv,') are not same.'
        call ccexit (666)
      endif

c_____________________________________________________________________
c     read in eta worktape line header.
c_____________________________________________________________________
      call rtape ( lueta, etr, lebytes )
      if(lebytes .eq. 0) then
         write(LER,*)'VTINMO: no header read from unit ',lueta
         write(LER,*)'FATAL'
         stop
      endif
 
      call saver(etr, 'NumSmp', nsampe, LINHED)
      call saver(etr, 'SmpInt', nsie  , LINHED)
      call saver(etr, 'NumTrc', ntrce , LINHED)
      call saver(etr, 'NumRec', nrece , LINHED)
      call saver(etr, 'Format', iforme, LINHED)
      call saver(etr, 'T_Unit',  iscl , LINHED)
 
      if (nsi .ne. nsie) then
        write(LERR,*)'FATAL ERROR from vtinmo:'
        write(LERR,*)'Sample interval of input data and input eta'
        write(LERR,*)'traces (',nsi,nsie,') are not same.'
        call ccexit (666)
      endif
      if (unit .eq. 0) then
        if (iscl .le. 0) then
        write(LERR,*)'FATAL ERROR from vtinmo:'
        write(LERR,*)'No proper eta scale factor read from line'
        write(LERR,*)'header (',iscl,'). Should be value 10-1000'
        write(LERR,*)'Use in-place utop ... -h0T_Unit= to input value'
        call ccexit (666)
        endif
        scl = 1.0 / float (iscl)
      else
        scl = unit
      endif

c_____________________________________________________________________
c     vflag = 0 single velocityfunction
c     vflag = 1 multiple velocityfunction
c     eflag = 0 single gamma function
c     eflag = 1 multiple gamma function
c_____________________________________________________________________
      if (nrecv .le. 1) vflag = 0
      if (nrece .le. 1) eflag = 0


c print historical line header to printout file

      call hlhprt (itr, lbytes, name, 6, LERR)

      sii  = nsi
      dt = sii * unitsc


         write(LERR,*)' '
         write(LERR,*)' Values read from input seismic worktape'
         write(LERR,*)' # of Samples/Trace =  ',nsamp
         write(LERR,*)' Sample Interval    =  ',nsi
         write(LERR,*)' Traces per Record  =  ',ntrc
         write(LERR,*)' Records per Line   =  ',nrec
         write(LERR,*)' Format of Data     =  ',iform
         if (vflag .eq. 0) then
            write(LERR,*)' Single velocity function will be used'
         endif
         if (eflag .eq. 0) then
            write(LERR,*)' Single eta function will be used'
         endif
         if (remove)write(LERR,*)' Remove normal moveout'
         write(LERR,*)' # of Samples/Trace =  ',nsampv
         write(LERR,*)' Values read from velocity worktape '
         write(LERR,*)' Sample Interval    =  ',nsiv
         write(LERR,*)' Traces per Record  =  ',ntrcv
         write(LERR,*)' Records per Line   =  ',nrecv
         write(LERR,*)' Format of Data     =  ',iformv
         write(LERR,*)' Values read from eta worktape '
         write(LERR,*)' # of Samples/Trace =  ',nsampe
         write(LERR,*)' Sample Interval    =  ',nsie
         write(LERR,*)' Traces per Record  =  ',ntrce
         write(LERR,*)' Records per Line   =  ',nrece
         write(LERR,*)' Format of Data     =  ',iforme
         write(lerr,*)' input data unit  luin  = ',luin
         write(lerr,*)' output data unit luout = ',luout
         write(lerr,*)' velocity unit    luvel = ',luvel
         write(lerr,*)' eta unit         lueta = ',lueta
         write(lerr,*)' eta scaler             = ',scl
         if (nmo) then
         write(lerr,*)' regular NMO has been applied to input'
         else
         write(lerr,*)' regular NMO has not been applied to input'
         endif
         write(LERR,*)' '

      if (nsampv .lt. nsamp) then
          write(lerr,*)'velocitytrace(s) too short; contains ',nsampv,
     1                  ' samples'
          write(lerr,*)'orig input data contains ',nsamp,' samples'
          write(lerr,*)'rerun velocity create job so that trace at least
     1 ',               nsi*nsamp,' ms long'
         call exit(2666)
      endif

      if (nsampe .lt. nsamp) then
          write(lerr,*)'eta trace(s) too short; contains ',nsampe,
     1                  ' samples'
          write(lerr,*)'orig input data contains ',nsamp,' samples'
          write(lerr,*)'rerun eta create job so that trace at least ',
     1                  nsi*nsamp,' ms long'
         call exit(2666)
      endif


      heap = .true.
      item = max (nsamp,nsampv) * SZSMPD

      call galloc (wkv_trace, item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wke_trace, item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wkwork   , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wktri    , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.
      call galloc (wkxtr    , item, errcd, abort)
      if (errcd .ne. 0)  heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR vtinmo: Unable to allocate workspace'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         write(LER ,*) item,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
         write(LERR,*) item,'  bytes'
      endif


c update historical line header

      call savhlh ( itr,lbytes,lbyout )

c write output lineheader

      call wrtape ( luout, itr, lbyout )

c calculate number of output bytes per trace

      obytes = SZTRHD + nsamp * SZSMPD

c echo pertinent information to printout file

c BEGIN PROCESSING

c
c ----- single velocity function -----
c
 
      if(vflag .eq. 0) then
 
         nvbytes=0
         call rtape (luvel, vtr, nvbytes)
         if(nvbytes .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'VTINMO: No velocity data found after '
            write(LERR,*)'       lineheader in ',vtap,' check '
            write(LERR,*)'       velin run thoroughly.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VTINMO: No velocity data found after '
            write(LER,*)'       lineheader in ',vtap,' check '
            write(LER,*)'       velin run thoroughly.'
            write(LER,*)'FATAL'
            goto 999
         endif
         call vmov (vtr(ITHWP1), 1, v_trace, 1, nsampv)
 
         if(verbos) then
            write(LERR,*)'velocity'
            write(LERR,777)(v_trace(i),i=1,nsampv)
 777        format(10f8.2)
         endif
c
c ----- check for valid velocities -----
c
 
         call dotpr (v_trace, 1, v_trace, 1, vdot, nsampv)
         if (abs(vdot) .lt. 1.e-06) then
            write(LERR,*)' '
            write(LERR,*)'VTINMO: velocity trace contains zeros'
            write(LERR,*)'       Check the velin step thoroughly'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'VTINMO: velocity trace contains zeros'
            write(LER,*)'       Check the velin step thoroughly'
            write(LER,*)'FATAL '
            go to 999
         endif
 
 
      endif

c
c ----- single eta function -----
c
      if(eflag .eq. 0) then
 
         nebytes=0
         call rtape (lueta, etr, nebytes)
         if(nebytes .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'VTINMO: No eta data found after '
            write(LERR,*)'       lineheader in ',vtap,' check '
            write(LERR,*)'       velin run thoroughly.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VTINMO: No eta data found after '
            write(LER,*)'       lineheader in ',vtap,' check '
            write(LER,*)'       velin run thoroughly.'
            write(LER,*)'FATAL'
            goto 999
         endif
         call vsmul (etr(ITHWP1), 1, scl, e_trace, 1, nsampv)
 
         if(verbos) then
            write(LERR,*)'eta'
            write(LERR,777)(e_trace(i),i=1,nsampe)
         endif
c
c ----- check for valid etas -----
c
 
         emin = 1.0
         emax = -1.0
         do  i = 1, nsampe
             if (e_trace(i) .le. emin) emin = e_trace(i)
             if (e_trace(i) .ge. emax) emax = e_trace(i)
         enddo
         if (emin .lt. -1.0 .OR. emax .gt. 1.0) then
            write(LERR,*)' '
            write(LERR,*)'VTINMO: eta trace samples outside -1,1'
            write(LERR,*)'       Check the velin step thoroughly'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'VTINMO: eta trace samples outside -1,1'
            write(LER,*)'       Check the velin step thoroughly'
            write(LER,*)'FATAL '
            go to 999
         endif
 
 
      endif


      
c process all record and traces input

      DO  JJ = 1, nrec

c
c ----- read velocity data -----
c
         if (vflag .eq. 1) then
            nvbytes = 0
            call rtape (luvel, vtr, nvbytes)
            if (nvbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'VTINMO: Premature EOF on velocity Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'VTINMO: Premature EOF on velocity Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL'
               goto 999
            endif
            call vmov (vtr(ITHWP1), 1, v_trace, 1, nsampv)
c
c ----- check for valid data -----
c
            call dotpr (v_trace, 1, v_trace, 1, vdot, nsampv)
 
            if (abs(vdot) .lt. 1.e-06) then
               write(LERR,*)' '
               write(LERR,*)'VTINMO: velocity trace contains zeros'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'VTINMO: velocity trace contains zeros'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif
 
         endif

c
c ----- read eta data -----
c
         if (eflag .eq. 1) then
            nebytes = 0
            call rtape (lueta, etr, nebytes)
            if (nebytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'VTINMO: Premature EOF on eta Dataset'
               write(LERR,*)'       at sequential record number ',JJ
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'VTINMO: Premature EOF on eta Dataset'
               write(LER,*)'       at sequential record number ',JJ
               write(LER,*)'FATAL'
               goto 999
            endif
            call vsmul (etr(ITHWP1), 1, scl, e_trace, 1, nsampe)
c
c ----- check for valid data -----
c
            emin = 1.0
            emax = -1.0
            do  i = 1, nsampe
                if (e_trace(i) .le. emin) emin = e_trace(i)
                if (e_trace(i) .ge. emax) emax = e_trace(i)
            enddo
            if (emin .lt. -1.0 .OR. emax .gt. 1.0) then
               write(LERR,*)' '
               write(LERR,*)'VTINMO: eta trace samples outside -1,1'
               write(LERR,*)'       Check the velin step thoroughly'
               write(LERR,*)'FATAL '
               write(LER,*)' '
               write(LER,*)'VTINMO: eta trace samples outside -1,1'
               write(LER,*)'       Check the velin step thoroughly'
               write(LER,*)'FATAL '
               go to 999
            endif

 
         endif


         DO  KK = 1, ntrc

            nbytes = 0
            call rtape( luin, lhed, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor, TRACEHEADER)
            call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum, TRACEHEADER)
            call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1           dstsgn, TRACEHEADER)

            offset = dstsgn

c process only live traces

            IF ( StaCor .ne. 30000) then

                call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

                call ganmo (tri, v_trace, e_trace, offset, nsamp,
     1                      dt, xtr, work, remove, nmo)

                call vmov (xtr, 1, lhed(ITHWP1), 1, nsamp)
               
            ELSE

c clear all traces marked as dead

                call vclr (lhed(ITHWP1), 1, nsamp)

            ENDIF

c  write output data

            call wrtape (luout, lhed, obytes)

         ENDDO

         if (verbos) write(LERR,*)'processed rec ',recnum
 
      ENDDO

c Normal Termination: close data files
      
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
      call lbclos ( lueta )

      write(LERR,*)'end of vtinmo, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Normal Termination'
      write(LER,*)' '
      write(LER,*)'vtinmo: Normal Termination'

      stop

  999 continue

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luvel )
      call lbclos ( lueta )

      write(LERR,*)'end of vtinmo, processed',JJ,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Abnormal Termination'
      write(LER,*)' '
      write(LER,*)'vtinmo: Abnormal Termination'
      stop
      end
 
C SUBROUTINES help, gcmdln, verbos

      subroutine help

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for vtinmo: TI anisotropic'
      write(LER,*)' normal moveout'
      write(LER,*)'  '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-v[]   -- velocity data set                (none)'
      write(LER,*)'-e[]   -- eta data set                     (none)'
      write(LER,*)'-u[]   -- scale factor override     (no override)'
      write(LER,*) ' '
      write(LER,*)'-nmo   -- regular NMO already applied     (false)'
      write(LER,*)
     :' -R  include on command line to remove moveout'
      write(LER,*)
     :' -V  include on command line if verbose printout is desired'
      write(LER,*) ' '
      write(LER,*)
     :'usage:   vtinmo -N[] -O[] -v[] -e[] -u[] [ -nmo -R -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c subroutine to parse command line
 
      subroutine gcmdln ( ntap, otap, vtap, etap, remove, unit, verbos,
     1                    nmo)

c-----
c     get command arguments
c
c     ntap  - C*256     input file name
c     otap  - C*256     output file name
c     sii   - R*4       input sample interval override
c     sio   - R*4       output sample interval
c     nso   - I*4       output sample interval header override
c     micro -  L        convert input s.i. to micro secs
c     verbos -  L       verbose output or not
c     cube - L          use cubic spline interpolation
c     sinc - L          use sinc interpolation
c     nsinc -I*4        number of points in sinc interpolator
c     four - L          use Fourier interpolation
c     cubef - L         use cubic spline interpolation with post interpolation filter
c     linear - L        use linear interpolation
c
c-----

#include <f77/iounit.h>

c variables passed from calling routine

      character   ntap*(*), otap*(*), vtap*(*), etap*(*)
      real        unit
      logical     remove, verbos, nmo

c local variables

      integer argis
 

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-v', vtap, ' ', ' ' )
            call argstr( '-e', etap, ' ', ' ' )

            call argr4 ('-u', unit, 0.0, 0.0)


            nmo    = (argis('-nmo') .gt. 0)
            remove = (argis('-R') .gt. 0)
            verbos = (argis('-V') .gt. 0)

 
      return
      end
