C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Skew(tri, space, N, start, end, 
     :     Number_Windows, iwin_sample, run)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer N, start, end

      real tri(N), space(N), Average(SZLNHD)
      real Standard_Dev(SZLNHD)

      logical run

c initialize variables


c     process data
     
c=====================================================================
c Windows in series 
     
      if (.not. run) then
         Do j = 1, Number_Windows
            Average(j) = 0.
            Standard_Dev(j) = 0.
            space(j) = 0.
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               Average(j)=Average(j)+(tri(i))
               
            ENDDO
            Average(j)=Average(j)/(iwin_sample)
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               Standard_Dev(j)=Standard_Dev(j) +
     :             ( ((tri(i) - Average(j)))**2)
               
            ENDDO
            
            Standard_Dev(j)= Standard_Dev(j)/(iwin_sample - 1)

            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               space(j)=space(j) +
     :             ( ((tri(i) - Average(j)))**3)
               
            ENDDO
            
            space(j)=space(j)/(Standard_Dev(j)**3)
            if(Standard_Dev(j) .eq. 0. .and.
     :           Average(j) .eq. 0.) then
                space(j) = 0.
            endif
         enddo
      endif
c=====================================================================
c     Running Window
      if(run) then
         do j = start-start+1, end-start+1
            Average(j) = 0.
            Standard_Dev(j) = 0.
            space(j) = 0.
            
c     do this like a role-in / role-out
            
            istart =  (j - (iwin_sample/2)) + start - 1
            iend   =  (j + (iwin_sample/2)) + start - 1
            
            
            if (istart .lt. start) istart = start
            if (iend .gt. end) iend = end
            
            do i = istart, iend
               
               Average(j)=Average(j)+(tri(i))  
               
            enddo
            Average(j)=Average(j)/(iend-istart+1)
            
            do i = istart, iend
               Standard_Dev(j)=Standard_Dev(j) +
     :              ( ((tri(i) - Average(j)))**2)
               
            enddo
            Standard_Dev(j)= Standard_Dev(j)/(iend-istart-1)
            
            do i = istart, iend
               space(j)=space(j) +
     :              ( ((tri(i) - Average(j)))**3)
               
            enddo
              
            space(j)=space(j)/(Standard_Dev(j)**3)
            if(Standard_Dev(j) .eq. 0. .and.
     :           Average(j) .eq. 0.) then
                space(j) = 0.
            endif
         enddo
      endif
c=====================================================================
      return
      end
