C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Stan_Dev(tri, space, N, start, end, 
     :     Number_Windows, iwin_sample, run)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer N, start, end

      real tri(N), space(N), Average(SZLNHD)
      logical run
c initialize variables


c     process data
     
c=====================================================================
c Windows in series 
     
      if (.not. run) then
         Do j = 1, Number_Windows
            Average(j) = 0.
            space(j) = 0.
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               Average(j)=Average(j)+(tri(i))
               
            ENDDO
            Average(j)=Average(j)/(iwin_sample)
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
               
               space(j)=space(j) +
     :             ( ((tri(i) - Average(j)))**2)
               
            ENDDO
            
            space(j)= space(j)/(iwin_sample - 1)
         enddo
      endif
c=====================================================================
c     Running Window
      if(run) then
         do j = start-start+1, end-start+1
            Average(j) = 0.
            space(j) = 0.
            
c     do this like a role-in / role-out
            
            istart =  (j - (iwin_sample/2)) + start - 1
            iend   =  (j + (iwin_sample/2)) + start - 1
            
            
            if (istart .lt. start) istart = start
            if (iend .gt. end) iend = end
            
            do i = istart, iend
               
               Average(j)=Average(j)+(tri(i))  
               
            enddo
            Average(j)=Average(j)/(iend-istart+1)
            
            do i = istart, iend
               space(j)=space(j) +
     :              ( ((tri(i) - Average(j)))**2)
               
            enddo
            space(j)= space(j)/(iwin_sample - 1)   
            
         enddo
      endif
c=====================================================================
      return
      end
