C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE HILBRT(NZ,NF,WC,F,DX,NX,X,Z)
C
C  PROGRAM TO PERFORM A HILBERT TRANSFORM ON A VECTOR X
C  OF LENGTH NX.
C
C  Z SERVES FIRST AS A DUMMY CONVOLUTION ARRAY
C  AND MUST BE DIMENSIONED NZ=NX+NF-1
C
C  TRANSFORM IS RETURNED AS Z OF LENGTH NX
C
C  NOTE: HILF OPERATOR RESULTS IN COS --> -SIN.....
C  BY JH BODINE   7/27/81
C
C
C      F = DUMMY ARRAY FOR THE HILBERT OPERATOR
C     NF = NO.POINTS IN HILBERT TRANSFER FUNCTION (ODD)
C     DX = SAMPLE INTERVAL
C   NX,X = NO. POINTS IN VECTOR X WHICH IS TO BE TRANSFORMED
C
      DIMENSION X(1),F(2000),Z(1)
C     DIMENSION X(1),F(NF),Z(NZ)
C
      CALL HILF(DX,WC,NF,F)
C
      CALL FOLD(NF,F,NX,X,NZ,Z)
C
      DO 10 I=1,NX
C     WRITE(*,*) Z(I),I
   10 Z(I)= Z((NF-1)/2+I)*DX
C
      RETURN
      END
C***********************************************************************
      SUBROUTINE HILF(TDEL,WC,LF,F)
C                            FORTRAN BY KEN PEACOCK  11-11-76
C      SUBROUTINE HILF CONSTRUCTS THE OPERATOR FOR HILBERT
C      TRANSFORMATION. WEIGHTING IS AVAILABLE ON OPTION.
C         INPUTS ARE;
C           TDEL = SAMPLE INCREMENT IN SECONDS
C             WC = 0 OUTPUT RAW OPERATOR
C                NE 0 USE A ROSS WEIGHT FUNCTION WITH EXPONENT WC
C             LF = LENGTH OF FILTER IN SAMPLES (MUST BE ODD)
C        OUTPUT IS;
C              F = THE LF-LENGTH OUTPUT ARRAY
C      CODED FOR THE IBM 370/158 COMPUTER
C      VERSION AS OF 11-11-76
C
      DIMENSION F(1)
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 1 I=1,LF
    1 F(I) = 0.
      FACT = -2./(TDEL*3.14159265)
      DO 2 I=1,N,2
      J = N+1+I
      K = N+1-I
      F(J) = FACT/I
    2 F(K) = -F(J)
      IF(WC.EQ.0.) GO TO 4
      DO 3 I=ISTA,LF
      AK = I+KFACT
      F(I) = F(I)*((1.-(AK/N)**2)**WC)
      J = JFACT-I
    3 F(J) = -F(I)
    4 RETURN
      END


      SUBROUTINE FOLD (LA,A,LB,B,LC,C)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       FOLD
C  ROUTINE TYPE:  SUBROUTINE  SINGLE_ENTRY
C  PURPOSE:
C      This subroutine finds the complete transient convolution of the
C      vectors A and B.
C  ARGUMENTS:
C      LA  I*4  I - LENGTH OF VECTOR A IN SAMPLES
C      A   R*4  I  ( 2 ) - THE VECTOR A A(1),A(2),.....,A(LA)
C      LB  I*4  I - THE LENGTH OF VECTOR B IN SAMPLES
C      B   R*4  I  ( 2 ) - THE VECTOR B B(1),B(2),.....,B(LA)
C      LC  I*4  O - THE LENGTH OF VECTOR C (LA + LB - 1)
C      C   R*4  O  ( 2 ) - THE COMPLETE TRANSIENT CONVOLUTION VECTOR C
C  CATEGORY:  UTILITY ARRAY CONVOLVE FILTER
C  KEYWORDS:  CONVOLUTION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    ?                               ORIGIN DATE:     ?
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      MOVE     - USED TO ZERO THE VECTOR C ARRAY BEFORE CONVOLUTION
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:
C  GENERAL DESCRIPTION:
C            NOTE: THIS SUBROUTINE ZEROS THE VECTOR C PRIOR
C                  TO CONVOLUTION
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C     THIS IS A CONFIDENTIAL AMOCO PRODUCTION COMPANY PROGRAM
C
C     THIS SUBROUTINE FINDS THE COMPLETE TRANSIENT CONVOLUTION OF THE
C     VECTORS A AND B
C
C     INPUTS ARE
C        LA=LENGTH OF THE VECTOR A    INTEGER*4
C         A=THE VECTOR A, A(1),A(2),...A(LA)      REAL*4
C        LB=LENGTH OF THE VECTOR B      INTEGER*4
C         B=THE VECTOR B, B(1),B(2),...B(LB)    REAL*4
C     OUTPUTS ARE
C        LC=LA+LB-1=LENGTH OF THE VECTOR C     INTEGER*4
C         C=THE COMPLETE TRANSIENT CONVOLUTION VECTOR C     REAL*4
C
C     NOTE--THIS SUBROUTINE ZEROS THE VECTOR C PRIOR TO CONVOLUTION
C
C          THIS SUBROUTINE IS MAINTAINED BY A. DOWDY
C
      DIMENSION A(2),B(2),C(2)
      LC=LA+LB-1
C
C
C  ZERO SUBSTITUTED FOR IBM SYSTEM ROUTINE: MOVE
C
C
      CALL ZERO(C,LC)

      DO 5 I=1,LC
    5 C(I) = 0.
      DO 10 I=1,LA
      DO 10 J=1,LB
      K=I+J-1
   10 C(K)=A(I)*B(J)+C(K)
      RETURN
      END
C
      SUBROUTINE ZERO(ARRAY,NSAMP)
      REAL ARRAY(NSAMP)
      DO 10 I=1,NSAMP
          ARRAY(I) = 0.0
   10 CONTINUE
      RETURN
      END
C
       SUBROUTINE QCON(R,Q,A,N)
C
C  JH BODINE  10/19/82
C
C  ROUTINE TO OBTAIN COMPLIMENTARY FUNCTIONS FROM REAL
C  SEISMIC TRACE USING THE RESPONSE PHASE (DESCRIBED IN PROGRAM
C  CSIG). ONE FUNCTION IS ASSOCIATED WITH ZERO PHASE AND THE OTHER
C  WITH PI/2 PHASE.
C
C      R = REAL SEISMIC TRACE INPUT
C          RETURNED AS ZERO PHASE COMPONENT
C      Q = QUADRATURE FOR ANALYTIC SIGNAL AS INPUT
C          RETURNED AS PI/2 PHASE COMPONENT
C      A = RESPONSE PHASE ARRAY
C
C      N = INTEGER LENGTH OF ALL ARRAYS
C
C  DERIVATION OF MATH BY KEN HANSON.
C
C
       DIMENSION R(1),Q(1),A(1)
C
       PI = 3.14159265
       DEGRAD = PI/180.
C
       DO 10 I=1,N
       ANG = A(I) * DEGRAD
       RP = (COS(ANG)**2*R(I)+COS(ANG)*SIN(ANG)*Q(I))
       Q(I) = R(I) - RP
   10  R(I) = RP
       RETURN
       END
      SUBROUTINE ALEN(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF
C  THE TIME WIDTH OF THE ENVELOPE LOBES.
C  THE VALUE OF THE ENVELOPE IS SET FROM TROUGH
C  TO TROUGH. THE RESULTING "ENVELOPE" MAY BE CONSIDERED TO
C  REPRESENT A MODIFICATION OF
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,
C  IT WILL BE SKIPPED (STATEMENT #50).
C
      DIMENSION A(1),ITRF(1000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      DO 100 I = 2,NPT1
      SLAST = SLOP
      SLOP = A(I+1) - A(I)
      CHNG = SLAST * SLOP
      IF(CHNG.GE.0.) GO TO 100
      IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
      JP = JP+1
      GO TO 100
C
   50 IF(JP.EQ.1) GO TO 100
      ITRF(JT) = I
      JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO VALUE OF ENVELOPE LOBE WIDTH
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      VALUE = IEND - ISTRT
      DO 300 I = ISTRT,IEND
  300 A(I) = VALUE
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
      SUBROUTINE ASLP(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO A VALUE
C  PROPORTIONAL TO THE MAX SLOPE OF THE ENVELOPE LOBES.
C
C    SLOPE = MAX(A(I+1)-A(I))/MAX(A(I)) * 1000.
C
C  THE VALUE OF THE ENVELOPE IS SET FROM TROUGH
C  TO TROUGH. THE RESULTING "ENVELOPE" MAY BE CONSIDERED TO
C  REPRESENT A MODIFICATION OF
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,
C  IT WILL BE SKIPPED (STATEMENT #50).
C
      DIMENSION A(1),ITRF(1000),SLOPMX(1000),ENVMAX(1000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      SMAX = 0.
      AMAX = 0.
      DO 100 I = 2,NPT1
      SLAST = SLOP
      SLOP = A(I+1) - A(I)
      CHNG = SLAST * SLOP
      IF(ABS(SLOP).GT.ABS(SMAX)) SMAX = SLOP
      IF(ABS(A(I)).GT.ABS(AMAX)) AMAX = A(I)
      IF(CHNG.GE.0.) GO TO 100
      IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
      JP = JP+1
      GO TO 100
C
   50 IF(JP.EQ.1) GO TO 100
      ENVMAX(JT) = AMAX
      SLOPMX(JT) = SMAX
      SMAX = 0.
      ITRF(JT) = I
      JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO VALUE OF ENVELOPE LOBE WIDTH
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      DO 300 I = ISTRT,IEND
      IF (ENVMAX(J).EQ.0.) ENVMAX(J) = 1.
  300 A(I) = SLOPMX(J)/ENVMAX(J)*1000.
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
      SUBROUTINE ASKW(A,NPT)
C
C  JH BODINE 9/2/81
C
C  ROUTINE TO CALCULATE THE ASYMMETRY OF THE ENVELOPE
C
C  ROUTINE TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF
C  THE DIFFERENCE BETWEEN THE ARRAY POSITIONS OF THE ENVELOPE LOBE
C  PEAK AND THE FIRST MOMENT OF THE LOBE.
C  THE VALUE OF THE ENVELOPE IS SET TO THAT OF THIS DIFFERENCE * 100
C  FROM TROUGH TO TROUGH. THE RESULTING "ENVELOPE" MAY BE
C  CONSIDERED TO BE A MEASURE OF THE DEGREE OF ASYMMETRY OF EACH
C  ENVELOPE LOBE.
C
C  SEE TANER ET AL., 1979, GEOPHYSICS, V.44, #6,P.1041.
C     A = COMPLEX ENVELOPE
C   NPT = NUMBER OF SAMPLE POINTS
C
C  PROGRAM ASSUMES THE FIRST POINT IN THE SIGNAL IS A TROUGH
C  AND THE FIRST POINT OF ZERO SLOPE IS A PEAK. IF THIS POINT
C  IS A TROUGH IT WILL BE SKIPPED (STATEMENT #50).
C
C  NOTE FOR USER'S;
C     THIS ROUTINE WILL FIND EVERY ENVELOPE PEAK REGARDLESS
C     OF RELATIVE AMPLITUDE. DISPLAY OF RESULTS FOR NOISY
C     DATA IS THUS MOST EFFECTIVE WITH A COLOR PLOT WHERE COLOR
C     INTENSITY IS AMPLITUDE MODULATED.
C
C
      DIMENSION A(1),ITRF(1000),IPEAK(1000)
C
      JT = 1
      JP = 1
      SLOP = 0.
C
C  FIND ARRAY POSITIONS OF MAXIMA AND MINIMA
C
      NPT1 = NPT - 1
      DO 100 I = 2,NPT1
      SLAST = SLOP
      SLOP = A(I+1) - A(I)
      CHNG = SLAST * SLOP
      IF(CHNG.GE.0.) GO TO 100
      IF(CHNG.LT.0. .AND. SLAST.LT.0.) GO TO 50
      IPEAK(JP) = I
      JP = JP+1
      GO TO 100
C
   50 IF(JP.EQ.1) GO TO 100
      ITRF(JT) = I
      JT = JT+1
C
  100 CONTINUE
      ITRF(JT)=NPT
      JP = JP-1
      IF(JP.EQ.0) JP=1
C
C  SET ENVELOPE LOBES TO DIFFERENCE IN ARRAY POSITION OF ENVELOPE
C  PEAK AND FIRST MOMENT
C
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      SUMM = 0.
      ASUM = 0.
C  GET FRACTIONAL ARRAY POSITION OF ENVELOPE PEAK
      K = IPEAK(J)
      FP = FPEAK(A,K)
C  GET POSITION OF FIRST MOMENT
      DO 260 II = ISTRT,IEND
      SUMM = SUMM + (FP-II)*A(II)
      ASUM = ASUM + A(II)
  260 CONTINUE
      IF(ASUM.EQ.0.) ASUM = 1.
      AMOM = SUMM/ASUM
      IF(ASUM.EQ.0.) AMOM = 0.
C  SET ENVELOPE ARRAY TO DIFFERENCE OF PEAK AND 1ST MOM POSITIONS
      DO 300 I = ISTRT,IEND
  300 A(I) = AMOM *100.
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       PKDT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO SET ANALYTIC SIGNAL ENVELOPE LOBES TO VALUE OF         *
C            THE INPUT DATA AT THE POINT WHERE THE ENVELOPE            *
C            IS A MAXIMUM. VALUE OF ENVELOPE SET FROM TROUGH TO TROUGH *
C  ENTRY POINTS:                                                       *
C      PKDT  (DATA,A,NPT,scale)
C  ARGUMENTS:                                                          *
C      DATA    REAL         I*  (1) - INSTANTANEOUS ATTRIBUTE ARRAY    *
C      A       REAL         U*  (1) - COMPLEX ENVELOPE ON INPUT        *
C                                   - RESPONSE ATTRIBUTE OUTPUT        *
C      NPT     INTEGER      I*      - NUMBER OF SAMPLES IN 'DATA'&'A'  *
C      scale   REAL         I*  (1) - % env to keep
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J.H. BODINE                        ORIGIN DATE: 81/09/02  *
C  LANGUAGE: FORTRAN 77/IV               DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MNMX - TO FIND RELATIVE MINIMA/RELATIVE MAXIMA OF AMPLITUDE FCN *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      6  ( OUTPUT SEQUENTIAL ) - DEBUG FILE                           *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  NONE                                               *
C  GENERAL DESCRIPTION:  PROGRAM ASSUMES FIRST POINT IN SIGNAL IS TROUG*
C      AND THE FIRST MAXIMA IS A PEAK. IF THE FIRST MAXIMA IS A TROUGH,*
C      IT WILL BE SKIPPED IN MNMX.                                     *
C  REVISED BY:  J. NORRIS (PKDTA)             REVISION DATE: 83/06/02  *
C       ADD CALL TO MNMX TO SCAN FOR RELATIVE MINIMA/MAXIMA.           *
C  REVISED BY:  Don Wagner 3/39/92
C       ADD scale factor to restrict envelop peaks
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE PKDT(DATA,A,NPT,scale )
      DIMENSION A(1),DATA(1),ITRF(1000),IPEAK(1000),PEAK(1000)
C***********************************************************************
C       FIND ARRAY POSITIONS OF MAXIMA AND MINIMA. THEN SET PEAK VALUES
C        OF INPUT DATA AT DATA AT IPEAK(I) ARRAY POSITIONS
C***********************************************************************
      CALL MNMX(A,NPT,IPEAK,JP,ITRF,JT)

	call maxmgv (a,1,amax,index,npt)
	thresh = scale*amax
C
      DO 200 I=1,JP
         K = IPEAK(I)
         PEAK(I) = DATA(K)
  200 CONTINUE
C***********************************************************************
C  SET ENVELOPE LOBES TO IPEAK VALUES, if IPEAK > thresh
C***********************************************************************
      J = 1
      ISTRT = 1
  250 IEND = ITRF(J)
      DO 300 I = ISTRT,IEND
      if (abs(a(ipeak(j))) .gt. thresh) then
	a(i) = peak(j)
      else
	a(i) = 0.0
      endif
  300 continue
C
      J = J+1
      IF(IEND.EQ.NPT) GO TO 350
      ISTRT = IEND
      GO TO 250
C
  350 CONTINUE
C
      RETURN
      END
