C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadFlatFile(lupick,Record,StartTime,EndTime,irs,ire,
     :     PickOverride,verbos)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer lupick,nelem,item,irs,ire
      integer errcd1,errcd2,errcd3,abort,i,j

      real StartTime(*),Record(*),EndTime(*),slope
      real TempRec,TempStart,TempEnd,PickOverride

      pointer (wkadr9, TempRec(2000000))
      pointer (wkadr10, TempStart(2000000))
      pointer (wkadr11, TempEnd(2000000))

      logical verbos

c
c ----- initialize variables -----
c
 
      nelem = 1
      abort = 0

c
c ----- allocate additional memory -----
c

      item = ((ire-irs)+1)*SZSMPD

      call galloc(wkadr9,item,errcd1,abort)
      call galloc(wkadr10,item,errcd2,abort)
      call galloc(wkadr11,item,errcd3,abort)

      if (errcd1 .ne. 0 .or. errcd2 .ne. 0 .or. errcd3 .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'FATAL:Unable to allocate Flatfile workspace:'
         write(LERR,*) item*3,'  bytes'
         write(LERR,*)' '
         stop
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating Flatfile workspace:'
         write(LERR,*) item*3,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- rewind file -----
c

      rewind lupick


c
c ----- read segments and count entries -----
c

 1    read(lupick,*,end=998)TempStart(nelem),TempEnd(nelem),
     :     TempRec(nelem)

      if(TempRec(nelem).gt.0) then

         nelem = nelem + 1
         goto 1

      else

         nelem = nelem - 1
         if(verbos)write(LERR,*)'Read ',nelem,' elements in flat file'

      endif

c
c ----- have reached end of pick file -----
c
      if(PickOverride.gt.1)then

         do j = 1,nelem

c
c ----- multiply picks by pick sample interval override if required -----
c

            TempStart(j) = TempStart(j)*PickOverride
            TempEnd(j) = TempEnd(j)*PickOverride
               
         enddo

      endif

c
c ----- interpolate a Start and EndTime for every record -----
c

      DO 20 i=irs,ire


         do j=1,nelem

            if(float(i).le.TempRec(j))then

               if(j.eq.1)then

                  Record(i) = float(i)
                  StartTime(i) = TempStart(j)
                  EndTime(i) = TempEnd(j)
                  goto 20

               else

                  Record(i) = float(i)
                  slope = (TempStart(j) - TempStart(j-1))/(TempRec(j) - 
     :                 TempRec(j-1))
                  StartTime(i) = slope * (Record(i) - TempRec(j-1)) + 
     :                 TempStart(j-1)
                  slope = (TempEnd(j) - TempEnd(j-1))/(TempRec(j) - 
     :                 TempRec(j-1))
                  EndTime(i) = slope * (Record(i) - TempRec(j-1)) + 
     :                 TempEnd(j-1)
                  goto 20

               endif

            endif

         enddo
               
 20    CONTINUE

      if(verbos)then

         write(LERR,*)' '
         write(LERR,*)' Window Parameters as interpolated from Pickfile'
         write(LERR,*)' '
         write(LERR,*)'   Record    StartTime    EndTime '

         do j=irs,ire

            write(LERR,*)record(j),StartTime(j),EndTime(j)

         enddo

      endif
            

      return

 998  continue

      write(LERR,*)' '
      write(LERR,*)'FATAL: Unexpected EOF encountered while reading'
      write(LERR,*)'       flat file.  Check your input format and '
      write(LERR,*)'       rerun. The last line should be '
      write(LERR,*)' '
      write(LERR,*)'    0   0   -1 '
      stop

      end
