C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap,otap,ptap,le1,irs,ire,Xtrace,Ytrace
     :     ,Ztrace,pick,flat,PickOverride,AngleToAdd,AngleConstant,
     :     verbos)

#include <f77/iounit.h>

      integer    argis,irs,ire,Xtrace,Ytrace,Ztrace,le1

      real       PickOverride,AngleToAdd,AngleConstant
     
      character  ntap*(*), otap*(*),ptap*(*)

      logical    pick,flat,verbos

      le1 = 0

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ')
      call argstr('-P',ptap,' ',' ')

      le1 = lenth(ptap)

      call argr4('-rot',AngleToAdd,0.0,0.0)
      call argr4('-ROT',AngleConstant,0.0,0.0)

      call argi4('-rs',irs,1,1)
      call argi4('-re',ire,0,0)
      call argi4('-x',Xtrace,1,1)
      call argi4('-y',Ytrace,2,2)
      call argi4('-z',Ztrace,3,3)

      call argr4('-dt',PickOverride,1.0,1.0)

      pick = (argis('-pick') .gt. 0)
      flat = (argis('-flat') .gt. 0)

      if(le1.eq.0.and.AngleConstant.lt.1.e-20)then

         write(LERR,*)'FATAL: This routine requires input of a time'
         write(LERR,*)'       window over which to operate.  You may'
         write(LERR,*)'       supply this information in a pick file'
         write(LERR,*)'       derived by picking the fairway in xsd '
         write(LERR,*)'       or through a flat file.  A -P or -ROT '
         write(LERR,*)'       option is required.'
         write(LERR,*)'  '
         stop

      endif

      if(.not.pick.and..not.flat.and.AngleConstant.lt.1.e-20)then
         
         write(LERR,*)'FATAL: You must enter -pick or -flat to indicate'
         write(LERR,*)'       format of your input window information'
         write(LERR,*)'       or use -ROT option. '
         stop

      endif

      verbos = (argis('-V') .gt. 0)

      return
      end
