/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	write stdin to a series of cartridges
*/

#include <sys/errno.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <globs.h>

extern int errno;
/*
#define BYTES_PER_TAPE 1000000
int maxbytes = BYTES_PER_TAPE;
*/

/*
**	IO() returns 0 until it's finished, at which time it
**	returns 1.
*/
Boolean IOtoTape()
{
	if ( data.verbose >= 3 )
	  fprintf(tattle,"IOtoTape()\n");

/*
**	if you don't have any data, get some
*/
	if (bgood <= 0) bgood = getInput();
/*
**	If we've seen input EOF we're done.
*/
	if(bgood <= 0) {
	  sprintf(msg_text,"%.0f total bytes written",totalBytes);
	  if (data.verbose) fprintf(tattle,"\n%s\n",msg_text);
	  XmTextSetString(chd_stat_text,msg_text);
	  finishDrive();
	  WorkProcID = XtAppAddWorkProc(app_con,loader,(XtPointer)EOF);
	  return TRUE;
	  }
/*
**	if you have some data, write it out
*/
	bout = write(tape, iobuffer, bgood);

/*
	if (totalBytes > maxbytes) {
		bout = 0;
		maxbytes += BYTES_PER_TAPE;
	  }
*/
/*
**	we're getting bout == -1 at eot.  the man page says
**	we should have gotten 0.  i'm going to try accepting
**	either.
*/
	if(bout <= 0) {
	  if (errno == EIO) {
	    sprintf(msg_text,"xalert -C XCram10 OK 'XCRAM10 has received' 'I/O error %d, aborting' ",errno);
	    system(msg_text);
	    WorkProcID = NULL;
	    close(stdin);
	    }
	  else {
	    finishDrive();
	    WorkProcID = XtAppAddWorkProc(app_con,loader,NULL);
	    }
	  return TRUE;
	  }

	if(bout < bgood) {
	  sprintf(msg_text," - %d of %d bytes written - aborting",
		bout,bgood);
	  fprintf(tattle,"%s\n",msg_text);
	  XmTextInsert(chd_stat_text,
		XmTextGetLastPosition(chd_stat_text), msg_text);
	  WorkProcID = XtAppAddWorkProc(app_con,loader,(XtPointer)EOF);
	  return TRUE;
	  }
  
	totalBytes += bout;
	sprintf(msg_text,"%d (%.0f) total bytes written",bout,totalBytes);
	if (data.verbose >= 2) fprintf(tattle,"%s\n",msg_text);
	XmTextSetString(chd_stat_text,msg_text);
	bgood = 0;
	return FALSE;
}
