/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <ut_defs.h>
#include <globs.h>

int delay_month,delay_day,delay_year;
int delay_hour,delay_minute;

void set_delay(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XtWorkProcId WorkProcID;
	char *date,*time;
	char *cgdate(),*cgtime();
	Widget am_pm_widget;
	int value;
	int month,day,year,hour,minute,second;
	if(data.verbose >= 2)
	  fprintf(tattle,"*-/- set_delay -/-*\n");

	sscanf(XmTextGetString(*(Widget *)client_data),"%d",&delay_month);
	sscanf(XmTextGetString(*((Widget *)client_data+1)),"%d",&delay_day );
	sscanf(XmTextGetString(*((Widget *)client_data+2)),"%d",&delay_year );
	sscanf(XmTextGetString(*((Widget *)client_data+3)),"%d",&delay_hour );
	sscanf(XmTextGetString(*((Widget *)client_data+4)),"%d",&delay_minute );
	XtVaGetValues(*((Widget *)client_data+5),
			XmNmenuHistory,	&am_pm_widget,
			NULL);
	XtVaGetValues(am_pm_widget,
			XmNuserData,	&value,
			NULL);

	if (delay_hour < 12) delay_hour += value;

	date = cgdate();
	time = cgtime();
	sscanf(date,"%d/%d/%d",&month,&day,&year);
	sscanf(time,"%d:%d:%d",&hour,&minute,&second);
/*
   do some validity checking on delay time
*/
	if (((delay_year < year) && ((year != 99) | (delay_year != 00))) |
	 ((delay_month < month) && ((month != 12) | (delay_month != 1))) |
	  ((delay_day < day) && (delay_month == month)) |
	   ((delay_hour < hour) && (delay_day == day)) |
	    ((delay_minute < minute) && (delay_hour == hour))) {
	  sprintf(msg_text,
	   "*** Invalid Time (%02d/%02d/%02d %02d:%02d:00); Reenter ***",
	      delay_month,delay_day,delay_year,delay_hour,delay_minute);
	  XmTextSetString(chd_stat_text, msg_text);
	  XmUpdateDisplay(chd_stat_text);
	  XtManageChild(*((Widget *)client_data+6));
	  return;
	  }

	sprintf(msg_text,
	  "time: %02d/%02d/%02d %02d:%02d:%02d  starting time: %02d/%02d/%02d %02d:%02d:00",
	      month,day,year,hour,minute,second,
	      delay_month,delay_day,delay_year,delay_hour,delay_minute);
	if(data.verbose >= 2)
	  fprintf(tattle,"%s\n",msg_text);
	XmTextSetString(chd_stat_text, msg_text);
	XmUpdateDisplay(chd_stat_text);
	WorkProcID = XtAppAddTimeOut(app_con,0,check_delay,NULL);
}
void check_delay(client_data,id)
XtPointer client_data;
XtIntervalId *id;
{
	char *date,*time;
	char *cgdate(),*cgtime();
	int month,day,year,hour,minute,second;
	XtWorkProcId WorkProcID;
	if(data.verbose >= 2)
	  fprintf(tattle,"*-/- check_delay -/-*\n");


	date = cgdate();
	time = cgtime();
	sscanf(date,"%d/%d/%d",&month,&day,&year);
	sscanf(time,"%d:%d:%d",&hour,&minute,&second);

/* 
  I used <= so that if we missed a midnight startup, we'd catch it anyway
*/
	if ((delay_year <= year) &&
	 (delay_month <= month) &&
	  (delay_day <= day) &&
	   (delay_hour <= hour)) {
	  if (delay_minute == minute) {
	    sprintf(msg_text,
	      "started processing at %02d/%02d/%02d %02d:%02d:%02d",
	      month,day,year,hour,minute,second);
	    if (data.verbose) 
	      fprintf(tattle,"%s\n",msg_text);
	    XmTextSetString(chd_stat_text, msg_text);
	    XmUpdateDisplay(chd_stat_text);
	    WorkProcID = XtAppAddWorkProc(app_con,loader,
			(XtPointer) CHD_INITIAL_LOAD);
	    return;
	    }
/*
   if we're within a minute, go to one second timeout so we don't miss it
*/
	  else if ((delay_minute - minute) == 1) {
	    sprintf(msg_text,
	      "time: %02d/%02d/%02d %02d:%02d:%02d",
	      month,day,year,hour,minute,second);
	    if(data.verbose >= 2)
	      fprintf(tattle,"%s\n",msg_text);
	    XmTextReplace(chd_stat_text,0,strlen(msg_text),msg_text);
	    XmUpdateDisplay(chd_stat_text);
	    XtAppAddTimeOut(app_con,1000,check_delay,client_data);
	    return;
	    }
	  }
	sprintf(msg_text,
	  "time: %02d/%02d/%02d %02d:%02d:%02d",
	  month,day,year,hour,minute,second);
	XmTextReplace(chd_stat_text,0,strlen(msg_text),msg_text);
	XmUpdateDisplay(chd_stat_text);
	XtAppAddTimeOut(app_con,60000,check_delay,client_data);
}
