/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <globs.h>

int rem_cmd(cmd,mode,pid)
char *cmd;
char *mode;
int *pid;
{
	int i;
	int fd[4];	/* 0 - to remote command
			   1 - from remote command
			*/

	char **argv;

	argv = parse_cmd(cmd);

	if (data.verbose) {
	  fprintf(tattle,"\n");
	  for (i=0; argv[i] != NULL; i++)
	    fprintf(tattle,"%s ",argv[i]);
	  fprintf(tattle,"\n");
	  }

	pipe(&fd[0]); /* to_child */
	pipe(&fd[2]); /* to_parent */

	if (data.verbose >= 2)
	  fprintf(tattle,"fd[0] = %d, fd[1] = %d, fd[2] = %d, fd[3] = %d\n",
		fd[0],fd[1],fd[2],fd[3]);

	if (*pid = fork(), *pid == 0) { 	/* child process */
	  if (dup2(fd[0],0) < 0) perror("XCRAM10");
	  if (dup2(fd[3],1) < 0) perror("XCRAM10");
	  close(fd[0]); close(fd[1]);
	  close(fd[2]); close(fd[3]);
	  execvp(argv[0],argv);
	  fprintf(stderr,"error execing process\n");
	  }
	else {
	  if (strcmp(mode,"r") == 0) {
	    close(fd[0]); close(fd[1]); close(fd[3]); 
	    return (fd[2]);
	    }
	  else {
	    close(fd[0]); close(fd[2]); close(fd[3]); 
	    return (fd[1]);
	    }
	  }
	return(-1);
}
