/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Panel.h"
#include "ikp_globalE.h"

#define MAX_MODULES 1000

extern Widget menubar(Widget);
extern void draw_moduleCB(Widget,XtPointer,XmDrawingAreaCallbackStruct *);
extern void create_module(char *,Widget,int);
extern void button_pushEH(Widget,XtPointer,XEvent *);
extern void button_releaseEH(Widget,XtPointer,XEvent *);
extern void moving_mouseEH(Widget,XtPointer,XEvent *);
extern void unmanage_dialog();
extern void set_default_command(char *,Panel *);
extern void set_command(char *,Widget);
extern void create_filer_box();
extern void draw_modules();
extern void prompt_box();

extern FILE *yyin,*yyout;
extern int verbose;
extern Library *libs;

Panel *map_dialog(Widget,char *,int,int,int);

Widget draw_area=NULL;

static Widget module_list;
static Library *current_lib=NULL;
static char buf1[1024],buf2[1024];
static char xui_path[1024];

XtCallbackProc sel_libCB(Widget,XtPointer,XmListCallbackStruct *);
XtCallbackProc sel_moduleCB(Widget,XtPointer,XmListCallbackStruct *);

void parse_command(char *command)
{
  Widget main_form;
  char *module[MAX_MODULES];
  int n,count=1,module_count=0,c,pipe[MAX_MODULES];

  if (getenv("XUI_PATH")==NULL) {
    fprintf(stderr,"Please set the environment variable XUI_PATH.\n\n");
    exit(1);
  } 
                                /* Get path of the pattern files. */
  strcpy(xui_path,getenv("XUI_PATH"));

  create_filer_box();

				/* Parse command string for ';' and '|'. */
  c=command[0];
  strcpy(buf1,command);
  while (c!=(char)NULL) {
    if (c==';') {
      strcpy(buf2,buf1);
      strcpy(strchr(buf2,';'),"");
      module[module_count]=malloc(strlen(buf2));
      strcpy(module[module_count],"");
      sscanf(buf2,"%s",module[module_count]);
      if (strlen(module[module_count])>0) {
	pipe[module_count]=0;
	module_count++;
      }
      strcpy(buf1,strchr(buf1,';')+1);
    }
    if (c=='|') {
      strcpy(buf2,buf1);
      strcpy(strchr(buf2,'|'),"");
      module[module_count]=malloc(strlen(buf2));
      strcpy(module[module_count],"");
      sscanf(buf2,"%s",module[module_count]);
      if (strlen(module[module_count])>0)
	pipe[module_count]=1;
	module_count++;
      strcpy(buf1,strchr(buf1,'|')+1);
    }
    c=command[count++];
  }
  if (strlen(buf1)>0) {
    module[module_count]=malloc(strlen(buf1));
    strcpy(module[module_count],"");
    sscanf(buf1,"%s",module[module_count]);
    if (strlen(module[module_count])>0) {
      pipe[module_count]=0;
      module_count++;
    }
  }

  prompt_box();

  if (module_count==1) {
    main_form=XmCreateFormVa(top_level,"form",
			     XmNmarginHeight,10,
			     XmNmarginWidth,10,
			     NULL);
    
    map_dialog(main_form,module[0],1,0,0);
  } else {
    if (module_count==0)
      map_dialog(NULL,NULL,0,0,0);
    for (n=0; n<module_count; n++)
      if (n>0)
	map_dialog(NULL,module[n],0,pipe[n-1],pipe[n]);
      else
	map_dialog(NULL,module[n],0,0,pipe[n]);
  }
}

Panel *map_dialog(Widget main_form,
		  char *filename,
		  int only_flag,
		  int stdin_flag,
		  int stdout_flag)
{
  Widget dialog_window;
  Panel *item;
  static int init=1;
  char command[1024],keyword[1024];
  int value_count=0,start_flag=False;
  char **values;

  if (only_flag) {
    dialog_window=main_form;
  } else {
    if (init) {
      init=0;
      create_main_window();
    }
    if (filename==NULL) {
      return NULL;
    } else {
      dialog_window=XmCreateFormDialogVa(top_level,"form",
					 XmNmarginHeight,10,
					 XmNmarginWidth,10,
					 XtNmanageChild,False,
					 XmNautoUnmanage,False,
					 NULL);
      create_module(filename,dialog_window,stdout_flag);
    }
  }

  item=init_panel(dialog_window);

  create_panel(dialog_window,stdin_flag,stdout_flag);

  strcpy(buf1,xui_path);
  strcat(buf1,filename);
  strcat(buf1,".pattern");
  yyin=fopen(buf1,"r");
  if (yyin==NULL) {
    fprintf(stderr,"Can't open %s\n",filename);

				/* Create custom module. */
    strcpy(buf1,xui_path);
    strcat(buf1,"custom.pattern");
    yyin=fopen(buf1,"r");
    if (yyin==NULL) {
      fprintf(stderr,"Please check the environment variable XUI_PATH.\n\n");
      exit(1);
    }
  }
  yyout=fopen("/dev/null","w");
  if (yyparse()==1) {
    fprintf(stderr,"Error parsing %s\n",filename);
  }
  fclose(yyout);
  fclose(yyin);

  values=get_panel_defaults(item);
  while (values[value_count]!=NULL) {
    strcpy(buf1,values[value_count]);
    if (verbose)
      fprintf(stderr,"%s \n",buf1);
    strcpy(keyword,"");
    sscanf(buf1,"%s",keyword);

    if (start_flag) {
      strcat(command,buf1);
    }

    if (strcmp(keyword,"program_exec:")==0) {
      strcpy(buf2,"");
      sscanf(buf1,"%s %s",keyword,buf2);
      if (strlen(buf2)>0)
	strcpy(command,strstr(buf1+strlen(keyword),buf2));
      start_flag=True;
    }
    value_count++;
    if (value_count>1000) {
      fprintf(stderr,"Internal error (value_count too large)\n");
      exit(1);
    }
  }
  if (verbose)
    fprintf(stderr,"SetDefaultCommand: %s\n",command);

  set_default_command(command,item);

  ok_help_cancel_panel(item,(XtPointer)only_flag);

  if (only_flag)
    XtManageChild(dialog_window);

  return(item);
}


ok_selection(Widget w,char **values,XtPointer data)
{
  char command[1024],keyword[1024];
  int value_count=0,start_flag=False,rc=0;

  if (values[0]==NULL)
    return 0;

  if (verbose)
    fprintf(stderr,"Data passed: %d\n",data);

  strcpy(command,"");
  while (values[value_count]!=NULL) {
    strcpy(buf1,values[value_count]);
    if (verbose)
      fprintf(stderr,"%s \n",buf1);
    strcpy(keyword,"");
    sscanf(buf1,"%s",keyword);

    if (start_flag) {
      strcat(command,buf1);
    }

    if (strcmp(keyword,"program_exec:")==0) {
      strcpy(buf2,"");
      sscanf(buf1,"%s %s",keyword,buf2);
      if (strlen(buf2)>0)
	strcpy(command,strstr(buf1+strlen(keyword),buf2));
      start_flag=True;
    }
    value_count++;
    if (value_count>1000) {
      fprintf(stderr,"Internal error (value_count too large)\n");
      exit(1);
    }
  }

  if (verbose)
    fprintf(stderr,"Processing: %s\n",command);

  set_command(command,w);

  if (data) {
    sprintf(buf1,"xcat -busy -e \"%s; echo DONE\" &",command);
 
    system(buf1);
    return 0;
  }

  XtUnmanageChild(w);

  unmanage_dialog();
  
  return 0;
}

cancel_selection(Widget w,XtPointer data)
{
  if (data) 
    exit(0);

  XtUnmanageChild(w);

  unmanage_dialog();
}



 
XtCallbackProc sel_libCB(Widget w,
			 XtPointer client_data,
			 XmListCallbackStruct *call_data)
{
  Mod_lib *m;
  int count;
  
  current_lib=libs;
 
  for (count=1; count<call_data->item_position; count++) {
    current_lib=current_lib->next;
  }
  XmListDeleteAllItems(module_list);
 
    
  for (m= current_lib->mod_lib; m != (Mod_lib *) NULL; m= m->next) {
    XmListAddItem(module_list,XMstr(m->name),0);
  }
}
 
XtCallbackProc sel_moduleCB(Widget w,
			    XtPointer client_data,
			    XmListCallbackStruct *call_data)
{
  int count;
  Mod_lib *m;
 
  if (current_lib==NULL)
    current_lib=libs;
 
  m=current_lib->mod_lib;
 
  for (count=1; count<call_data->item_position; count++) {
    m=m->next;
  }
  map_dialog(NULL,m->name,0,0,0);
  
  draw_modules();
}


XtCallbackProc sel_module_name_okCB(Widget w,
				    XtPointer client_data,
				    XmSelectionBoxCallbackStruct *call_data)
{
  char *str;
 
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
 
  map_dialog(NULL,str,0,0,0);
  
  draw_modules();
}


XtCallbackProc sel_module_nameCB(Widget w,
				 XtPointer client_data,
				 XtPointer call_data)
{
  XtVaSetValues(prompt,
                XmNselectionLabelString,XMstr("Module by Name:"),
                XmNtextString,XMstr(""),
                XmNokCallback,CBl(sel_module_name_okCB,0),
                NULL);
  XtManageChild(prompt);
}

void manpageCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data)
{
  Mod_lib *current_module;
  int *module_item;
  int library_count=0,module_count,count;

  if (current_lib==NULL)
    current_lib=libs;

  if (XmListGetSelectedPos(module_list,&module_item,&module_count)==False)
    return;

  current_module= current_lib->mod_lib;

  for (count=1; count<*(module_item); count++) {
    current_module=current_module->next;
  }
  sprintf(buf1,"xcat -man -noscroll -e usp man %s &",current_module->name);
  system(buf1);

  free((char *)module_item);
  return;
}

create_main_window()
{
  Widget main_window;
  Widget menu_bar;
  Widget scroll_window;
  Widget work_area;
  Widget label;
  Widget button;
  Widget paned_window;
  Widget form;
  Widget library_list;
  Library *l;

  main_window=XmCreateMainWindowVa(top_level,"main",
				   XmNshowSeparator,True,
				   (char *)0);
  
  menu_bar=menubar(main_window);
  
  work_area=XmCreateFormVa(main_window,"form",
			   NULL);

  form=XmCreateFormVa(work_area,"form",
                      XmNbottomAttachment,XmATTACH_FORM,
                      XmNbottomOffset,10,
                      XmNleftAttachment,XmATTACH_FORM,
                      XmNleftOffset,10,
                      NULL);
 
  button=XmCreatePushButtonVa(form,"Man Page",
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNleftAttachment,XmATTACH_FORM,
                              XmNrightAttachment,XmATTACH_FORM,
			      XmNactivateCallback,
			      CBl(manpageCB,0),
                              NULL);

  button=XmCreatePushButtonVa(form,"Module by Name",
                              XmNbottomOffset,5,
                              XmNbottomAttachment, XmATTACH_WIDGET,
                              XmNbottomWidget, button,
                              XmNleftAttachment,XmATTACH_FORM,
                              XmNrightAttachment,XmATTACH_FORM,
			      XmNactivateCallback,
			      CBl(sel_module_nameCB,0),
                              NULL);
  

  paned_window=XmCreatePanedWindowVa(work_area,"paned",
                                     XmNtopAttachment,XmATTACH_FORM,
                                     XmNtopOffset,10,
                                     XmNbottomAttachment,XmATTACH_WIDGET,
                                     XmNbottomWidget,form,
                                     XmNbottomOffset,10,
                                     XmNleftAttachment,XmATTACH_FORM,
                                     XmNleftOffset,10,
                                     NULL);

  form=XmCreateFormVa(paned_window,"form",
                      NULL);
 
  label=XmCreateLabelVa(form,"Library List",
                        NULL);
 
  library_list=XmCreateScrolledListVa(form,"library_list",
                                      XmNlistSizePolicy,XmCONSTANT,
                                      XmNscrollBarDisplayPolicy,XmSTATIC,
                                      XmNvisibleItemCount,15,
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget,label,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNleftAttachment,XmATTACH_FORM,
                                      XmNbottomAttachment,XmATTACH_FORM,
                                      XmNbottomOffset,10,
                                      XmNdefaultActionCallback,
				      CBl(sel_libCB,0),
                                      NULL);
 
  if (libs!=NULL)
    for (l= libs; l != (Library *) NULL; l= l->next) {
      XmListAddItem(library_list,XMstr(l->name),0);
    }
 
  form=XmCreateFormVa(paned_window,"form",
                      NULL);
 
  label=XmCreateLabelVa(form,"Module List",
                        NULL);
 
  module_list=XmCreateScrolledListVa(form,"module_list",
                                     XmNlistSizePolicy,XmCONSTANT,
                                     XmNscrollBarDisplayPolicy,XmSTATIC,
                                     XmNvisibleItemCount,12,
                                     XmNtopAttachment,XmATTACH_WIDGET,
                                     XmNtopWidget,label,
                                     XmNrightAttachment,XmATTACH_FORM,
                                     XmNleftAttachment,XmATTACH_FORM,
                                     XmNbottomAttachment,XmATTACH_FORM,
                                     XmNdefaultActionCallback,
				     CBl(sel_moduleCB,0),
                                     NULL);
 
  
  scroll_window=XmCreateScrolledWindowVa(work_area,"scroll",
					 XmNwidth, WIDTH+50,
					 XmNheight,HEIGHT+50,
					 XmNtopAttachment,XmATTACH_FORM,
					 XmNbottomAttachment,XmATTACH_FORM,
					 XmNleftAttachment,XmATTACH_WIDGET,
					 XmNleftWidget,paned_window,
					 XmNleftOffset,10,
					 XmNrightAttachment,XmATTACH_FORM,
					 XmNscrollingPolicy,XmAUTOMATIC,
					 NULL);

  draw_area=XmCreateDrawingAreaVa(scroll_window,"draw",
				  XmNwidth, WIDTH,
				  XmNheight,HEIGHT,
				  XmNexposeCallback,CBl(draw_moduleCB,0),
				  NULL);

                                     /* Set up event handlers. */
  XtAddEventHandler(draw_area,ButtonPressMask,False,button_pushEH,0);
  XtAddEventHandler(draw_area,ButtonReleaseMask,False,button_releaseEH,0);
  XtAddEventHandler(draw_area,PointerMotionMask,False,moving_mouseEH,0);
  
  XtVaSetValues(main_window,
		XmNmenuBar,menu_bar,
		XmNworkWindow,work_area,
/*                XmNmessageWindow,message_window, */
		XmNshowSeparator,True,
		NULL);

}

 
void prompt_box()
{
  prompt=XmCreatePromptDialogVa(top_level,"Prompt",
                                XtNmanageChild,False,
                                XmNautoUnmanage,True,
                                NULL);
 
}
